/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.robolectric.res.PackageResourceLoader;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;

class OverlayResourceIndex
extends ResourceIndex {
    private static final Logger LOGGER = Logger.getLogger(OverlayResourceIndex.class.getName());
    private final String packageName;
    private final Set<String> actualPackageNames = new HashSet<String>();
    private Integer maxUsedInt = null;

    public OverlayResourceIndex(String packageName, List<PackageResourceLoader> subResourceLoaders) {
        this(packageName, OverlayResourceIndex.map(subResourceLoaders));
    }

    private static ResourceIndex[] map(List<PackageResourceLoader> subResourceLoaders) {
        ResourceIndex[] resourceIndexes = new ResourceIndex[subResourceLoaders.size()];
        for (int i = 0; i < subResourceLoaders.size(); ++i) {
            resourceIndexes[i] = subResourceLoaders.get(i).getResourceIndex();
        }
        return resourceIndexes;
    }

    public OverlayResourceIndex(String packageName, ResourceIndex ... subResourceIndexes) {
        this.packageName = packageName;
        this.actualPackageNames.add(packageName);
        for (ResourceIndex subResourceIndex : subResourceIndexes) {
            this.actualPackageNames.addAll(subResourceIndex.getPackages());
            for (Map.Entry<ResName, Integer> entry : subResourceIndex.resourceNameToId.entrySet()) {
                ResName resName = entry.getKey();
                int value = entry.getValue();
                ResName localResName = resName.withPackageName(packageName);
                if (this.resourceNameToId.containsKey(localResName)) continue;
                this.resourceNameToId.put(localResName, value);
                this.resourceIdToResName.put(value, localResName);
            }
        }
    }

    @Override
    public Integer getResourceId(ResName resName) {
        if (!this.actualPackageNames.contains(resName.packageName)) {
            return null;
        }
        Integer id = (Integer)this.resourceNameToId.get(resName.withPackageName(this.packageName));
        if (id == null) {
            if (this.maxUsedInt == null) {
                this.maxUsedInt = this.resourceIdToResName.isEmpty() ? 0 : (Integer)Collections.max(this.resourceIdToResName.keySet());
            }
            id = this.maxUsedInt = Integer.valueOf(this.maxUsedInt + 1);
            this.resourceNameToId.put(resName, id);
            this.resourceIdToResName.put(id, resName);
            LOGGER.fine("no id mapping found for " + resName.getFullyQualifiedName() + "; assigning ID #0x" + Integer.toHexString(id));
        }
        return id;
    }

    @Override
    public ResName getResName(int resourceId) {
        ResName resName = (ResName)this.resourceIdToResName.get(resourceId);
        return resName == null ? null : resName.withPackageName(this.packageName);
    }

    @Override
    public Collection<String> getPackages() {
        return this.actualPackageNames;
    }

    public String toString() {
        return "OverlayResourceIndex{package='" + this.packageName + '\'' + '}';
    }
}

