/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.nio.file.Path;
import java.util.function.Predicate;

class DirBaseNameFilter
implements Predicate<Path> {
    private final String prefix;
    private final String prefixDash;

    DirBaseNameFilter(String prefix) {
        this.prefix = prefix;
        this.prefixDash = prefix + "-";
    }

    @Override
    public boolean test(Path file) {
        String fileName = this.nameWithoutTrailingSeparator(file);
        return fileName.equals(this.prefix) || fileName.startsWith(this.prefixDash);
    }

    private String nameWithoutTrailingSeparator(Path file) {
        String fileName = file.getFileName().toString();
        int trailingSlash = fileName.indexOf(47);
        if (trailingSlash != -1) {
            fileName = fileName.substring(0, trailingSlash);
        }
        return fileName;
    }
}

