/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.res.android.ConfigDescription;
import org.robolectric.res.android.ResTable_config;

public class Qualifiers {
    private static final Pattern DIR_QUALIFIER_PATTERN = Pattern.compile("^[^-]+(?:-([^/]*))?/?$");
    private static final Pattern SCREEN_WIDTH_PATTERN = Pattern.compile("^w([0-9]+)dp");
    private static final Pattern SMALLEST_SCREEN_WIDTH_PATTERN = Pattern.compile("^sw([0-9]+)dp");
    private static final Pattern VERSION_QUALIFIER_PATTERN = Pattern.compile("(v)([0-9]+)$");
    private static final Pattern ORIENTATION_QUALIFIER_PATTERN = Pattern.compile("(land|port)");
    private final String qualifiers;
    private final ResTable_config config;

    public static Qualifiers parse(String qualifiers) {
        return Qualifiers.parse(qualifiers, true);
    }

    public static Qualifiers parse(String qualifiers, boolean applyVersionForCompat) {
        ResTable_config config = new ResTable_config();
        if (!qualifiers.isEmpty() && !ConfigDescription.parse(qualifiers, config, applyVersionForCompat)) {
            throw new IllegalArgumentException("failed to parse qualifiers '" + qualifiers + "'. See https://developer.android.com/guide/topics/resources/providing-resources.html#QualifierRules for expected format.");
        }
        return new Qualifiers(qualifiers, config);
    }

    protected Qualifiers(String qualifiers, ResTable_config config) {
        this.qualifiers = qualifiers;
        this.config = config;
    }

    public ResTable_config getConfig() {
        return this.config;
    }

    public String toString() {
        return this.qualifiers;
    }

    public static Qualifiers fromParentDir(Path parentDir) {
        if (parentDir == null) {
            return Qualifiers.parse("");
        }
        String parentDirName = parentDir.getFileName().toString();
        Matcher matcher = DIR_QUALIFIER_PATTERN.matcher(parentDirName);
        if (!matcher.find()) {
            throw new IllegalStateException(parentDirName);
        }
        String qualifiers = matcher.group(1);
        return Qualifiers.parse(qualifiers != null ? qualifiers : "");
    }

    @Deprecated
    public static int getPlatformVersion(String qualifiers) {
        Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifiers);
        if (m.find()) {
            return Integer.parseInt(m.group(2));
        }
        return -1;
    }

    @Deprecated
    public static int getSmallestScreenWidth(String qualifiers) {
        for (String qualifier : qualifiers.split("-", 0)) {
            Matcher matcher = SMALLEST_SCREEN_WIDTH_PATTERN.matcher(qualifier);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    @Deprecated
    public static String addPlatformVersion(String qualifiers, int apiLevel) {
        int versionQualifierApiLevel = Qualifiers.getPlatformVersion(qualifiers);
        if (versionQualifierApiLevel == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "v" + apiLevel;
        }
        return qualifiers;
    }

    @Deprecated
    public static String addSmallestScreenWidth(String qualifiers, int smallestScreenWidth) {
        int qualifiersSmallestScreenWidth = Qualifiers.getSmallestScreenWidth(qualifiers);
        if (qualifiersSmallestScreenWidth == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "sw" + smallestScreenWidth + "dp";
        }
        return qualifiers;
    }

    @Deprecated
    public static int getScreenWidth(String qualifiers) {
        for (String qualifier : qualifiers.split("-", 0)) {
            Matcher matcher = SCREEN_WIDTH_PATTERN.matcher(qualifier);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    @Deprecated
    public static String addScreenWidth(String qualifiers, int screenWidth) {
        int qualifiersScreenWidth = Qualifiers.getScreenWidth(qualifiers);
        if (qualifiersScreenWidth == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "w" + screenWidth + "dp";
        }
        return qualifiers;
    }

    @Deprecated
    public static String getOrientation(String qualifiers) {
        for (String qualifier : qualifiers.split("-", 0)) {
            Matcher matcher = ORIENTATION_QUALIFIER_PATTERN.matcher(qualifier);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

