/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;

public class DrawableResourceLoader {
    private final PackageResourceTable resourceTable;

    DrawableResourceLoader(PackageResourceTable resourceTable) {
        this.resourceTable = resourceTable;
    }

    void findDrawableResources(ResourcePath resourcePath) throws IOException {
        Path[] files = Fs.listFiles(resourcePath.getResourceBase());
        if (files != null) {
            for (Path f : files) {
                if (Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().startsWith("drawable")) {
                    this.listDrawableResources(f, "drawable");
                    continue;
                }
                if (!Files.isDirectory(f, new LinkOption[0]) || !f.getFileName().toString().startsWith("mipmap")) continue;
                this.listDrawableResources(f, "mipmap");
            }
        }
    }

    private void listDrawableResources(Path dir, String type) throws IOException {
        Path[] files = Fs.listFiles(dir);
        if (files != null) {
            Qualifiers qualifiers;
            try {
                qualifiers = Qualifiers.fromParentDir(dir);
            }
            catch (IllegalArgumentException e) {
                Logger.warn((String)(dir + ": " + e.getMessage()), (Object[])new Object[0]);
                return;
            }
            for (Path f : files) {
                boolean isNinePatch;
                String shortName;
                String name = f.getFileName().toString();
                if (name.startsWith(".") || name.endsWith(".xml")) continue;
                if (name.endsWith(".9.png")) {
                    String[] tokens = name.split("\\.9\\.png$", -1);
                    shortName = tokens[0];
                    isNinePatch = true;
                } else {
                    shortName = Fs.baseNameFor(f);
                    isNinePatch = false;
                }
                XmlContext fakeXmlContext = new XmlContext(this.resourceTable.getPackageName(), f, qualifiers);
                this.resourceTable.addResource(type, shortName, new FileTypedResource.Image(f, isNinePatch, fakeXmlContext));
            }
        }
    }
}

