/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.res.android.DynamicRefTable;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;

public class ResXMLTree {
    final DynamicRefTable mDynamicRefTable;
    public final ResXMLParser mParser;
    int mError;
    byte[] mOwnedData;
    XmlBuffer mBuffer;
    ResourceTypes.ResXMLTree_header mHeader;
    int mSize;
    int mDataLen;
    ResStringPool mStrings = new ResStringPool();
    int[] mResIds;
    int mNumResIds;
    ResourceTypes.ResXMLTree_node mRootNode;
    int mRootExt;
    int mRootCode;
    static volatile AtomicInteger gCount = new AtomicInteger(0);

    public ResXMLTree(DynamicRefTable dynamicRefTable) {
        this.mParser = new ResXMLParser(this);
        this.mDynamicRefTable = dynamicRefTable;
        this.mError = -2147483642;
        this.mOwnedData = null;
        this.mParser.restart();
    }

    protected void finalize() {
        this.uninit();
    }

    public int setTo(byte[] data, int size, boolean copyData) {
        ResourceTypes.ResChunk_header chunk;
        this.uninit();
        this.mParser.mEventCode = 0;
        if (!Util.isTruthy(data) || !Util.isTruthy(size)) {
            this.mError = -2147483646;
            return -2147483646;
        }
        if (copyData) {
            this.mOwnedData = new byte[size];
            System.arraycopy(data, 0, this.mOwnedData, 0, size);
            data = this.mOwnedData;
        }
        this.mBuffer = new XmlBuffer(data);
        this.mHeader = new ResourceTypes.ResXMLTree_header(this.mBuffer.buf, 0);
        this.mSize = Util.dtohl(this.mHeader.header.size);
        if (Util.dtohs(this.mHeader.header.headerSize) > this.mSize || this.mSize > size) {
            Util.ALOGW("Bad XML block: header size %d or total size %d is larger than data size %d\n", Util.dtohs(this.mHeader.header.headerSize), Util.dtohl(this.mHeader.header.size), size);
            this.mError = -2147483646;
            this.mParser.restart();
            return this.mError;
        }
        this.mDataLen = this.mSize;
        this.mStrings.uninit();
        this.mRootNode = null;
        this.mResIds = null;
        this.mNumResIds = 0;
        ResourceTypes.ResChunk_header lastChunk = chunk = new ResourceTypes.ResChunk_header(this.mBuffer.buf, this.mHeader.header.headerSize);
        while (chunk.myOffset() < this.mDataLen - ResourceTypes.ResChunk_header.SIZEOF && chunk.myOffset() < this.mDataLen - Util.dtohl(chunk.size)) {
            int err = ResourceTypes.validate_chunk(chunk, ResourceTypes.ResChunk_header.SIZEOF, this.mDataLen, "XML");
            if (err != 0) {
                this.mError = err;
                this.mParser.restart();
                return this.mError;
            }
            short type = Util.dtohs(chunk.type);
            int size1 = Util.dtohl(chunk.size);
            if (type == 1) {
                this.mStrings.setTo(this.mBuffer.buf, chunk.myOffset(), size, false);
            } else if (type == 384) {
                this.mNumResIds = (Util.dtohl(chunk.size) - Util.dtohs(chunk.headerSize)) / 4;
                this.mResIds = new int[this.mNumResIds];
                for (int i = 0; i < this.mNumResIds; ++i) {
                    this.mResIds[i] = this.mBuffer.buf.getInt(chunk.myOffset() + chunk.headerSize + i * 4);
                }
            } else if (type >= 256 && type <= 383) {
                if (this.validateNode(new ResourceTypes.ResXMLTree_node(this.mBuffer.buf, chunk)) != 0) {
                    this.mError = -2147483646;
                    this.mParser.restart();
                    return this.mError;
                }
                this.mParser.mCurNode = new ResourceTypes.ResXMLTree_node(this.mBuffer.buf, lastChunk.myOffset());
                if (this.mParser.nextNode() == -1) {
                    this.mError = -2147483646;
                    this.mParser.restart();
                    return this.mError;
                }
                this.mRootNode = this.mParser.mCurNode;
                this.mRootExt = this.mParser.mCurExt;
                this.mRootCode = this.mParser.mEventCode;
                break;
            }
            lastChunk = chunk;
            chunk = new ResourceTypes.ResChunk_header(this.mBuffer.buf, chunk.myOffset() + size1);
        }
        if (this.mRootNode == null) {
            Util.ALOGW("Bad XML block: no root element node found\n", new Object[0]);
            this.mError = -2147483646;
            this.mParser.restart();
            return this.mError;
        }
        this.mError = this.mStrings.getError();
        this.mParser.restart();
        return this.mError;
    }

    public int getError() {
        return this.mError;
    }

    void uninit() {
        this.mError = -2147483642;
        this.mStrings.uninit();
        if (Util.isTruthy(this.mOwnedData)) {
            this.mOwnedData = null;
        }
        this.mParser.restart();
    }

    int validateNode(ResourceTypes.ResXMLTree_node node) {
        short eventCode = Util.dtohs(node.header.type);
        int err = ResourceTypes.validate_chunk(node.header, ResXMLParser.SIZEOF_RESXMLTREE_NODE, this.mDataLen, "ResXMLTree_node");
        if (err >= 0) {
            if (eventCode != 258) {
                return 0;
            }
            short headerSize = Util.dtohs(node.header.headerSize);
            int size = Util.dtohl(node.header.size);
            ResourceTypes.ResXMLTree_attrExt attrExt = new ResourceTypes.ResXMLTree_attrExt(this.mBuffer.buf, node.myOffset() + headerSize);
            if (size >= headerSize + 20 && attrExt.myOffset() > node.myOffset()) {
                int attrSize = Util.dtohs(attrExt.attributeSize) * Util.dtohs(attrExt.attributeCount);
                if (Util.dtohs(attrExt.attributeStart) + attrSize <= size - headerSize) {
                    return 0;
                }
                Util.ALOGW("Bad XML block: node attributes use 0x%x bytes, only have 0x%x bytes\n", Util.dtohs(attrExt.attributeStart) + attrSize, size - headerSize);
            } else {
                Util.ALOGW("Bad XML start block: node header size 0x%x, size 0x%x\n", headerSize, size);
            }
            return -2147483646;
        }
        return err;
    }

    public ResStringPool getStrings() {
        return this.mParser.getStrings();
    }

    static class XmlBuffer {
        final ByteBuffer buf;

        public XmlBuffer(byte[] data) {
            this.buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

