/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.roaringbitmap.art.Art;
import org.roaringbitmap.art.LeafNode;
import org.roaringbitmap.art.Node16;
import org.roaringbitmap.art.Node256;
import org.roaringbitmap.art.Node4;
import org.roaringbitmap.art.Node48;
import org.roaringbitmap.art.NodeType;

public abstract class Node {
    protected abstract Node clone();

    protected static byte[] sortSmallByteArray(byte[] key, Node[] children, int left, int right) {
        int i;
        int j = i = left;
        while (i < right) {
            byte ai = key[i + 1];
            Node child = children[i + 1];
            int unsignedByteAi = Byte.toUnsignedInt(ai);
            while (unsignedByteAi < Byte.toUnsignedInt(key[j])) {
                key[j + 1] = key[j];
                children[j + 1] = children[j];
                if (j-- != left) continue;
            }
            key[j + 1] = ai;
            children[j + 1] = child;
            j = ++i;
        }
        return key;
    }

    public void serialize(DataOutput dataOutput) throws IOException {
        this.serializeHeader(dataOutput);
        this.serializeNodeBody(dataOutput);
    }

    public void serialize(ByteBuffer byteBuffer) throws IOException {
        this.serializeHeader(byteBuffer);
        this.serializeNodeBody(byteBuffer);
    }

    public int serializeSizeInBytes() {
        int size = 0;
        size += this.serializeHeaderSizeInBytes();
        return size += this.serializeNodeBodySizeInBytes();
    }

    public static Node deserialize(DataInput dataInput) throws IOException {
        Node node = Node.deserializeHeader(dataInput);
        if (node != null) {
            node.deserializeNodeBody(dataInput);
            return node;
        }
        return null;
    }

    public static Node deserialize(ByteBuffer byteBuffer) throws IOException {
        Node node = Node.deserializeHeader(byteBuffer);
        if (node != null) {
            node.deserializeNodeBody(byteBuffer);
            return node;
        }
        return null;
    }

    abstract void serializeNodeBody(DataOutput var1) throws IOException;

    abstract void serializeNodeBody(ByteBuffer var1) throws IOException;

    abstract void deserializeNodeBody(DataInput var1) throws IOException;

    abstract void deserializeNodeBody(ByteBuffer var1) throws IOException;

    public abstract int serializeNodeBodySizeInBytes();

    protected abstract void serializeHeader(DataOutput var1) throws IOException;

    protected abstract void serializeHeader(ByteBuffer var1) throws IOException;

    protected int serializeHeaderSizeInBytes() {
        return 4;
    }

    private static Node deserializeHeader(DataInput dataInput) throws IOException {
        byte[] prefix;
        byte nodeTypeOrdinal = dataInput.readByte();
        short count = Short.reverseBytes(dataInput.readShort());
        byte prefixLength = dataInput.readByte();
        if (prefixLength == 0) {
            prefix = Art.EMPTY_BYTES;
        } else {
            prefix = new byte[prefixLength];
            dataInput.readFully(prefix);
        }
        if (nodeTypeOrdinal == NodeType.NODE4.ordinal()) {
            Node4 node4 = new Node4(prefixLength);
            node4.prefix = prefix;
            node4.count = count;
            return node4;
        }
        if (nodeTypeOrdinal == NodeType.NODE16.ordinal()) {
            Node16 node16 = new Node16(prefixLength);
            node16.prefix = prefix;
            node16.count = count;
            return node16;
        }
        if (nodeTypeOrdinal == NodeType.NODE48.ordinal()) {
            Node48 node48 = new Node48(prefixLength);
            node48.prefix = prefix;
            node48.count = count;
            return node48;
        }
        if (nodeTypeOrdinal == NodeType.NODE256.ordinal()) {
            Node256 node256 = new Node256(prefixLength);
            node256.prefix = prefix;
            node256.count = count;
            return node256;
        }
        if (nodeTypeOrdinal == NodeType.LEAF_NODE.ordinal()) {
            return new LeafNode(0L, 0L);
        }
        return null;
    }

    private static Node deserializeHeader(ByteBuffer byteBuffer) throws IOException {
        byte[] prefix;
        byte nodeTypeOrdinal = byteBuffer.get();
        short count = byteBuffer.getShort();
        byte prefixLength = byteBuffer.get();
        if (prefixLength == 0) {
            prefix = Art.EMPTY_BYTES;
        } else {
            prefix = new byte[prefixLength];
            byteBuffer.get(prefix);
        }
        if (nodeTypeOrdinal == NodeType.NODE4.ordinal()) {
            Node4 node4 = new Node4(prefixLength);
            node4.prefix = prefix;
            node4.count = count;
            return node4;
        }
        if (nodeTypeOrdinal == NodeType.NODE16.ordinal()) {
            Node16 node16 = new Node16(prefixLength);
            node16.prefix = prefix;
            node16.count = count;
            return node16;
        }
        if (nodeTypeOrdinal == NodeType.NODE48.ordinal()) {
            Node48 node48 = new Node48(prefixLength);
            node48.prefix = prefix;
            node48.count = count;
            return node48;
        }
        if (nodeTypeOrdinal == NodeType.NODE256.ordinal()) {
            Node256 node256 = new Node256(prefixLength);
            node256.prefix = prefix;
            node256.count = count;
            return node256;
        }
        if (nodeTypeOrdinal == NodeType.LEAF_NODE.ordinal()) {
            return new LeafNode(0L, 0L);
        }
        return null;
    }
}

