/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.roaringbitmap.art.Art;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.art.SearchResult;

public abstract class BranchNode
extends Node {
    protected byte[] prefix;
    protected short count;
    public static final int ILLEGAL_IDX = -1;

    public BranchNode(int compressedPrefixSize) {
        this.prefix = compressedPrefixSize == 0 ? Art.EMPTY_BYTES : new byte[compressedPrefixSize];
        this.count = 0;
    }

    public void postClone(BranchNode newlyCloned, Node[] oldChildren, Node[] newChildren) {
        newlyCloned.count = this.count;
        if (this.prefix.length > 0) {
            newlyCloned.prefix = Arrays.copyOf(this.prefix, this.prefix.length);
        }
        for (int i = 0; i < oldChildren.length; ++i) {
            if (oldChildren[i] == null) continue;
            newChildren[i] = oldChildren[i].clone();
        }
    }

    protected abstract NodeType nodeType();

    protected byte prefixLength() {
        return (byte)this.prefix.length;
    }

    public static int binarySearch(byte[] key, int fromIndex, int toIndex, byte k) {
        int inputUnsignedByte = Byte.toUnsignedInt(k);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = Byte.toUnsignedInt(key[mid]);
            if (midVal < inputUnsignedByte) {
                low = mid + 1;
                continue;
            }
            if (midVal > inputUnsignedByte) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    static SearchResult binarySearchWithResult(byte[] key, int fromIndex, int toIndex, byte k) {
        int inputUnsignedByte = Byte.toUnsignedInt(k);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low != high) {
            int mid = low + high + 1 >>> 1;
            int midVal = Byte.toUnsignedInt(key[mid]);
            if (midVal > inputUnsignedByte) {
                high = mid - 1;
                continue;
            }
            low = mid;
        }
        int val = Byte.toUnsignedInt(key[low]);
        if (val == inputUnsignedByte) {
            return SearchResult.found(low);
        }
        if (val < inputUnsignedByte) {
            int highIndex = low + 1;
            return SearchResult.notFound(low, highIndex < toIndex ? highIndex : -1);
        }
        return SearchResult.notFound(low - 1, low);
    }

    protected abstract BranchNode insert(Node var1, byte var2);

    public static void copyPrefix(BranchNode src, BranchNode dst) {
        System.arraycopy(src.prefix, 0, dst.prefix, 0, src.prefixLength());
    }

    abstract void replaceChildren(Node[] var1);

    public abstract int getChildPos(byte var1);

    public abstract SearchResult getNearestChildPos(byte var1);

    public abstract byte getChildKey(int var1);

    public abstract Node getChild(int var1);

    public abstract Node getChildAtKey(byte var1);

    public abstract void replaceNode(int var1, Node var2);

    public abstract int getMinPos();

    public abstract int getNextLargerPos(int var1);

    public abstract int getMaxPos();

    public abstract int getNextSmallerPos(int var1);

    public abstract Node remove(int var1);

    @Override
    protected void serializeHeader(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.nodeType().ordinal());
        dataOutput.writeShort(Short.reverseBytes(this.count));
        byte prefixLength = this.prefixLength();
        dataOutput.writeByte(prefixLength);
        if (prefixLength > 0) {
            dataOutput.write(this.prefix, 0, prefixLength);
        }
    }

    @Override
    protected void serializeHeader(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)this.nodeType().ordinal());
        byteBuffer.putShort(this.count);
        byte prefixLength = this.prefixLength();
        byteBuffer.put(prefixLength);
        if (prefixLength > 0) {
            byteBuffer.put(this.prefix, 0, prefixLength);
        }
    }

    @Override
    protected int serializeHeaderSizeInBytes() {
        return super.serializeHeaderSizeInBytes() + this.prefixLength();
    }
}

