/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.AppendableStorage;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.CharIterator;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.FastAggregation;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.IntConsumerRelativeRangeAdapter;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RelativeRangeConsumer;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBatchIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.longlong.LongUtils;

public class RoaringBitmap
implements Cloneable,
Serializable,
Iterable<Integer>,
Externalizable,
ImmutableBitmapDataProvider,
BitmapDataProvider,
AppendableStorage<Container> {
    private static final long serialVersionUID = 6L;
    RoaringArray highLowContainer = null;

    private static void rangeSanityCheck(long rangeStart, long rangeEnd) {
        if (rangeStart < 0L || rangeStart > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("rangeStart=" + rangeStart + " should be in [0, 0xffffffff]");
        }
        if (rangeEnd > 0x100000000L || rangeEnd < 0L) {
            throw new IllegalArgumentException("rangeEnd=" + rangeEnd + " should be in [0, 0xffffffff + 1]");
        }
    }

    public static RoaringBitmap addOffset(RoaringBitmap x, long offset) {
        long container_offset_long;
        long l = container_offset_long = offset < 0L ? (offset - 65536L + 1L) / 65536L : offset / 65536L;
        if (container_offset_long < -65536L || container_offset_long >= 65536L) {
            return new RoaringBitmap();
        }
        int container_offset = (int)container_offset_long;
        int in_container_offset = (int)(offset - container_offset_long * 65536L);
        if (in_container_offset == 0) {
            RoaringBitmap answer = new RoaringBitmap();
            for (int pos = 0; pos < x.highLowContainer.size(); ++pos) {
                int key = x.highLowContainer.getKeyAtIndex(pos);
                answer.highLowContainer.append((char)(key += container_offset), x.highLowContainer.getContainerAtIndex(pos).clone());
            }
            return answer;
        }
        RoaringBitmap answer = new RoaringBitmap();
        for (int pos = 0; pos < x.highLowContainer.size(); ++pos) {
            boolean keypok;
            int key = x.highLowContainer.getKeyAtIndex(pos);
            if ((key += container_offset) + 1 < 0 || key > 65535) continue;
            Container c = x.highLowContainer.getContainerAtIndex(pos);
            Container[] offsetted = Util.addOffset(c, (char)in_container_offset);
            boolean keyok = key >= 0;
            boolean bl = keypok = key + 1 <= 65535;
            if (!offsetted[0].isEmpty() && keyok) {
                int current_size = answer.highLowContainer.size();
                int lastkey = 0;
                if (current_size > 0) {
                    lastkey = answer.highLowContainer.getKeyAtIndex(current_size - 1);
                }
                if (current_size > 0 && lastkey == key) {
                    Container prev = answer.highLowContainer.getContainerAtIndex(current_size - 1);
                    Container orresult = prev.ior(offsetted[0]);
                    answer.highLowContainer.setContainerAtIndex(current_size - 1, orresult);
                } else {
                    answer.highLowContainer.append((char)key, offsetted[0]);
                }
            }
            if (offsetted[1].isEmpty() || !keypok) continue;
            answer.highLowContainer.append((char)(key + 1), offsetted[1]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap add(RoaringBitmap rb, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return rb.clone();
        }
        char hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        char lbLast = Util.lowbits(rangeEnd - 1L);
        RoaringBitmap answer = new RoaringBitmap();
        answer.highLowContainer.appendCopiesUntil(rb.highLowContainer, hbStart);
        if (hbStart == hbLast) {
            int i = rb.highLowContainer.getIndex(hbStart);
            Container c = i >= 0 ? rb.highLowContainer.getContainerAtIndex(i).add(lbStart, lbLast + '\u0001') : Container.rangeOfOnes(lbStart, lbLast + '\u0001');
            answer.highLowContainer.append(hbStart, c);
            answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, hbLast);
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex(hbStart);
        int ilast = rb.highLowContainer.getIndex(hbLast);
        Container c = ifirst >= 0 ? rb.highLowContainer.getContainerAtIndex(ifirst).add(lbStart, Util.maxLowBitAsInteger() + 1) : Container.rangeOfOnes(lbStart, Util.maxLowBitAsInteger() + 1);
        answer.highLowContainer.append(hbStart, c);
        for (int hb = hbStart + '\u0001'; hb < hbLast; ++hb) {
            Container c2 = Container.rangeOfOnes(0, Util.maxLowBitAsInteger() + 1);
            answer.highLowContainer.append((char)hb, c2);
        }
        c = ilast >= 0 ? rb.highLowContainer.getContainerAtIndex(ilast).add(0, lbLast + '\u0001') : Container.rangeOfOnes(0, lbLast + '\u0001');
        answer.highLowContainer.append(hbLast, c);
        answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, hbLast);
        return answer;
    }

    public Boolean validate() {
        return this.highLowContainer.validate();
    }

    @Deprecated
    public static RoaringBitmap add(RoaringBitmap rb, int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            return RoaringBitmap.add(rb, (long)rangeStart, (long)rangeEnd);
        }
        return RoaringBitmap.add(rb, (long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public static RoaringBitmap and(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.and(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    answer.highLowContainer.append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static int andCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        int answer = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                answer += c1.andCardinality(c2);
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.andNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    answer.highLowContainer.append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                int nextPos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, nextPos1);
                pos1 = nextPos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public void add(int ... dat) {
        this.addN(dat, 0, dat.length);
    }

    public void addN(int[] dat, int offset, int n) {
        if (n < 0 || offset < 0) {
            throw new IllegalArgumentException("Negative values do not make sense.");
        }
        if (n == 0) {
            return;
        }
        if (offset + n > dat.length) {
            throw new IllegalArgumentException("Data source is too small.");
        }
        Container currentcont = null;
        int j = 0;
        int val = dat[j + offset];
        char currenthb = Util.highbits(val);
        int currentcontainerindex = this.highLowContainer.getIndex(currenthb);
        if (currentcontainerindex >= 0) {
            currentcont = this.highLowContainer.getContainerAtIndex(currentcontainerindex);
            Container newcont = currentcont.add(Util.lowbits(val));
            if (newcont != currentcont) {
                this.highLowContainer.setContainerAtIndex(currentcontainerindex, newcont);
                currentcont = newcont;
            }
        } else {
            currentcontainerindex = -currentcontainerindex - 1;
            ArrayContainer newac = new ArrayContainer();
            currentcont = newac.add(Util.lowbits(val));
            this.highLowContainer.insertNewKeyValueAt(currentcontainerindex, currenthb, currentcont);
        }
        ++j;
        while (j < n) {
            Container newcont;
            val = dat[j + offset];
            char newhb = Util.highbits(val);
            if (currenthb == newhb) {
                newcont = currentcont.add(Util.lowbits(val));
                if (newcont != currentcont) {
                    this.highLowContainer.setContainerAtIndex(currentcontainerindex, newcont);
                    currentcont = newcont;
                }
            } else {
                currenthb = newhb;
                currentcontainerindex = this.highLowContainer.getIndex(currenthb);
                if (currentcontainerindex >= 0) {
                    currentcont = this.highLowContainer.getContainerAtIndex(currentcontainerindex);
                    newcont = currentcont.add(Util.lowbits(val));
                    if (newcont != currentcont) {
                        this.highLowContainer.setContainerAtIndex(currentcontainerindex, newcont);
                        currentcont = newcont;
                    }
                } else {
                    currentcontainerindex = -currentcontainerindex - 1;
                    ArrayContainer newac = new ArrayContainer();
                    currentcont = newac.add(Util.lowbits(val));
                    this.highLowContainer.insertNewKeyValueAt(currentcontainerindex, currenthb, currentcont);
                }
            }
            ++j;
        }
    }

    public static RoaringBitmap bitmapOf(int ... dat) {
        RoaringBitmap ans = new RoaringBitmap();
        ans.add(dat);
        return ans;
    }

    public static RoaringBitmap bitmapOfUnordered(int ... data) {
        Object writer = RoaringBitmapWriter.writer().constantMemory().doPartialRadixSort().get();
        writer.addMany(data);
        writer.flush();
        return (RoaringBitmap)writer.getUnderlying();
    }

    public static RoaringBitmap bitmapOfRange(long min, long max) {
        RoaringBitmap.rangeSanityCheck(min, max);
        if (min >= max) {
            return new RoaringBitmap();
        }
        char hbStart = Util.highbits(min);
        char lbStart = Util.lowbits(min);
        char hbLast = Util.highbits(max - 1L);
        char lbLast = Util.lowbits(max - 1L);
        RoaringArray array = new RoaringArray(hbLast - hbStart + 1);
        RoaringBitmap bitmap = new RoaringBitmap(array);
        int firstEnd = hbStart < hbLast ? 65536 : lbLast + '\u0001';
        Container firstContainer = RunContainer.rangeOfOnes(lbStart, firstEnd);
        bitmap.append(hbStart, firstContainer);
        if (hbStart < hbLast) {
            for (int i = hbStart + '\u0001'; i < hbLast; ++i) {
                Container runContainer = RunContainer.rangeOfOnes(0, 65536);
                bitmap.append((char)i, runContainer);
            }
            Container lastContainer = RunContainer.rangeOfOnes(0, lbLast + '\u0001');
            bitmap.append(hbLast, lastContainer);
        }
        return bitmap;
    }

    public static RoaringBitmap flip(RoaringBitmap bm, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return bm.clone();
        }
        RoaringBitmap answer = new RoaringBitmap();
        int hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        int lbLast = Util.lowbits(rangeEnd - 1L);
        answer.highLowContainer.appendCopiesUntil(bm.highLowContainer, (char)hbStart);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = bm.highLowContainer.getIndex((char)hb);
            int j = answer.highLowContainer.getIndex((char)hb);
            assert (j < 0);
            if (i >= 0) {
                Container c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast + 1);
                if (c.isEmpty()) continue;
                answer.highLowContainer.insertNewKeyValueAt(-j - 1, (char)hb, c);
                continue;
            }
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, (char)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
        answer.highLowContainer.appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    @Deprecated
    public static RoaringBitmap flip(RoaringBitmap rb, int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            return RoaringBitmap.flip(rb, (long)rangeStart, (long)rangeEnd);
        }
        return RoaringBitmap.flip(rb, (long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public static boolean intersects(RoaringBitmap x1, RoaringBitmap x2) {
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                if (c1.intersects(c2 = x2.highLowContainer.getContainerAtIndex(pos2))) {
                    return true;
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return false;
    }

    protected static RoaringBitmap lazyor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).lazyOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    protected static RoaringBitmap lazyorfromlazyinputs(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                Container c1;
                if (s1 == s2) {
                    c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                    Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                    if (c2 instanceof BitmapContainer && !(c1 instanceof BitmapContainer)) {
                        Container tmp = c1;
                        c1 = c2;
                        c2 = tmp;
                    }
                    answer.highLowContainer.append(s1, c1.lazyIOR(c2));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                    answer.highLowContainer.append(s1, c1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                answer.highLowContainer.append(s2, c2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.append(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.append(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap or(Iterator<? extends RoaringBitmap> bitmaps) {
        return FastAggregation.or(bitmaps);
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        return FastAggregation.or(bitmaps);
    }

    public static RoaringBitmap or(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static int orCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        return x1.getCardinality() + x2.getCardinality() - RoaringBitmap.andCardinality(x1, x2);
    }

    public static int xorCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        return x1.getCardinality() + x2.getCardinality() - 2 * RoaringBitmap.andCardinality(x1, x2);
    }

    public static int andNotCardinality(RoaringBitmap x1, RoaringBitmap x2) {
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (length2 > 4 * length1) {
            return x1.getCardinality() - RoaringBitmap.andCardinality(x1, x2);
        }
        long cardinality = 0L;
        int pos1 = 0;
        int pos2 = 0;
        block0: while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                Container c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                cardinality += (long)(c1.getCardinality() - c1.andCardinality(c2));
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                while (s1 < s2 && pos1 < length1) {
                    cardinality += (long)x1.highLowContainer.getContainerAtIndex(pos1).getCardinality();
                    if (++pos1 == length1) continue block0;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                }
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos2 == length2) {
            while (pos1 < length1) {
                cardinality += (long)x1.highLowContainer.getContainerAtIndex(pos1).getCardinality();
                ++pos1;
            }
        }
        return (int)cardinality;
    }

    public static RoaringBitmap remove(RoaringBitmap rb, long rangeStart, long rangeEnd) {
        Container c;
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return rb.clone();
        }
        char hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        char lbLast = Util.lowbits(rangeEnd - 1L);
        RoaringBitmap answer = new RoaringBitmap();
        answer.highLowContainer.appendCopiesUntil(rb.highLowContainer, hbStart);
        if (hbStart == hbLast) {
            Container c2;
            int i = rb.highLowContainer.getIndex(hbStart);
            if (i >= 0 && !(c2 = rb.highLowContainer.getContainerAtIndex(i).remove(lbStart, lbLast + '\u0001')).isEmpty()) {
                answer.highLowContainer.append(hbStart, c2);
            }
            answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, hbLast);
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex(hbStart);
        int ilast = rb.highLowContainer.getIndex(hbLast);
        if (ifirst >= 0 && lbStart != '\u0000' && !(c = rb.highLowContainer.getContainerAtIndex(ifirst).remove(lbStart, Util.maxLowBitAsInteger() + 1)).isEmpty()) {
            answer.highLowContainer.append(hbStart, c);
        }
        if (ilast >= 0 && lbLast != Util.maxLowBitAsInteger() && !(c = rb.highLowContainer.getContainerAtIndex(ilast).remove(0, lbLast + '\u0001')).isEmpty()) {
            answer.highLowContainer.append(hbLast, c);
        }
        answer.highLowContainer.appendCopiesAfter(rb.highLowContainer, hbLast);
        return answer;
    }

    @Deprecated
    public static RoaringBitmap remove(RoaringBitmap rb, int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            return RoaringBitmap.remove(rb, (long)rangeStart, (long)rangeEnd);
        }
        return RoaringBitmap.remove(rb, (long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public static RoaringBitmap xor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    Container c = x1.highLowContainer.getContainerAtIndex(pos1).xor(x2.highLowContainer.getContainerAtIndex(pos2));
                    if (!c.isEmpty()) {
                        answer.highLowContainer.append(s1, c);
                    }
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public RoaringBitmap() {
        this.highLowContainer = new RoaringArray();
    }

    RoaringBitmap(RoaringArray highLowContainer) {
        this.highLowContainer = highLowContainer;
    }

    public RoaringBitmap(ImmutableRoaringBitmap rb) {
        this.highLowContainer = new RoaringArray();
        MappeableContainerPointer cp = rb.getContainerPointer();
        while (cp.getContainer() != null) {
            this.highLowContainer.append(cp.key(), cp.getContainer().toContainer());
            cp.advance();
        }
    }

    @Override
    public void add(int x) {
        char hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).add(Util.lowbits(x)));
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    @Override
    public void add(long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        int lbLast = Util.lowbits(rangeEnd - 1L);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((char)hb);
            if (i >= 0) {
                Container c = this.highLowContainer.getContainerAtIndex(i).iadd(containerStart, containerLast + 1);
                this.highLowContainer.setContainerAtIndex(i, c);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, (char)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    @Deprecated
    public void add(int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            this.add((long)rangeStart, (long)rangeEnd);
        }
        this.add((long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public boolean intersects(long minimum, long supremum) {
        int pos;
        int index;
        int offset;
        RoaringBitmap.rangeSanityCheck(minimum, supremum);
        if (supremum <= minimum) {
            return false;
        }
        int minKey = (int)(minimum >>> 16);
        int supKey = (int)(supremum >>> 16);
        int length = this.highLowContainer.size;
        char[] keys = this.highLowContainer.keys;
        int limit = Util.lowbitsAsInteger(supremum);
        int n = offset = index >= 0 ? Util.lowbitsAsInteger(minimum) : 0;
        if (pos < length && supKey == keys[pos]) {
            if (supKey > minKey) {
                offset = 0;
            }
            return this.highLowContainer.getContainerAtIndex(pos).intersects(offset, limit);
        }
        for (pos = (index = Util.unsignedBinarySearch(keys, 0, length, (char)minKey)) >= 0 ? index : -index - 1; pos < length && supKey > keys[pos]; ++pos) {
            Container container = this.highLowContainer.getContainerAtIndex(pos);
            if (container.intersects(offset, 65536)) {
                return true;
            }
            offset = 0;
        }
        return pos < length && supKey == keys[pos] && this.highLowContainer.getContainerAtIndex(pos).intersects(offset, limit);
    }

    public void and(RoaringBitmap x2) {
        if (x2 == this) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = this.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.iand(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                pos1 = this.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        this.highLowContainer.resize(intersectionSize);
    }

    public static RoaringBitmap and(Iterator<? extends RoaringBitmap> bitmaps, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        Iterator<RoaringBitmap> bitmapsIterator = RoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return FastAggregation.and(bitmapsIterator);
    }

    @Deprecated
    public static RoaringBitmap and(Iterator<? extends RoaringBitmap> bitmaps, int rangeStart, int rangeEnd) {
        return RoaringBitmap.and(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    public void andNot(RoaringBitmap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int intersectionSize = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            Container c1;
            char s2;
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                c1 = this.highLowContainer.getContainerAtIndex(pos1);
                Container c = c1.iandNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (!c.isEmpty()) {
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize++, s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 < s2) {
                if (pos1 != intersectionSize) {
                    c1 = this.highLowContainer.getContainerAtIndex(pos1);
                    this.highLowContainer.replaceKeyAndContainerAtIndex(intersectionSize, s1, c1);
                }
                ++intersectionSize;
                ++pos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos1 < length1) {
            this.highLowContainer.copyRange(pos1, length1, intersectionSize);
            intersectionSize += length1 - pos1;
        }
        this.highLowContainer.resize(intersectionSize);
    }

    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        RoaringBitmap rb1 = RoaringBitmap.selectRangeWithoutCopy(x1, rangeStart, rangeEnd);
        RoaringBitmap rb2 = RoaringBitmap.selectRangeWithoutCopy(x2, rangeStart, rangeEnd);
        return RoaringBitmap.andNot(rb1, rb2);
    }

    @Deprecated
    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2, int rangeStart, int rangeEnd) {
        return RoaringBitmap.andNot(x1, x2, (long)rangeStart, (long)rangeEnd);
    }

    public void orNot(RoaringBitmap other, long rangeEnd) {
        int maxSize;
        if (other == this) {
            throw new UnsupportedOperationException("orNot between a bitmap and itself?");
        }
        RoaringBitmap.rangeSanityCheck(0L, rangeEnd);
        int maxKey = (int)(rangeEnd - 1L >>> 16);
        int lastRun = (rangeEnd & 0xFFFFL) == 0L ? 65536 : (int)(rangeEnd & 0xFFFFL);
        int size = 0;
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = other.highLowContainer.size();
        int s1 = length1 > 0 ? (int)this.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
        int s2 = length2 > 0 ? (int)other.highLowContainer.getKeyAtIndex(pos2) : maxKey + 1;
        int remainder = 0;
        for (int i = this.highLowContainer.size - 1; i >= 0 && this.highLowContainer.keys[i] > maxKey; --i) {
            ++remainder;
        }
        int correction = 0;
        for (int i = 0; i < other.highLowContainer.size - remainder; ++i) {
            correction += other.highLowContainer.getContainerAtIndex(i).isFull() ? 1 : 0;
            if (other.highLowContainer.getKeyAtIndex(i) >= maxKey) break;
        }
        if ((maxSize = Math.min(maxKey + 1 + remainder - correction + this.highLowContainer.size, 65536)) == 0) {
            return;
        }
        char[] newKeys = new char[maxSize];
        Container[] newValues = new Container[maxSize];
        for (int key = 0; key <= maxKey && size < maxSize; ++key) {
            if (key == s1 && key == s2) {
                newValues[size] = this.highLowContainer.getContainerAtIndex(pos1).iorNot(other.highLowContainer.getContainerAtIndex(pos2), key == maxKey ? lastRun : 65536);
                s1 = ++pos1 < length1 ? (int)this.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
                s2 = pos2 < length2 ? (int)other.highLowContainer.getKeyAtIndex(++pos2) : maxKey + 1;
            } else if (key == s1) {
                newValues[size] = key == maxKey ? this.highLowContainer.getContainerAtIndex(pos1).ior(RunContainer.rangeOfOnes(0, lastRun)) : RunContainer.full();
                s1 = ++pos1 < length1 ? (int)this.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
            } else if (key == s2) {
                newValues[size] = other.highLowContainer.getContainerAtIndex(pos2).not(0, key == maxKey ? lastRun : 65536);
                s2 = ++pos2 < length2 ? (int)other.highLowContainer.getKeyAtIndex(pos2) : maxKey + 1;
            } else {
                Container container = newValues[size] = key == maxKey ? RunContainer.rangeOfOnes(0, lastRun) : RunContainer.full();
            }
            if (newValues[size].isEmpty()) {
                newValues[size] = null;
                continue;
            }
            newKeys[size] = (char)key;
            ++size;
        }
        if (remainder > 0) {
            System.arraycopy(this.highLowContainer.keys, this.highLowContainer.size - remainder, newKeys, size, remainder);
            System.arraycopy(this.highLowContainer.values, this.highLowContainer.size - remainder, newValues, size, remainder);
        }
        this.highLowContainer.keys = newKeys;
        this.highLowContainer.values = newValues;
        this.highLowContainer.size = size + remainder;
    }

    public static RoaringBitmap orNot(RoaringBitmap x1, RoaringBitmap x2, long rangeEnd) {
        int maxSize;
        RoaringBitmap.rangeSanityCheck(0L, rangeEnd);
        int maxKey = (int)(rangeEnd - 1L >>> 16);
        int lastRun = (rangeEnd & 0xFFFFL) == 0L ? 65536 : (int)(rangeEnd & 0xFFFFL);
        int size = 0;
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        int s1 = length1 > 0 ? (int)x1.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
        int s2 = length2 > 0 ? (int)x2.highLowContainer.getKeyAtIndex(pos2) : maxKey + 1;
        int remainder = 0;
        for (int i = x1.highLowContainer.size - 1; i >= 0 && x1.highLowContainer.keys[i] > maxKey; --i) {
            ++remainder;
        }
        int correction = 0;
        for (int i = 0; i < x2.highLowContainer.size - remainder; ++i) {
            correction += x2.highLowContainer.getContainerAtIndex(i).isFull() ? 1 : 0;
            if (x2.highLowContainer.getKeyAtIndex(i) >= maxKey) break;
        }
        if ((maxSize = Math.min(maxKey + 1 + remainder - correction + x1.highLowContainer.size, 65536)) == 0) {
            return new RoaringBitmap();
        }
        char[] newKeys = new char[maxSize];
        Container[] newValues = new Container[maxSize];
        for (int key = 0; key <= maxKey && size < maxSize; ++key) {
            if (key == s1 && key == s2) {
                newValues[size] = x1.highLowContainer.getContainerAtIndex(pos1).orNot(x2.highLowContainer.getContainerAtIndex(pos2), key == maxKey ? lastRun : 65536);
                s1 = ++pos1 < length1 ? (int)x1.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
                s2 = pos2 < length2 ? (int)x2.highLowContainer.getKeyAtIndex(++pos2) : maxKey + 1;
            } else if (key == s1) {
                newValues[size] = key == maxKey ? x1.highLowContainer.getContainerAtIndex(pos1).ior(RunContainer.rangeOfOnes(0, lastRun)) : RunContainer.full();
                s1 = ++pos1 < length1 ? (int)x1.highLowContainer.getKeyAtIndex(pos1) : maxKey + 1;
            } else if (key == s2) {
                newValues[size] = x2.highLowContainer.getContainerAtIndex(pos2).not(0, key == maxKey ? lastRun : 65536);
                s2 = ++pos2 < length2 ? (int)x2.highLowContainer.getKeyAtIndex(pos2) : maxKey + 1;
            } else {
                Container container = newValues[size] = key == maxKey ? RunContainer.rangeOfOnes(0, lastRun) : RunContainer.full();
            }
            if (newValues[size].isEmpty()) {
                newValues[size] = null;
                continue;
            }
            newKeys[size++] = (char)key;
        }
        if (remainder > 0) {
            System.arraycopy(x1.highLowContainer.keys, x1.highLowContainer.size - remainder, newKeys, size, remainder);
            System.arraycopy(x1.highLowContainer.values, x1.highLowContainer.size - remainder, newValues, size, remainder);
            for (int i = size; i < size + remainder; ++i) {
                newValues[i] = newValues[i].clone();
            }
        }
        RoaringBitmap result = new RoaringBitmap();
        result.highLowContainer.keys = newKeys;
        result.highLowContainer.values = newValues;
        result.highLowContainer.size = size + remainder;
        return result;
    }

    public boolean checkedAdd(int x) {
        char hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            if (c instanceof RunContainer) {
                if (!c.contains(Util.lowbits(x))) {
                    Container newCont = c.add(Util.lowbits(x));
                    this.highLowContainer.setContainerAtIndex(i, newCont);
                    return true;
                }
            } else {
                int oldCard = c.getCardinality();
                Container newCont = c.add(Util.lowbits(x));
                this.highLowContainer.setContainerAtIndex(i, newCont);
                if (newCont.getCardinality() > oldCard) {
                    return true;
                }
            }
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkedRemove(int x) {
        boolean containerNotEmpty;
        char hb = Util.highbits(x);
        char lb = Util.lowbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return false;
        }
        Container C = this.highLowContainer.getContainerAtIndex(i);
        if (C instanceof RunContainer) {
            if (!C.contains(lb)) return false;
            containerNotEmpty = !(C = C.remove(lb)).isEmpty();
        } else {
            int oldcard = C.getCardinality();
            int newcard = (C = C.remove(lb)).getCardinality();
            if (newcard == oldcard) {
                return false;
            }
            boolean bl = containerNotEmpty = newcard > 0;
        }
        if (containerNotEmpty) {
            this.highLowContainer.setContainerAtIndex(i, C);
            return true;
        } else {
            this.highLowContainer.removeAtIndex(i);
        }
        return true;
    }

    public void clear() {
        this.highLowContainer = new RoaringArray();
    }

    public RoaringBitmap clone() {
        try {
            RoaringBitmap x = (RoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    @Override
    public boolean contains(int x) {
        char hb = Util.highbits(x);
        int index = this.highLowContainer.getContainerIndex(hb);
        if (index < 0) {
            return false;
        }
        Container c = this.highLowContainer.getContainerAtIndex(index);
        return c.contains(Util.lowbits(x));
    }

    public boolean contains(long minimum, long supremum) {
        RoaringBitmap.rangeSanityCheck(minimum, supremum);
        if (supremum <= minimum) {
            return false;
        }
        char firstKey = Util.highbits(minimum);
        int len = this.highLowContainer.size;
        char lastKey = Util.highbits(supremum);
        int span = lastKey - firstKey;
        if (len < span) {
            return false;
        }
        int begin = this.highLowContainer.getIndex(firstKey);
        int end = this.highLowContainer.getIndex(lastKey);
        int n = end = end < 0 ? -end - 1 : end;
        if (begin < 0 || end - begin != span) {
            return false;
        }
        char min = (char)minimum;
        char sup = (char)supremum;
        if (firstKey == lastKey) {
            return this.highLowContainer.getContainerAtIndex(begin).contains(min, (supremum & 0xFFFFL) == 0L ? 65536 : (int)sup);
        }
        if (!this.highLowContainer.getContainerAtIndex(begin).contains(min, 65536)) {
            return false;
        }
        if (sup != '\u0000' && end < len && !this.highLowContainer.getContainerAtIndex(end).contains(0, sup)) {
            return false;
        }
        for (int i = begin + 1; i < end; ++i) {
            if (this.highLowContainer.getContainerAtIndex(i).getCardinality() == 65536) continue;
            return false;
        }
        return true;
    }

    public void deserialize(DataInput in, byte[] buffer) throws IOException {
        try {
            this.highLowContainer.deserialize(in, buffer);
        }
        catch (InvalidRoaringFormat cookie) {
            throw cookie.toIOException();
        }
    }

    public void deserialize(DataInput in) throws IOException {
        try {
            this.highLowContainer.deserialize(in);
        }
        catch (InvalidRoaringFormat cookie) {
            throw cookie.toIOException();
        }
    }

    public void deserialize(ByteBuffer bbf) throws IOException {
        try {
            this.highLowContainer.deserialize(bbf);
        }
        catch (InvalidRoaringFormat cookie) {
            throw cookie.toIOException();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringBitmap) {
            RoaringBitmap srb = (RoaringBitmap)o;
            return srb.highLowContainer.equals(this.highLowContainer);
        }
        return false;
    }

    public boolean isHammingSimilar(RoaringBitmap other, int tolerance) {
        int size1 = this.highLowContainer.size();
        int size2 = other.highLowContainer.size();
        int pos1 = 0;
        int pos2 = 0;
        int budget = tolerance;
        while (budget >= 0 && pos1 < size1 && pos2 < size2) {
            char key1 = this.highLowContainer.getKeyAtIndex(pos1);
            char key2 = other.highLowContainer.getKeyAtIndex(pos2);
            Container left = this.highLowContainer.getContainerAtIndex(pos1);
            Container right = other.highLowContainer.getContainerAtIndex(pos2);
            if (key1 == key2) {
                budget -= left.xorCardinality(right);
                ++pos1;
                ++pos2;
                continue;
            }
            if (key1 < key2) {
                budget -= left.getCardinality();
                ++pos1;
                continue;
            }
            budget -= right.getCardinality();
            ++pos2;
        }
        while (budget >= 0 && pos1 < size1) {
            Container container = this.highLowContainer.getContainerAtIndex(pos1++);
            budget -= container.getCardinality();
        }
        while (budget >= 0 && pos2 < size2) {
            Container container = other.highLowContainer.getContainerAtIndex(pos2++);
            budget -= container.getCardinality();
        }
        return budget >= 0;
    }

    public void flip(int x) {
        char hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            Container c = this.highLowContainer.getContainerAtIndex(i).flip(Util.lowbits(x));
            if (!c.isEmpty()) {
                this.highLowContainer.setContainerAtIndex(i, c);
            } else {
                this.highLowContainer.removeAtIndex(i);
            }
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    public void flip(long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return;
        }
        int hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        int lbLast = Util.lowbits(rangeEnd - 1L);
        for (int hb = hbStart; hb <= hbLast; ++hb) {
            char containerStart = hb == hbStart ? lbStart : (char)'\u0000';
            int containerLast = hb == hbLast ? lbLast : Util.maxLowBitAsInteger();
            int i = this.highLowContainer.getIndex((char)hb);
            if (i >= 0) {
                Container c = this.highLowContainer.getContainerAtIndex(i).inot(containerStart, containerLast + 1);
                if (!c.isEmpty()) {
                    this.highLowContainer.setContainerAtIndex(i, c);
                    continue;
                }
                this.highLowContainer.removeAtIndex(i);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, (char)hb, Container.rangeOfOnes(containerStart, containerLast + 1));
        }
    }

    @Deprecated
    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            this.flip((long)rangeStart, (long)rangeEnd);
        } else {
            this.flip((long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
        }
    }

    @Override
    public long getLongCardinality() {
        long size = 0L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += (long)this.highLowContainer.getContainerAtIndex(i).getCardinality();
        }
        return size;
    }

    @Override
    public int getCardinality() {
        return (int)this.getLongCardinality();
    }

    public boolean cardinalityExceeds(long threshold) {
        long size = 0L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            if ((size += (long)this.highLowContainer.getContainerAtIndex(i).getCardinality()) <= threshold) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(IntConsumer ic) {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).forEach(this.highLowContainer.keys[i], ic);
        }
    }

    public void forAllInRange(int uStart, int length, RelativeRangeConsumer rrc) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0 but was " + length);
        }
        if (length == 0) {
            return;
        }
        char startHigh = Util.highbits(uStart);
        long startL = Integer.toUnsignedLong(uStart);
        long endInclusiveL = startL + (long)(length - 1);
        if (endInclusiveL > LongUtils.MAX_UNSIGNED_INT) {
            long remainingLength = LongUtils.MAX_UNSIGNED_INT - startL + 1L;
            throw new IllegalArgumentException("Cannot read past the end of the unsigned integer range. " + remainingLength + " values remaining; requested " + length);
        }
        int uEndInclusive = (int)endInclusiveL;
        char endHigh = Util.highbits(uEndInclusive);
        int startIndex = this.highLowContainer.getContainerIndex(startHigh);
        startIndex = startIndex < 0 ? -startIndex - 1 : startIndex;
        int uFilledUntil = uStart;
        for (int containerIndex = startIndex; containerIndex < this.highLowContainer.size(); ++containerIndex) {
            char containerRangeStart;
            boolean endInContainer;
            if (Integer.compareUnsigned(uEndInclusive, uFilledUntil) < 0) {
                return;
            }
            char containerKey = this.highLowContainer.getKeyAtIndex(containerIndex);
            int uContainerStart = containerKey << 16;
            int uContainerEndInclusive = uContainerStart + 65535;
            if (endHigh < containerKey) {
                if (Integer.compareUnsigned(uFilledUntil, uContainerStart) < 0) {
                    int fillFromRelative = uFilledUntil - uStart;
                    assert (fillFromRelative >= 0);
                    rrc.acceptAllAbsent(fillFromRelative, length);
                }
                return;
            }
            if (Integer.compareUnsigned(uFilledUntil, uContainerStart) < 0) {
                int fillFromRelative = uFilledUntil - uStart;
                int fillToRelative = uContainerStart - uStart;
                assert (fillFromRelative >= 0);
                assert (fillToRelative >= 0);
                rrc.acceptAllAbsent(fillFromRelative, fillToRelative);
                uFilledUntil = uContainerStart;
            }
            Container container = this.highLowContainer.getContainerAtIndex(containerIndex);
            int containerRangeStartOffset = uFilledUntil - uStart;
            assert (containerRangeStartOffset >= 0);
            boolean startInContainer = Integer.compareUnsigned(uContainerStart, uStart) < 0;
            boolean bl = endInContainer = Integer.compareUnsigned(uEndInclusive, uContainerEndInclusive) < 0;
            if (startInContainer && endInContainer) {
                containerRangeStart = LongUtils.lowPart(uStart);
                int uEndExclusive = uEndInclusive + 1;
                assert (Integer.compareUnsigned(uEndInclusive, uEndExclusive) < 0);
                char containerRangeEnd = LongUtils.lowPart(uEndExclusive);
                container.forAllInRange(containerRangeStart, containerRangeEnd, rrc);
                return;
            }
            if (startInContainer) {
                int uOldFilledUntil;
                containerRangeStart = LongUtils.lowPart(uStart);
                container.forAllFrom(containerRangeStart, rrc);
                int numValuesAdded = 65536 - containerRangeStart;
                assert (numValuesAdded >= 0);
                if (Integer.compareUnsigned(uFilledUntil += numValuesAdded, uOldFilledUntil = uFilledUntil) >= 0) continue;
                return;
            }
            if (endInContainer) {
                int uEndExclusive = uEndInclusive + 1;
                assert (Integer.compareUnsigned(uEndInclusive, uEndExclusive) < 0);
                char containerRangeEnd = LongUtils.lowPart(uEndExclusive);
                container.forAllUntil(containerRangeStartOffset, containerRangeEnd, rrc);
                return;
            }
            container.forAll(containerRangeStartOffset, rrc);
            int uOldFilledUntil = uFilledUntil;
            if (Integer.compareUnsigned(uFilledUntil += 65536, uOldFilledUntil) >= 0) continue;
            return;
        }
        if (Integer.compareUnsigned(uFilledUntil, uEndInclusive) <= 0) {
            int fillFromRelative = uFilledUntil - uStart;
            int fillToRelative = length;
            assert (fillFromRelative >= 0);
            rrc.acceptAllAbsent(fillFromRelative, fillToRelative);
        }
    }

    public void forEachInRange(int start, int length, IntConsumer ic) {
        this.forAllInRange(start, length, new IntConsumerRelativeRangeAdapter(start, ic));
    }

    public ContainerPointer getContainerPointer() {
        return this.highLowContainer.getContainerPointer();
    }

    @Override
    public PeekableIntIterator getIntIterator() {
        return new RoaringIntIterator();
    }

    @Override
    public PeekableIntIterator getSignedIntIterator() {
        return new RoaringSignedIntIterator();
    }

    @Override
    public IntIterator getReverseIntIterator() {
        return new RoaringReverseIntIterator();
    }

    @Override
    public RoaringBatchIterator getBatchIterator() {
        return new RoaringBatchIterator(this.highLowContainer);
    }

    @Override
    public long getLongSizeInBytes() {
        long size = 8L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            size += (long)(2 + c.getSizeInBytes());
        }
        return size;
    }

    @Override
    public int getSizeInBytes() {
        return (int)this.getLongSizeInBytes();
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    public boolean hasRunCompression() {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            if (!(c instanceof RunContainer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return (new Iterator<Integer>(){
            private int hs = 0;
            private CharIterator iter;
            private int pos = 0;
            private int x;

            @Override
            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highLowContainer.size();
            }

            private Iterator<Integer> init() {
                if (this.pos < RoaringBitmap.this.highLowContainer.size()) {
                    this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getCharIterator();
                    this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = this.iter.nextAsInt() | this.hs;
                if (!this.iter.hasNext()) {
                    ++this.pos;
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }).init();
    }

    protected void lazyor(RoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).lazyIOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    protected void naivelazyor(RoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    BitmapContainer c1 = this.highLowContainer.getContainerAtIndex(pos1).toBitmapContainer();
                    this.highLowContainer.setContainerAtIndex(pos1, c1.lazyIOR(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    @Override
    public RoaringBitmap limit(int maxcardinality) {
        Container c;
        RoaringBitmap answer = new RoaringBitmap();
        int currentcardinality = 0;
        for (int i = 0; currentcardinality < maxcardinality && i < this.highLowContainer.size(); currentcardinality += c.getCardinality(), ++i) {
            c = this.highLowContainer.getContainerAtIndex(i);
            if (c.getCardinality() + currentcardinality <= maxcardinality) {
                answer.highLowContainer.appendCopy(this.highLowContainer, i);
                continue;
            }
            int leftover = maxcardinality - currentcardinality;
            Container limited = c.limit(leftover);
            answer.highLowContainer.append(this.highLowContainer.getKeyAtIndex(i), limited);
            break;
        }
        return answer;
    }

    public void or(RoaringBitmap x2) {
        if (this == x2) {
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).ior(x2.highLowContainer.getContainerAtIndex(pos2)));
                    if (++pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    public static RoaringBitmap or(Iterator<? extends RoaringBitmap> bitmaps, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        Iterator<RoaringBitmap> bitmapsIterator = RoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return RoaringBitmap.or(bitmapsIterator);
    }

    @Deprecated
    public static RoaringBitmap or(Iterator<? extends RoaringBitmap> bitmaps, int rangeStart, int rangeEnd) {
        return RoaringBitmap.or(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    @Override
    public long rankLong(int x) {
        long size = 0L;
        char xhigh = Util.highbits(x);
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            char key = this.highLowContainer.getKeyAtIndex(i);
            if (key < xhigh) {
                size += (long)this.highLowContainer.getContainerAtIndex(i).getCardinality();
                continue;
            }
            if (key != xhigh) break;
            return size + (long)this.highLowContainer.getContainerAtIndex(i).rank(Util.lowbits(x));
        }
        return size;
    }

    @Override
    public long rangeCardinality(long start, long end) {
        if (Long.compareUnsigned(start, end) >= 0) {
            return 0L;
        }
        long size = 0L;
        int startIndex = this.highLowContainer.getIndex(Util.highbits(start));
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        } else {
            char inContainerStart = Util.lowbits(start);
            if (inContainerStart != '\u0000') {
                size -= (long)this.highLowContainer.getContainerAtIndex(startIndex).rank((char)(inContainerStart - '\u0001'));
            }
        }
        char xhigh = Util.highbits(end - 1L);
        for (int i = startIndex; i < this.highLowContainer.size(); ++i) {
            char key = this.highLowContainer.getKeyAtIndex(i);
            if (key < xhigh) {
                size += (long)this.highLowContainer.getContainerAtIndex(i).getCardinality();
                continue;
            }
            if (key != xhigh) break;
            return size + (long)this.highLowContainer.getContainerAtIndex(i).rank(Util.lowbits((int)(end - 1L)));
        }
        return size;
    }

    @Override
    public int rank(int x) {
        return (int)this.rankLong(x);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.highLowContainer.readExternal(in);
    }

    @Override
    public void remove(int x) {
        char hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return;
        }
        this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).remove(Util.lowbits(x)));
        if (this.highLowContainer.getContainerAtIndex(i).isEmpty()) {
            this.highLowContainer.removeAtIndex(i);
        }
    }

    public void remove(long rangeStart, long rangeEnd) {
        Container c;
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            return;
        }
        char hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        char lbLast = Util.lowbits(rangeEnd - 1L);
        if (hbStart == hbLast) {
            int i = this.highLowContainer.getIndex(hbStart);
            if (i < 0) {
                return;
            }
            Container c2 = this.highLowContainer.getContainerAtIndex(i).iremove(lbStart, lbLast + '\u0001');
            if (!c2.isEmpty()) {
                this.highLowContainer.setContainerAtIndex(i, c2);
            } else {
                this.highLowContainer.removeAtIndex(i);
            }
            return;
        }
        int ifirst = this.highLowContainer.getIndex(hbStart);
        int ilast = this.highLowContainer.getIndex(hbLast);
        if (ifirst >= 0) {
            if (lbStart != '\u0000' && !(c = this.highLowContainer.getContainerAtIndex(ifirst).iremove(lbStart, Util.maxLowBitAsInteger() + 1)).isEmpty()) {
                this.highLowContainer.setContainerAtIndex(ifirst, c);
                ++ifirst;
            }
        } else {
            ifirst = -ifirst - 1;
        }
        if (ilast >= 0) {
            if (lbLast != Util.maxLowBitAsInteger()) {
                c = this.highLowContainer.getContainerAtIndex(ilast).iremove(0, lbLast + '\u0001');
                if (!c.isEmpty()) {
                    this.highLowContainer.setContainerAtIndex(ilast, c);
                } else {
                    ++ilast;
                }
            } else {
                ++ilast;
            }
        } else {
            ilast = -ilast - 1;
        }
        this.highLowContainer.removeIndexRange(ifirst, ilast);
    }

    @Deprecated
    public void remove(int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            this.remove((long)rangeStart, (long)rangeEnd);
        }
        this.remove((long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    public boolean removeRunCompression() {
        boolean answer = false;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            if (!(c instanceof RunContainer)) continue;
            Container newc = ((RunContainer)c).toBitmapOrArrayContainer(c.getCardinality());
            this.highLowContainer.setContainerAtIndex(i, newc);
            answer = true;
        }
        return answer;
    }

    protected void repairAfterLazy() {
        for (int k = 0; k < this.highLowContainer.size(); ++k) {
            Container c = this.highLowContainer.getContainerAtIndex(k);
            this.highLowContainer.setContainerAtIndex(k, c.repairAfterLazy());
        }
    }

    public boolean runOptimize() {
        boolean answer = false;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i).runOptimize();
            if (c instanceof RunContainer) {
                answer = true;
            }
            this.highLowContainer.setContainerAtIndex(i, c);
        }
        return answer;
    }

    public boolean contains(RoaringBitmap subset) {
        int length1 = this.highLowContainer.size;
        int length2 = subset.highLowContainer.size;
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < length1 && pos2 < length2) {
            char s2;
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = subset.highLowContainer.getKeyAtIndex(pos2))) {
                Container c2;
                Container c1 = this.highLowContainer.getContainerAtIndex(pos1);
                if (!c1.contains(c2 = subset.highLowContainer.getContainerAtIndex(pos2))) {
                    return false;
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (s1 - s2 > 0) {
                return false;
            }
            pos1 = subset.highLowContainer.advanceUntil(s2, pos1);
        }
        return pos2 == length2;
    }

    @Override
    public int select(int j) {
        long leftover = Util.toUnsignedLong(j);
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            int thiscard = c.getCardinality();
            if ((long)thiscard > leftover) {
                int keycontrib = this.highLowContainer.getKeyAtIndex(i) << 16;
                char lowcontrib = c.select((int)leftover);
                return lowcontrib + keycontrib;
            }
            leftover -= (long)thiscard;
        }
        throw new IllegalArgumentException("You are trying to select the " + j + "th value when the cardinality is " + this.getCardinality() + ".");
    }

    @Override
    public long nextValue(int fromValue) {
        char key = Util.highbits(fromValue);
        long nextSetBit = -1L;
        for (int containerIndex = this.highLowContainer.advanceUntil(key, -1); containerIndex < this.highLowContainer.size() && nextSetBit == -1L; ++containerIndex) {
            char containerKey = this.highLowContainer.getKeyAtIndex(containerIndex);
            Container container = this.highLowContainer.getContainerAtIndex(containerIndex);
            int bit = containerKey - key > 0 ? container.first() : container.nextValue(Util.lowbits(fromValue));
            nextSetBit = bit == -1 ? -1L : Util.toUnsignedLong(containerKey << 16 | bit);
        }
        assert (nextSetBit <= 0xFFFFFFFFL);
        assert (nextSetBit == -1L || nextSetBit >= Util.toUnsignedLong(fromValue));
        return nextSetBit;
    }

    @Override
    public long previousValue(int fromValue) {
        if (this.isEmpty()) {
            return -1L;
        }
        char key = Util.highbits(fromValue);
        int containerIndex = this.highLowContainer.advanceUntil(key, -1);
        if (containerIndex == this.highLowContainer.size()) {
            return Util.toUnsignedLong(this.last());
        }
        if (this.highLowContainer.getKeyAtIndex(containerIndex) > key) {
            --containerIndex;
        }
        long prevSetBit = -1L;
        while (containerIndex != -1 && prevSetBit == -1L) {
            char containerKey = this.highLowContainer.getKeyAtIndex(containerIndex);
            Container container = this.highLowContainer.getContainerAtIndex(containerIndex);
            int bit = containerKey < key ? container.last() : container.previousValue(Util.lowbits(fromValue));
            prevSetBit = bit == -1 ? -1L : Util.toUnsignedLong(containerKey << 16 | bit);
            --containerIndex;
        }
        assert (prevSetBit <= 0xFFFFFFFFL);
        assert (prevSetBit <= Util.toUnsignedLong(fromValue));
        return prevSetBit;
    }

    @Override
    public long nextAbsentValue(int fromValue) {
        long nextAbsentBit = this.computeNextAbsentValue(fromValue);
        if (nextAbsentBit == 0x100000000L) {
            return -1L;
        }
        return nextAbsentBit;
    }

    private long computeNextAbsentValue(int fromValue) {
        int size;
        char key = Util.highbits(fromValue);
        int containerIndex = this.highLowContainer.advanceUntil(key, -1);
        if (containerIndex == (size = this.highLowContainer.size())) {
            return Util.toUnsignedLong(fromValue);
        }
        char containerKey = this.highLowContainer.getKeyAtIndex(containerIndex);
        if (fromValue < containerKey << 16) {
            return Util.toUnsignedLong(fromValue);
        }
        Container container = this.highLowContainer.getContainerAtIndex(containerIndex);
        int bit = container.nextAbsentValue(Util.lowbits(fromValue));
        while (bit == 65536) {
            char nextContainerKey;
            assert (container.last() == 65535);
            if (containerIndex == size - 1) {
                return Util.toUnsignedLong(this.highLowContainer.last()) + 1L;
            }
            if (containerKey + '\u0001' < (nextContainerKey = this.highLowContainer.getKeyAtIndex(++containerIndex))) {
                return Util.toUnsignedLong(containerKey + '\u0001' << 16);
            }
            containerKey = nextContainerKey;
            container = this.highLowContainer.getContainerAtIndex(containerIndex);
            bit = container.nextAbsentValue('\u0000');
        }
        return Util.toUnsignedLong(containerKey << 16 | bit);
    }

    @Override
    public long previousAbsentValue(int fromValue) {
        long prevAbsentBit = this.computePreviousAbsentValue(fromValue);
        assert (prevAbsentBit <= 0xFFFFFFFFL);
        assert (prevAbsentBit <= Util.toUnsignedLong(fromValue));
        assert (!this.contains((int)prevAbsentBit));
        return prevAbsentBit;
    }

    private long computePreviousAbsentValue(int fromValue) {
        char key = Util.highbits(fromValue);
        int containerIndex = this.highLowContainer.advanceUntil(key, -1);
        if (containerIndex == this.highLowContainer.size()) {
            return Util.toUnsignedLong(fromValue);
        }
        char containerKey = this.highLowContainer.getKeyAtIndex(containerIndex);
        if (fromValue < containerKey << 16) {
            return Util.toUnsignedLong(fromValue);
        }
        Container container = this.highLowContainer.getContainerAtIndex(containerIndex);
        int bit = container.previousAbsentValue(Util.lowbits(fromValue));
        while (bit == -1) {
            char nextContainerKey;
            assert (container.first() == 0);
            if (containerIndex == 0) {
                return Util.toUnsignedLong(this.highLowContainer.first()) - 1L;
            }
            if ((nextContainerKey = this.highLowContainer.getKeyAtIndex(--containerIndex)) < containerKey - '\u0001') {
                return Util.toUnsignedLong(containerKey << 16) - 1L;
            }
            containerKey = nextContainerKey;
            container = this.highLowContainer.getContainerAtIndex(containerIndex);
            bit = container.previousAbsentValue('\uffff');
        }
        return Util.toUnsignedLong(containerKey << 16 | bit);
    }

    @Override
    public int first() {
        return this.highLowContainer.first();
    }

    @Override
    public int last() {
        return this.highLowContainer.last();
    }

    @Override
    public int firstSigned() {
        return this.highLowContainer.firstSigned();
    }

    @Override
    public int lastSigned() {
        return this.highLowContainer.lastSigned();
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        this.highLowContainer.serialize(buffer);
    }

    public static long maximumSerializedSize(long cardinality, long universe_size) {
        long contnbr = (universe_size + 65535L) / 65536L;
        if (contnbr > cardinality) {
            contnbr = cardinality;
        }
        long headermax = Math.max(8L, 4L + (contnbr + 7L) / 8L) + 8L * contnbr;
        long valsarray = 2L * cardinality;
        long valsbitmap = contnbr * 8192L;
        long valsbest = Math.min(valsarray, valsbitmap);
        return valsbest + headermax;
    }

    @Override
    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    private static Iterator<RoaringBitmap> selectRangeWithoutCopy(final Iterator<? extends RoaringBitmap> bitmaps, final long rangeStart, final long rangeEnd) {
        Iterator<RoaringBitmap> bitmapsIterator = new Iterator<RoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return bitmaps.hasNext();
            }

            @Override
            public RoaringBitmap next() {
                RoaringBitmap next = (RoaringBitmap)bitmaps.next();
                return RoaringBitmap.selectRangeWithoutCopy(next, rangeStart, rangeEnd);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
        return bitmapsIterator;
    }

    public RoaringBitmap selectRange(long rangeStart, long rangeEnd) {
        Container c;
        char hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        char lbLast = Util.lowbits(rangeEnd - 1L);
        RoaringBitmap answer = new RoaringBitmap();
        assert (rangeStart >= 0L && rangeEnd >= 0L);
        if (rangeEnd <= rangeStart) {
            return answer;
        }
        if (hbStart == hbLast) {
            Container c2;
            int i = this.highLowContainer.getIndex(hbStart);
            if (i >= 0 && !(c2 = this.highLowContainer.getContainerAtIndex(i).remove(0, lbStart).iremove(lbLast + '\u0001', Util.maxLowBitAsInteger() + 1)).isEmpty()) {
                answer.highLowContainer.append(hbStart, c2);
            }
            return answer;
        }
        int ifirst = this.highLowContainer.getIndex(hbStart);
        int ilast = this.highLowContainer.getIndex(hbLast);
        if (ifirst >= 0 && !(c = this.highLowContainer.getContainerAtIndex(ifirst).remove(0, lbStart)).isEmpty()) {
            answer.highLowContainer.append(hbStart, c.clone());
        }
        for (int hb = hbStart + '\u0001'; hb <= hbLast - '\u0001'; ++hb) {
            int i = this.highLowContainer.getIndex((char)hb);
            int j = answer.highLowContainer.getIndex((char)hb);
            assert (j < 0);
            if (i < 0) continue;
            Container c3 = this.highLowContainer.getContainerAtIndex(i);
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, (char)hb, c3.clone());
        }
        if (ilast >= 0 && !(c = this.highLowContainer.getContainerAtIndex(ilast).remove(lbLast + '\u0001', Util.maxLowBitAsInteger() + 1)).isEmpty()) {
            answer.highLowContainer.append(hbLast, c);
        }
        return answer;
    }

    private static RoaringBitmap selectRangeWithoutCopy(RoaringBitmap rb, long rangeStart, long rangeEnd) {
        Container c;
        char hbStart = Util.highbits(rangeStart);
        char lbStart = Util.lowbits(rangeStart);
        char hbLast = Util.highbits(rangeEnd - 1L);
        char lbLast = Util.lowbits(rangeEnd - 1L);
        RoaringBitmap answer = new RoaringBitmap();
        assert (rangeStart >= 0L && rangeEnd >= 0L);
        if (rangeEnd <= rangeStart) {
            return answer;
        }
        if (hbStart == hbLast) {
            Container c2;
            int i = rb.highLowContainer.getIndex(hbStart);
            if (i >= 0 && !(c2 = rb.highLowContainer.getContainerAtIndex(i).remove(0, lbStart).iremove(lbLast + '\u0001', Util.maxLowBitAsInteger() + 1)).isEmpty()) {
                answer.highLowContainer.append(hbStart, c2);
            }
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex(hbStart);
        int ilast = rb.highLowContainer.getIndex(hbLast);
        if (ifirst >= 0 && !(c = rb.highLowContainer.getContainerAtIndex(ifirst).remove(0, lbStart)).isEmpty()) {
            answer.highLowContainer.append(hbStart, c);
        }
        for (int hb = hbStart + '\u0001'; hb <= hbLast - '\u0001'; ++hb) {
            int i = rb.highLowContainer.getIndex((char)hb);
            int j = answer.highLowContainer.getIndex((char)hb);
            assert (j < 0);
            if (i < 0) continue;
            Container c3 = rb.highLowContainer.getContainerAtIndex(i);
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, (char)hb, c3);
        }
        if (ilast >= 0 && !(c = rb.highLowContainer.getContainerAtIndex(ilast).remove(lbLast + '\u0001', Util.maxLowBitAsInteger() + 1)).isEmpty()) {
            answer.highLowContainer.append(hbLast, c);
        }
        return answer;
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = this.highLowContainer.getKeyAtIndex(pos) << 16;
            Container c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    @Override
    public void append(char key, Container container) {
        this.highLowContainer.append(key, container);
    }

    public MutableRoaringBitmap toMutableRoaringBitmap() {
        return new MutableRoaringBitmap(this);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder("{}".length() + "-123456789,".length() * 256);
        PeekableIntIterator i = this.getIntIterator();
        answer.append('{');
        if (i.hasNext()) {
            answer.append((long)i.next() & 0xFFFFFFFFL);
        }
        while (i.hasNext()) {
            answer.append(',');
            if (answer.length() > 524288) {
                answer.append('.').append('.').append('.');
                break;
            }
            answer.append((long)i.next() & 0xFFFFFFFFL);
        }
        answer.append('}');
        return answer.toString();
    }

    @Override
    public void trim() {
        this.highLowContainer.trim();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.highLowContainer.writeExternal(out);
    }

    public void xor(RoaringBitmap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            char s1 = this.highLowContainer.getKeyAtIndex(pos1);
            char s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 == s2) {
                    Container c = this.highLowContainer.getContainerAtIndex(pos1).ixor(x2.highLowContainer.getContainerAtIndex(pos2));
                    if (!c.isEmpty()) {
                        this.highLowContainer.setContainerAtIndex(pos1, c);
                        ++pos1;
                    } else {
                        this.highLowContainer.removeAtIndex(pos1);
                        --length1;
                    }
                    if (pos1 == length1 || ++pos2 == length2) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2).clone());
                ++pos1;
                ++length1;
                if (++pos2 == length2) break;
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    public static RoaringBitmap xor(Iterator<? extends RoaringBitmap> bitmaps, long rangeStart, long rangeEnd) {
        RoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        Iterator<RoaringBitmap> bitmapsIterator = RoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return FastAggregation.xor(bitmapsIterator);
    }

    @Deprecated
    public static RoaringBitmap xor(Iterator<? extends RoaringBitmap> bitmaps, int rangeStart, int rangeEnd) {
        return RoaringBitmap.xor(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    @Override
    public int getContainerCount() {
        return this.highLowContainer.size();
    }

    private class RoaringIntIterator
    implements PeekableIntIterator {
        private final char startingContainerIndex = this.findStartingContainerIndex();
        private int hs = 0;
        private PeekableCharIterator iter;
        private int pos = 0;

        public RoaringIntIterator() {
            this.nextContainer();
        }

        char findStartingContainerIndex() {
            return '\u0000';
        }

        @Override
        public PeekableIntIterator clone() {
            try {
                RoaringIntIterator x = (RoaringIntIterator)super.clone();
                if (this.iter != null) {
                    x.iter = this.iter.clone();
                }
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < RoaringBitmap.this.highLowContainer.size();
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                ++this.pos;
                this.nextContainer();
            }
            return x;
        }

        private void nextContainer() {
            int containerSize = RoaringBitmap.this.highLowContainer.size();
            if (this.pos < containerSize) {
                int index = (this.pos + this.startingContainerIndex) % containerSize;
                this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(index).getCharIterator();
                this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(index) << 16;
            }
        }

        @Override
        public void advanceIfNeeded(int minval) {
            while (this.hasNext() && this.shouldAdvanceContainer(this.hs, minval)) {
                ++this.pos;
                this.nextContainer();
            }
            if (this.hasNext() && this.hs >>> 16 == minval >>> 16) {
                this.iter.advanceIfNeeded(Util.lowbits(minval));
                if (!this.iter.hasNext()) {
                    ++this.pos;
                    this.nextContainer();
                }
            }
        }

        boolean shouldAdvanceContainer(int hs, int minval) {
            return hs >>> 16 < minval >>> 16;
        }

        @Override
        public int peekNext() {
            return this.iter.peekNext() | this.hs;
        }
    }

    private final class RoaringSignedIntIterator
    extends RoaringIntIterator {
        private RoaringSignedIntIterator() {
        }

        @Override
        char findStartingContainerIndex() {
            char index = (char)RoaringBitmap.this.highLowContainer.advanceUntil('\u8000', -1);
            if (index == RoaringBitmap.this.highLowContainer.size()) {
                index = '\u0000';
            }
            return index;
        }

        @Override
        boolean shouldAdvanceContainer(int hs, int minval) {
            return hs >> 16 < minval >> 16;
        }
    }

    private final class RoaringReverseIntIterator
    implements IntIterator {
        int hs = 0;
        CharIterator iter;
        int pos;

        private RoaringReverseIntIterator() {
            this.pos = RoaringBitmap.this.highLowContainer.size() - 1;
            this.nextContainer();
        }

        @Override
        public IntIterator clone() {
            try {
                RoaringReverseIntIterator clone = (RoaringReverseIntIterator)super.clone();
                if (this.iter != null) {
                    clone.iter = this.iter.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                --this.pos;
                this.nextContainer();
            }
            return x;
        }

        private void nextContainer() {
            if (this.pos >= 0) {
                this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getReverseCharIterator();
                this.hs = RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos) << 16;
            }
        }
    }
}

