/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.NoSuchElementException;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class ImmutableRoaringArray
implements PointableRoaringArray {
    protected static final short SERIAL_COOKIE = 12347;
    protected static final short SERIAL_COOKIE_NO_RUNCONTAINER = 12346;
    private static final int startofrunbitmap = 4;
    ByteBuffer buffer;
    int size;

    protected ImmutableRoaringArray(ByteBuffer bbf) {
        this.buffer = bbf.slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int cookie = this.buffer.getInt(0);
        if ((cookie & 0xFFFF) != 12347 && cookie != 12346) {
            throw new RuntimeException("I failed to find one of the right cookies. " + cookie);
        }
        boolean hasRunContainers = (cookie & 0xFFFF) == 12347;
        this.size = hasRunContainers ? (cookie >>> 16) + 1 : this.buffer.getInt(4);
        int theLimit = this.size > 0 ? this.computeSerializedSizeInBytes() : this.headerSize(hasRunContainers);
        this.buffer.limit(theLimit);
    }

    @Override
    public int advanceUntil(short x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || this.getKey(lower) >= BufferUtil.toIntUnsigned(x)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && this.getKey(lower + spansize) < BufferUtil.toIntUnsigned(x)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.getKey(upper) == BufferUtil.toIntUnsigned(x)) {
            return upper;
        }
        if (this.getKey(upper) < BufferUtil.toIntUnsigned(x)) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.getKey(mid) == BufferUtil.toIntUnsigned(x)) {
                return mid;
            }
            if (this.getKey(mid) < BufferUtil.toIntUnsigned(x)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    private int branchyUnsignedBinarySearch(short k) {
        int low = 0;
        int high = this.size - 1;
        int ikey = BufferUtil.toIntUnsigned(k);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = this.getKey(middleIndex);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    @Override
    public ImmutableRoaringArray clone() {
        ImmutableRoaringArray sa;
        try {
            sa = (ImmutableRoaringArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return sa;
    }

    private int computeSerializedSizeInBytes() {
        int SizeOfLastContainer;
        if (this.size == 0) {
            return this.headerSize(this.hasRunCompression());
        }
        int CardinalityOfLastContainer = this.getCardinality(this.size - 1);
        int PositionOfLastContainer = this.getOffsetContainer(this.size - 1);
        boolean hasrun = this.hasRunCompression();
        if (this.isRunContainer(this.size - 1, hasrun)) {
            int nbrruns = BufferUtil.toIntUnsigned(this.buffer.getShort(PositionOfLastContainer));
            SizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
        } else {
            SizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(CardinalityOfLastContainer, 0, false);
        }
        return SizeOfLastContainer + PositionOfLastContainer;
    }

    @Override
    public int getCardinality(int k) {
        if (k < 0 || k >= this.size) {
            throw new IllegalArgumentException("out of range container index: " + k + " (report as a bug)");
        }
        return BufferUtil.toIntUnsigned(this.buffer.getShort(this.getStartOfKeys() + 4 * k + 2)) + 1;
    }

    @Override
    public int getContainerIndex(short x) {
        return this.unsignedBinarySearch(x);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        boolean isBitmap;
        ByteBuffer tmp = this.buffer.duplicate();
        tmp.order(this.buffer.order());
        tmp.position(this.getOffsetContainer(i));
        boolean hasrun = this.hasRunCompression();
        if (this.isRunContainer(i, hasrun)) {
            int nbrruns = BufferUtil.toIntUnsigned(tmp.getShort());
            ShortBuffer shortArray = tmp.asShortBuffer();
            shortArray.limit(2 * nbrruns);
            return new MappeableRunContainer(shortArray, nbrruns);
        }
        int cardinality = this.getCardinality(i);
        boolean bl = isBitmap = cardinality > 4096;
        if (isBitmap) {
            LongBuffer bitmapArray = tmp.asLongBuffer();
            bitmapArray.limit(1024);
            return new MappeableBitmapContainer(bitmapArray, cardinality);
        }
        ShortBuffer shortArray = tmp.asShortBuffer();
        shortArray.limit(cardinality);
        return new MappeableArrayContainer(shortArray, cardinality);
    }

    @Override
    public boolean containsForContainerAtIndex(int i, short x) {
        boolean isBitmap;
        int containerpos = this.getOffsetContainer(i);
        boolean hasrun = this.hasRunCompression();
        if (this.isRunContainer(i, hasrun)) {
            int nbrruns = BufferUtil.toIntUnsigned(this.buffer.getShort(containerpos));
            return MappeableRunContainer.contains(this.buffer, containerpos + 2, x, nbrruns);
        }
        int cardinality = this.getCardinality(i);
        boolean bl = isBitmap = cardinality > 4096;
        if (isBitmap) {
            return MappeableBitmapContainer.contains(this.buffer, containerpos, x);
        }
        return MappeableArrayContainer.contains(this.buffer, containerpos, x, cardinality);
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        final boolean hasrun = !this.isEmpty() && this.hasRunCompression();
        return new MappeableContainerPointer(){
            int k;
            {
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return ImmutableRoaringArray.this.getCardinality(this.k);
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= ImmutableRoaringArray.this.size) {
                    return null;
                }
                return ImmutableRoaringArray.this.getContainerAtIndex(this.k);
            }

            @Override
            public int getSizeInBytes() {
                if (ImmutableRoaringArray.this.isRunContainer(this.k, hasrun)) {
                    int pos = ImmutableRoaringArray.this.getOffsetContainer(this.k);
                    int nbrruns = BufferUtil.toIntUnsigned(ImmutableRoaringArray.this.buffer.getShort(pos));
                    return BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
                }
                int CardinalityOfLastContainer = this.getCardinality();
                return BufferUtil.getSizeInBytesFromCardinalityEtc(CardinalityOfLastContainer, 0, false);
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k & this.k < ImmutableRoaringArray.this.size;
            }

            @Override
            public boolean isBitmapContainer() {
                if (ImmutableRoaringArray.this.isRunContainer(this.k, hasrun)) {
                    return false;
                }
                return this.getCardinality() > 4096;
            }

            @Override
            public boolean isRunContainer() {
                return ImmutableRoaringArray.this.isRunContainer(this.k, hasrun);
            }

            @Override
            public short key() {
                return ImmutableRoaringArray.this.getKeyAtIndex(this.k);
            }

            @Override
            public void previous() {
                --this.k;
            }
        };
    }

    @Override
    public int getIndex(short x) {
        return this.unsignedBinarySearch(x);
    }

    private int getKey(int k) {
        return BufferUtil.toIntUnsigned(this.buffer.getShort(this.getStartOfKeys() + 4 * k));
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.buffer.getShort(4 * i + this.getStartOfKeys());
    }

    private int getOffsetContainer(int k) {
        if (k < 0 || k >= this.size) {
            throw new IllegalArgumentException("out of range container index: " + k + " (report as a bug)");
        }
        if (this.hasRunCompression()) {
            if (this.size < 4) {
                return this.getOffsetContainerSlow(k);
            }
            return this.buffer.getInt(4 + 4 * this.size + (this.size + 7) / 8 + 4 * k);
        }
        return this.buffer.getInt(8 + 4 * this.size + 4 * k);
    }

    private int getOffsetContainerSlow(int k) {
        boolean hasrun = this.hasRunCompression();
        int pos = this.headerSize(hasrun);
        for (int z = 0; z < k; ++z) {
            int SizeOfLastContainer;
            if (this.isRunContainer(z, hasrun)) {
                int nbrruns = BufferUtil.toIntUnsigned(this.buffer.getShort(pos));
                SizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
                pos += SizeOfLastContainer;
                continue;
            }
            int CardinalityOfLastContainer = this.getCardinality(z);
            SizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(CardinalityOfLastContainer, 0, false);
            pos += SizeOfLastContainer;
        }
        return pos;
    }

    private int getStartOfKeys() {
        if (this.hasRunCompression()) {
            return 4 + (this.size + 7) / 8;
        }
        return 8;
    }

    public int hashCode() {
        MappeableContainerPointer cp = this.getContainerPointer();
        int hashvalue = 0;
        while (cp.hasContainer()) {
            int th = cp.key() * 0xF0F0F0 + cp.getContainer().hashCode();
            hashvalue = 31 * hashvalue + th;
            cp.advance();
        }
        return hashvalue;
    }

    @Override
    public boolean hasRunCompression() {
        return (this.buffer.getInt(0) & 0xFFFF) == 12347;
    }

    protected int headerSize(boolean hasrun) {
        if (hasrun) {
            if (this.size < 4) {
                return 4 + (this.size + 7) / 8 + 4 * this.size;
            }
            return 4 + (this.size + 7) / 8 + 8 * this.size;
        }
        return 8 + 8 * this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private boolean isRunContainer(int i, boolean hasrun) {
        if (hasrun) {
            int mask;
            byte j = this.buffer.get(4 + i / 8);
            return (j & (mask = 1 << i % 8)) != 0;
        }
        return false;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.limit());
        } else {
            ByteBuffer tmp = this.buffer.duplicate();
            tmp.position(0);
            try (WritableByteChannel channel = Channels.newChannel((OutputStream)((Object)out));){
                channel.write(tmp);
            }
        }
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.buffer.duplicate());
    }

    @Override
    public int serializedSizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int unsignedBinarySearch(short k) {
        return this.branchyUnsignedBinarySearch(k);
    }

    @Override
    public int first() {
        this.assertNonEmpty();
        short firstKey = this.getKeyAtIndex(0);
        MappeableContainer container = this.getContainerAtIndex(0);
        return firstKey << 16 | container.first();
    }

    @Override
    public int last() {
        this.assertNonEmpty();
        short lastKey = this.getKeyAtIndex(this.size - 1);
        MappeableContainer container = this.getContainerAtIndex(this.size - 1);
        return lastKey << 16 | container.last();
    }

    private void assertNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException("Empty ImmutableRoaringArray");
        }
    }
}

