/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapBatchIterator;
import org.roaringbitmap.BitmapContainerShortIterator;
import org.roaringbitmap.BitmapContainerShortRankIterator;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.PeekableShortRankIterator;
import org.roaringbitmap.ReverseBitmapContainerShortIterator;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;

public final class BitmapContainer
extends Container
implements Cloneable {
    protected static final int MAX_CAPACITY = 65536;
    private static final long serialVersionUID = 2L;
    private static final int BLOCKSIZE = 128;
    public static final boolean USE_BRANCHLESS = true;
    final long[] bitmap;
    int cardinality;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;

    public static ShortIterator getReverseShortIterator(long[] bitmap) {
        return new ReverseBitmapContainerShortIterator(bitmap);
    }

    public static PeekableShortIterator getShortIterator(long[] bitmap) {
        return new BitmapContainerShortIterator(bitmap);
    }

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[1024];
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = new long[1024];
        Util.setBitmapRange(this.bitmap, firstOfRun, lastOfRun);
    }

    private BitmapContainer(int newCardinality, long[] newBitmap) {
        this.cardinality = newCardinality;
        this.bitmap = Arrays.copyOf(newBitmap, newBitmap.length);
    }

    public BitmapContainer(long[] newBitmap, int newCardinality) {
        this.cardinality = newCardinality;
        this.bitmap = newBitmap;
    }

    public BitmapContainer(MappeableBitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongArray();
    }

    @Override
    public Container add(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        Util.setBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, end - begin);
        return answer;
    }

    @Override
    public Container add(short i) {
        long newval;
        int x = Util.toIntUnsigned(i);
        long previous = this.bitmap[x / 64];
        this.bitmap[x / 64] = newval = previous | 1L << x;
        this.cardinality = (int)((long)this.cardinality + ((previous ^ newval) >>> x));
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v;
            answer.content[answer.cardinality] = v = value2.content[k];
            answer.cardinality = (int)((long)answer.cardinality + this.bitValue(v));
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        int answer = 0;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v = value2.content[k];
            answer = (int)((long)answer + this.bitValue(v));
        }
        return answer;
    }

    @Override
    public int andCardinality(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        return newCardinality;
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container andNot(RunContainer x) {
        BitmapContainer answer = this.clone();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            Util.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, 0);
        }
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            Arrays.fill(this.bitmap, 0L);
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    protected void computeCardinality() {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
    }

    protected int cardinalityInRange(int start, int end) {
        assert (this.cardinality != -1);
        if (end - start > 32768) {
            int before = Util.cardinalityInBitmapRange(this.bitmap, 0, start);
            int after = Util.cardinalityInBitmapRange(this.bitmap, end, 65536);
            return this.cardinality - before - after;
        }
        return Util.cardinalityInBitmapRange(this.bitmap, start, end);
    }

    protected void updateCardinality(int prevOnes, int newOnes) {
        int oldCardinality = this.cardinality;
        this.cardinality = oldCardinality - prevOnes + newOnes;
    }

    @Override
    public boolean contains(short i) {
        int x = Util.toIntUnsigned(i);
        return (this.bitmap[x / 64] & 1L << x) != 0L;
    }

    @Override
    public boolean contains(int minimum, int supremum) {
        int start = minimum >>> 6;
        int end = supremum >>> 6;
        long first = (1L << minimum) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long last = (1L << supremum) - 1L;
        if (start == end) {
            return (this.bitmap[end] & first & last) == (first & last);
        }
        if ((this.bitmap[start] & first) != first) {
            return false;
        }
        if (end < this.bitmap.length && (this.bitmap[end] & last) != last) {
            return false;
        }
        for (int i = start + 1; i < this.bitmap.length && i < end; ++i) {
            if (this.bitmap[i] == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        if (this.cardinality != -1 && bitmapContainer.cardinality != -1 && this.cardinality < bitmapContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < bitmapContainer.bitmap.length; ++i) {
            if ((this.bitmap[i] & bitmapContainer.bitmap[i]) == bitmapContainer.bitmap[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int card;
        int runCardinality = runContainer.getCardinality();
        if (this.cardinality != -1 ? this.cardinality < runCardinality : (card = this.cardinality) < runCardinality) {
            return false;
        }
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            int length;
            int start = Util.toIntUnsigned(runContainer.getValue(i));
            if (this.contains(start, start + (length = Util.toIntUnsigned(runContainer.getLength(i))))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        if (arrayContainer.cardinality != -1 && this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < arrayContainer.cardinality; ++i) {
            if (this.contains(arrayContainer.content[i])) continue;
            return false;
        }
        return true;
    }

    protected long bitValue(short i) {
        int x = Util.toIntUnsigned(i);
        return this.bitmap[x / 64] >>> x & 1L;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = Long.reverseBytes(in.readLong());
            this.cardinality += Long.bitCount(w);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            return Arrays.equals(this.bitmap, srb.bitmap);
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        int base = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset &= bitset - 1L) {
                array[pos++] = (short)(base + Long.numberOfTrailingZeros(bitset));
            }
            base += 64;
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        int base = mask;
        for (int k = 0; k < this.bitmap.length; ++k) {
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset &= bitset - 1L) {
                x[pos++] = base + Long.numberOfTrailingZeros(bitset);
            }
            base += 64;
        }
    }

    @Override
    public Container flip(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            int n = index;
            this.bitmap[n] = this.bitmap[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((bef & mask) >>> x)));
        int n = index;
        this.bitmap[n] = this.bitmap[n] ^ mask;
        return this;
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseBitmapContainerShortIterator(this.bitmap);
    }

    @Override
    public PeekableShortIterator getShortIterator() {
        return new BitmapContainerShortIterator(this.bitmap);
    }

    @Override
    public PeekableShortRankIterator getShortRankIterator() {
        return new BitmapContainerShortRankIterator(this.bitmap);
    }

    @Override
    public ContainerBatchIterator getBatchIterator() {
        return new BitmapBatchIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        Util.setBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, end - begin);
        return this;
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iand(RunContainer x) {
        int card = x.getCardinality();
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(x.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(x.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality] = (short)runValue;
                    answer.cardinality = (int)((long)answer.cardinality + this.bitValue((short)runValue));
                }
            }
            return answer;
        }
        int start = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int end = Util.toIntUnsigned(x.getValue(rlepos));
            int prevOnes = this.cardinalityInRange(start, end);
            Util.resetBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnes, 0);
            start = end + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
        }
        int ones = this.cardinalityInRange(start, 65536);
        Util.resetBitmapRange(this.bitmap, start, 65536);
        this.updateCardinality(ones, 0);
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content[k]);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iandNot(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = this.cardinalityInRange(start, end);
            Util.resetBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnesInRange, 0);
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected Container ilazyor(ArrayContainer value2) {
        this.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            this.bitmap[n] = this.bitmap[n] | 1L << v;
        }
        return this;
    }

    protected Container ilazyor(BitmapContainer x) {
        this.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | x.bitmap[k];
        }
        return this;
    }

    protected Container ilazyor(RunContainer x) {
        this.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(this.bitmap, start, end);
        }
        return this;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int prevOnes = this.cardinalityInRange(firstOfRange, lastOfRange);
        Util.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
        this.updateCardinality(prevOnes, lastOfRange - firstOfRange - prevOnes);
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            if (!this.contains(value2.content[k])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer value2) {
        for (int k = 0; k < this.bitmap.length; ++k) {
            if ((this.bitmap[k] & value2.bitmap[k]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        int start = minimum >>> 6;
        int end = supremum >>> 6;
        if (start == end) {
            return (this.bitmap[end] & (((1L << minimum) - 1L ^ 0xFFFFFFFFFFFFFFFFL) & (1L << supremum) - 1L)) != 0L;
        }
        if ((this.bitmap[start] & ((1L << minimum) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return true;
        }
        if (end < this.bitmap.length && (this.bitmap[end] & (1L << supremum) - 1L) != 0L) {
            return true;
        }
        for (int i = 1 + start; i < end && i < this.bitmap.length; ++i) {
            if (this.bitmap[i] == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            long bef = this.bitmap[i];
            this.bitmap[i] = aft = bef | 1L << value2.content[k];
            this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = this.bitmap[k] | b2.bitmap[k];
            this.cardinality += Long.bitCount(w);
        }
        if (this.isFull()) {
            return RunContainer.full();
        }
        return this;
    }

    @Override
    public Container ior(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = this.cardinalityInRange(start, end);
            Util.setBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnesInRange, end - start);
        }
        if (this.isFull()) {
            return RunContainer.full();
        }
        return this;
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        Util.resetBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, 0);
        if (this.getCardinality() <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            final ShortIterator si;
            {
                this.si = BitmapContainer.this.getShortIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Short next() {
                return this.si.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            long mask = 1L << vc;
            int index = Util.toIntUnsigned(vc) >>> 6;
            long ba = this.bitmap[index];
            this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
            this.bitmap[index] = ba ^ mask;
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] ^ b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container ixor(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnes = this.cardinalityInRange(start, end);
            Util.flipBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnes, end - start - prevOnes);
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected Container lazyor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        answer.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            answer.bitmap[n] = answer.bitmap[n] | 1L << v;
        }
        return answer;
    }

    protected Container lazyor(BitmapContainer x) {
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            answer.bitmap[k] = this.bitmap[k] | x.bitmap[k];
        }
        return answer;
    }

    protected Container lazyor(RunContainer x) {
        BitmapContainer bc = this.clone();
        bc.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(bc.bitmap, start, end);
        }
        return bc;
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            ArrayContainer ac = new ArrayContainer(maxcardinality);
            int pos = 0;
            for (int k = 0; ac.cardinality < maxcardinality && k < this.bitmap.length; ++k) {
                for (long bitset = this.bitmap[k]; ac.cardinality < maxcardinality && bitset != 0L; bitset &= bitset - 1L) {
                    ac.content[pos++] = (short)(k * 64 + Long.numberOfTrailingZeros(bitset));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        BitmapContainer bc = new BitmapContainer(maxcardinality, this.bitmap);
        int s = Util.toIntUnsigned(this.select(maxcardinality));
        int usedwords = (s + 63) / 64;
        int todelete = this.bitmap.length - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap[bc.bitmap.length - 1 - k] = 0L;
        }
        int lastword = s % 64;
        if (lastword != 0) {
            int n = s / 64;
            bc.bitmap[n] = bc.bitmap[n] & -1L >>> 64 - lastword;
        }
        return bc;
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            short x = arrayContainer.content[k];
            int n = Util.toIntUnsigned(x) / 64;
            this.bitmap[n] = this.bitmap[n] | 1L << x;
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    public int nextClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            long map = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
            if (map != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(map);
            }
            ++x;
        }
        return 65536;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        BitmapContainer answer = this.clone();
        return answer.inot(firstOfRange, lastOfRange);
    }

    @Override
    int numberOfRuns() {
        int numRuns = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsAdjustment() {
        int ans = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            ans = (int)((long)ans + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL)));
        }
        long word = nextWord;
        if ((word & Long.MIN_VALUE) != 0L) {
            ++ans;
        }
        return ans;
    }

    public int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        for (int blockOffset = 0; blockOffset < this.bitmap.length; blockOffset += 128) {
            for (int i = blockOffset; i < blockOffset + 128; ++i) {
                long word = this.bitmap[i];
                numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            }
            if (numRuns <= mustNotExceed) continue;
            return numRuns;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w | 1L << v;
            answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer;
    }

    protected boolean isFull() {
        return this.cardinality == 65536;
    }

    @Override
    public Container or(BitmapContainer value2) {
        BitmapContainer value1 = this.clone();
        return value1.ior(value2);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap[x]);
            }
            --x;
        }
        return -1;
    }

    public int prevClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w <<= 64 - (i + 1)) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            long map = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
            if (map != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(map);
            }
            --x;
        }
        return -1;
    }

    @Override
    public int rank(short lowbits) {
        int x = Util.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        for (int k = 0; k < (x + 1) / 64; ++k) {
            answer += Long.bitCount(this.bitmap[k]);
        }
        if (leftover != 0) {
            answer += Long.bitCount(this.bitmap[(x + 1) / 64] << 64 - leftover);
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        Util.resetBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, 0);
        if (answer.getCardinality() <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container remove(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap[x / 64] = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - bef >>> 63));
        this.bitmap[index] = aft;
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
            if (this.isFull()) {
                return RunContainer.full();
            }
        }
        return this;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = RunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public short select(int j) {
        int leftover = j;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int w = Long.bitCount(this.bitmap[k]);
            if (w > leftover) {
                return (short)(k * 64 + Util.select(this.bitmap[k], leftover));
            }
            leftover -= w;
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        for (long w : this.bitmap) {
            out.writeLong(Long.reverseBytes(w));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return BitmapContainer.serializedSizeInBytes(0);
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        if (ac.getCardinality() != this.cardinality) {
            throw new RuntimeException("Internal error.");
        }
        return ac;
    }

    public LongBuffer toLongBuffer() {
        LongBuffer lb = LongBuffer.allocate(this.bitmap.length);
        lb.put(this.bitmap);
        return lb;
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableBitmapContainer(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PeekableShortIterator i = this.getShortIterator();
        sb.append("{");
        while (i.hasNext()) {
            sb.append(Util.toIntUnsigned(i.next()));
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    protected void writeArray(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        LongBuffer buf = buffer.asLongBuffer();
        buf.put(this.bitmap);
        int bytesWritten = this.bitmap.length * 8;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            int index = Util.toIntUnsigned(vc) >>> 6;
            long mask = 1L << vc;
            long val = answer.bitmap[index];
            answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((val & mask) >>> vc)));
            answer.bitmap[index] = val ^ mask;
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public void forEach(short msb, IntConsumer ic) {
        int high = msb << 16;
        for (int x = 0; x < this.bitmap.length; ++x) {
            for (long w = this.bitmap[x]; w != 0L; w &= w - 1L) {
                ic.accept(x * 64 + Long.numberOfTrailingZeros(w) | high);
            }
        }
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        return this;
    }

    @Override
    public int nextValue(short fromValue) {
        return this.nextSetBit(Util.toIntUnsigned(fromValue));
    }

    @Override
    public int previousValue(short fromValue) {
        return this.prevSetBit(Util.toIntUnsigned(fromValue));
    }

    @Override
    public int nextAbsentValue(short fromValue) {
        return this.nextClearBit(Util.toIntUnsigned(fromValue));
    }

    @Override
    public int previousAbsentValue(short fromValue) {
        return this.prevClearBit(Util.toIntUnsigned(fromValue));
    }

    @Override
    public int first() {
        int i;
        this.assertNonEmpty(this.cardinality == 0);
        for (i = 0; i < this.bitmap.length - 1 && this.bitmap[i] == 0L; ++i) {
        }
        return i * 64 + Long.numberOfTrailingZeros(this.bitmap[i]);
    }

    @Override
    public int last() {
        int i;
        this.assertNonEmpty(this.cardinality == 0);
        for (i = this.bitmap.length - 1; i > 0 && this.bitmap[i] == 0L; --i) {
        }
        return (i + 1) * 64 - Long.numberOfLeadingZeros(this.bitmap[i]) - 1;
    }
}

