/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Arrays;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class FastRankRoaringBitmap
extends RoaringBitmap {
    private boolean cumulatedCardinalitiesCacheIsValid = false;
    private int[] highToCumulatedCardinality = null;

    private void resetCache() {
        if (this.highToCumulatedCardinality != null && this.highToCumulatedCardinality.length >= 1) {
            this.cumulatedCardinalitiesCacheIsValid = false;
        }
    }

    boolean isCacheDismissed() {
        return !this.cumulatedCardinalitiesCacheIsValid;
    }

    @Override
    public void add(long rangeStart, long rangeEnd) {
        this.resetCache();
        super.add(rangeStart, rangeEnd);
    }

    @Override
    public void add(int x) {
        this.resetCache();
        super.add(x);
    }

    @Override
    public void add(int ... dat) {
        this.resetCache();
        super.add(dat);
    }

    @Override
    @Deprecated
    public void add(int rangeStart, int rangeEnd) {
        this.resetCache();
        super.add(rangeStart, rangeEnd);
    }

    @Override
    public void clear() {
        this.resetCache();
        super.clear();
    }

    @Override
    public void flip(int x) {
        this.resetCache();
        super.flip(x);
    }

    @Override
    @Deprecated
    public void flip(int rangeStart, int rangeEnd) {
        this.resetCache();
        super.flip(rangeStart, rangeEnd);
    }

    @Override
    public void flip(long rangeStart, long rangeEnd) {
        this.resetCache();
        super.flip(rangeStart, rangeEnd);
    }

    @Override
    public void and(RoaringBitmap x2) {
        this.resetCache();
        super.and(x2);
    }

    @Override
    public void andNot(RoaringBitmap x2) {
        this.resetCache();
        super.andNot(x2);
    }

    @Override
    @Deprecated
    public void remove(int rangeStart, int rangeEnd) {
        this.resetCache();
        super.remove(rangeStart, rangeEnd);
    }

    @Override
    public void remove(int x) {
        this.resetCache();
        super.remove(x);
    }

    @Override
    public void remove(long rangeStart, long rangeEnd) {
        this.resetCache();
        super.remove(rangeStart, rangeEnd);
    }

    @Override
    public boolean checkedAdd(int x) {
        this.resetCache();
        return super.checkedAdd(x);
    }

    @Override
    public boolean checkedRemove(int x) {
        this.resetCache();
        return super.checkedRemove(x);
    }

    @Override
    public void or(RoaringBitmap x2) {
        this.resetCache();
        super.or(x2);
    }

    @Override
    public void xor(RoaringBitmap x2) {
        this.resetCache();
        super.xor(x2);
    }

    private void preComputeCardinalities() {
        if (!this.cumulatedCardinalitiesCacheIsValid) {
            int nbBuckets = this.highLowContainer.size();
            if (this.highToCumulatedCardinality == null || this.highToCumulatedCardinality.length != nbBuckets) {
                this.highToCumulatedCardinality = new int[nbBuckets];
            }
            if (this.highToCumulatedCardinality.length >= 1) {
                this.highToCumulatedCardinality[0] = this.highLowContainer.getContainerAtIndex(0).getCardinality();
                for (int i = 1; i < this.highToCumulatedCardinality.length; ++i) {
                    this.highToCumulatedCardinality[i] = this.highToCumulatedCardinality[i - 1] + this.highLowContainer.getContainerAtIndex(i).getCardinality();
                }
            }
            this.cumulatedCardinalitiesCacheIsValid = true;
        }
    }

    @Override
    public long rankLong(int x) {
        boolean hasBitmapOnIdex;
        this.preComputeCardinalities();
        if (this.highLowContainer.size() == 0) {
            return 0L;
        }
        short xhigh = Util.highbits(x);
        int index = Util.hybridUnsignedBinarySearch(this.highLowContainer.keys, 0, this.highLowContainer.size(), xhigh);
        if (index < 0) {
            hasBitmapOnIdex = false;
            index = -1 - index;
        } else {
            hasBitmapOnIdex = true;
        }
        long size = 0L;
        if (index > 0) {
            size += (long)this.highToCumulatedCardinality[index - 1];
        }
        long rank = size;
        if (hasBitmapOnIdex) {
            rank = size + (long)this.highLowContainer.getContainerAtIndex(index).rank(Util.lowbits(x));
        }
        return rank;
    }

    @Override
    public int select(int j) {
        this.preComputeCardinalities();
        if (this.highLowContainer.size() == 0) {
            throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getCardinality());
        }
        int index = Arrays.binarySearch(this.highToCumulatedCardinality, j);
        long leftover = Util.toUnsignedLong(j);
        if (index == this.highToCumulatedCardinality.length - 1) {
            return this.last();
        }
        if (index >= 0) {
            int keycontrib = this.highLowContainer.getKeyAtIndex(index + 1) << 16;
            int output = keycontrib + this.highLowContainer.getContainerAtIndex(index + 1).first();
            return output;
        }
        int fixedIndex = -1 - index;
        if (fixedIndex > 0) {
            leftover -= (long)this.highToCumulatedCardinality[fixedIndex - 1];
        }
        int keycontrib = this.highLowContainer.getKeyAtIndex(fixedIndex) << 16;
        int lowcontrib = Util.toIntUnsigned(this.highLowContainer.getContainerAtIndex(fixedIndex).select((int)leftover));
        int value = lowcontrib + keycontrib;
        return value;
    }
}

