/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.buffer.MappeableContainerPointer;

public class RoaringBatchIterator
implements BatchIterator {
    private final MappeableContainerPointer containerPointer;
    int index = 0;
    int key;
    ContainerBatchIterator iterator;

    public RoaringBatchIterator(MappeableContainerPointer containerPointer) {
        this.containerPointer = containerPointer;
        this.nextIterator();
    }

    @Override
    public int nextBatch(int[] buffer) {
        int consumed = 0;
        if (this.iterator.hasNext()) {
            consumed += this.iterator.next(this.key, buffer);
        } else {
            this.containerPointer.advance();
            this.nextIterator();
            if (null != this.iterator) {
                return this.nextBatch(buffer);
            }
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return null != this.iterator;
    }

    private void nextIterator() {
        if (null != this.containerPointer && this.containerPointer.hasContainer()) {
            this.iterator = this.containerPointer.getContainer().getBatchIterator();
            this.key = this.containerPointer.key() << 16;
        } else {
            this.iterator = null;
        }
    }
}

