/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.MappeableContainer;

public abstract class Container
implements Iterable<Short>,
Cloneable,
Externalizable {
    public static final String[] ContainerNames = new String[]{"bitmap", "array", "run"};

    public static Container rangeOfOnes(int start, int last) {
        int arrayContainerOverRunThreshold = 2;
        int cardinality = last - start;
        if (cardinality <= 2) {
            return new ArrayContainer(start, last);
        }
        return new RunContainer(start, last);
    }

    public abstract Container add(int var1, int var2);

    public abstract Container add(short var1);

    public abstract Container and(ArrayContainer var1);

    public abstract Container and(BitmapContainer var1);

    public Container and(Container x) {
        if (x instanceof ArrayContainer) {
            return this.and((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.and((BitmapContainer)x);
        }
        return this.and((RunContainer)x);
    }

    public abstract Container and(RunContainer var1);

    protected abstract int andCardinality(ArrayContainer var1);

    protected abstract int andCardinality(BitmapContainer var1);

    protected abstract int andCardinality(RunContainer var1);

    public int andCardinality(Container x) {
        if (this.isEmpty()) {
            return 0;
        }
        if (x.isEmpty()) {
            return 0;
        }
        if (x instanceof ArrayContainer) {
            return this.andCardinality((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.andCardinality((BitmapContainer)x);
        }
        return this.andCardinality((RunContainer)x);
    }

    public int xorCardinality(Container other) {
        return this.getCardinality() + other.getCardinality() - 2 * this.andCardinality(other);
    }

    public abstract Container andNot(ArrayContainer var1);

    public abstract Container andNot(BitmapContainer var1);

    public Container andNot(Container x) {
        if (x instanceof ArrayContainer) {
            return this.andNot((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.andNot((BitmapContainer)x);
        }
        return this.andNot((RunContainer)x);
    }

    public abstract Container andNot(RunContainer var1);

    public abstract void clear();

    public abstract Container clone();

    public abstract boolean isEmpty();

    public abstract boolean contains(short var1);

    public abstract boolean contains(int var1, int var2);

    public boolean contains(Container subset) {
        if (subset instanceof RunContainer) {
            return this.contains((RunContainer)subset);
        }
        if (subset instanceof ArrayContainer) {
            return this.contains((ArrayContainer)subset);
        }
        if (subset instanceof BitmapContainer) {
            return this.contains((BitmapContainer)subset);
        }
        return false;
    }

    protected abstract boolean contains(RunContainer var1);

    protected abstract boolean contains(ArrayContainer var1);

    protected abstract boolean contains(BitmapContainer var1);

    public abstract void deserialize(DataInput var1) throws IOException;

    public abstract void fillLeastSignificant16bits(int[] var1, int var2, int var3);

    public abstract Container flip(short var1);

    protected abstract int getArraySizeInBytes();

    public abstract int getCardinality();

    public String getContainerName() {
        if (this instanceof BitmapContainer) {
            return ContainerNames[0];
        }
        if (this instanceof ArrayContainer) {
            return ContainerNames[1];
        }
        return ContainerNames[2];
    }

    public abstract void forEach(short var1, IntConsumer var2);

    public abstract ShortIterator getReverseShortIterator();

    public abstract PeekableShortIterator getShortIterator();

    public abstract ContainerBatchIterator getBatchIterator();

    public abstract int getSizeInBytes();

    public abstract Container iadd(int var1, int var2);

    public abstract Container iand(ArrayContainer var1);

    public abstract Container iand(BitmapContainer var1);

    public Container iand(Container x) {
        if (x instanceof ArrayContainer) {
            return this.iand((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.iand((BitmapContainer)x);
        }
        return this.iand((RunContainer)x);
    }

    public abstract Container iand(RunContainer var1);

    public abstract Container iandNot(ArrayContainer var1);

    public abstract Container iandNot(BitmapContainer var1);

    public Container iandNot(Container x) {
        if (x instanceof ArrayContainer) {
            return this.iandNot((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.iandNot((BitmapContainer)x);
        }
        return this.iandNot((RunContainer)x);
    }

    public abstract Container iandNot(RunContainer var1);

    public abstract Container inot(int var1, int var2);

    public abstract boolean intersects(ArrayContainer var1);

    public abstract boolean intersects(BitmapContainer var1);

    public boolean intersects(Container x) {
        if (x instanceof ArrayContainer) {
            return this.intersects((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.intersects((BitmapContainer)x);
        }
        return this.intersects((RunContainer)x);
    }

    public abstract boolean intersects(RunContainer var1);

    public abstract boolean intersects(int var1, int var2);

    public abstract Container ior(ArrayContainer var1);

    public abstract Container ior(BitmapContainer var1);

    public Container ior(Container x) {
        if (x instanceof ArrayContainer) {
            return this.ior((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.ior((BitmapContainer)x);
        }
        return this.ior((RunContainer)x);
    }

    public abstract Container ior(RunContainer var1);

    public abstract Container iremove(int var1, int var2);

    public abstract Container ixor(ArrayContainer var1);

    public abstract Container ixor(BitmapContainer var1);

    public Container ixor(Container x) {
        if (x instanceof ArrayContainer) {
            return this.ixor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.ixor((BitmapContainer)x);
        }
        return this.ixor((RunContainer)x);
    }

    public abstract Container ixor(RunContainer var1);

    public Container lazyIOR(Container x) {
        if (this instanceof ArrayContainer) {
            if (x instanceof ArrayContainer) {
                return ((ArrayContainer)this).lazyor((ArrayContainer)x);
            }
            if (x instanceof BitmapContainer) {
                return this.ior((BitmapContainer)x);
            }
            return ((RunContainer)x).lazyor((ArrayContainer)this);
        }
        if (this instanceof RunContainer) {
            if (x instanceof ArrayContainer) {
                return ((RunContainer)this).ilazyor((ArrayContainer)x);
            }
            if (x instanceof BitmapContainer) {
                return this.ior((BitmapContainer)x);
            }
            return this.ior((RunContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return ((BitmapContainer)this).ilazyor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return ((BitmapContainer)this).ilazyor((BitmapContainer)x);
        }
        return ((BitmapContainer)this).ilazyor((RunContainer)x);
    }

    public Container lazyOR(Container x) {
        if (this instanceof ArrayContainer) {
            if (x instanceof ArrayContainer) {
                return ((ArrayContainer)this).lazyor((ArrayContainer)x);
            }
            if (x instanceof BitmapContainer) {
                return ((BitmapContainer)x).lazyor((ArrayContainer)this);
            }
            return ((RunContainer)x).lazyor((ArrayContainer)this);
        }
        if (this instanceof RunContainer) {
            if (x instanceof ArrayContainer) {
                return ((RunContainer)this).lazyor((ArrayContainer)x);
            }
            if (x instanceof BitmapContainer) {
                return ((BitmapContainer)x).lazyor((RunContainer)this);
            }
            return this.or((RunContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return ((BitmapContainer)this).lazyor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return ((BitmapContainer)this).lazyor((BitmapContainer)x);
        }
        return ((BitmapContainer)this).lazyor((RunContainer)x);
    }

    public abstract Container limit(int var1);

    public abstract Container not(int var1, int var2);

    abstract int numberOfRuns();

    public abstract Container or(ArrayContainer var1);

    public abstract Container or(BitmapContainer var1);

    public Container or(Container x) {
        if (x instanceof ArrayContainer) {
            return this.or((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.or((BitmapContainer)x);
        }
        return this.or((RunContainer)x);
    }

    public abstract Container or(RunContainer var1);

    public abstract int rank(short var1);

    public abstract Container remove(int var1, int var2);

    public abstract Container remove(short var1);

    public abstract Container repairAfterLazy();

    public abstract Container runOptimize();

    public abstract short select(int var1);

    public abstract void serialize(DataOutput var1) throws IOException;

    public abstract int serializedSizeInBytes();

    public abstract MappeableContainer toMappeableContainer();

    public abstract void trim();

    protected abstract void writeArray(DataOutput var1) throws IOException;

    public abstract Container xor(ArrayContainer var1);

    public abstract Container xor(BitmapContainer var1);

    public Container xor(Container x) {
        if (x instanceof ArrayContainer) {
            return this.xor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.xor((BitmapContainer)x);
        }
        return this.xor((RunContainer)x);
    }

    public abstract Container xor(RunContainer var1);

    public abstract BitmapContainer toBitmapContainer();

    public abstract int nextValue(short var1);

    public abstract int first();

    public abstract int last();

    protected void assertNonEmpty(boolean condition) {
        if (condition) {
            throw new NoSuchElementException("Empty " + this.getContainerName());
        }
    }
}

