/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.ReverseRunContainerShortIterator;
import org.roaringbitmap.RunContainerShortIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;

public final class RunContainer
extends Container
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    private static final boolean ENABLE_GALLOPING_AND = false;
    private static final long serialVersionUID = 1L;
    private short[] valueslength;
    int nbrruns = 0;

    private static int branchyUnsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        int ikey = Util.toIntUnsigned(k);
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(array[2 * middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    private static int hybridUnsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        int x;
        int ikey = Util.toIntUnsigned(k);
        int low = begin;
        int high = end - 1;
        while (low + 16 <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(array[2 * middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int val = Util.toIntUnsigned(array[2 * x]);
            if (val < ikey) continue;
            if (val != ikey) break;
            return x;
        }
        return -(x + 1);
    }

    protected static int serializedSizeInBytes(int numberOfRuns) {
        return 2 + 4 * numberOfRuns;
    }

    private static int unsignedInterleavedBinarySearch(short[] array, int begin, int end, short k) {
        return RunContainer.hybridUnsignedInterleavedBinarySearch(array, begin, end, k);
    }

    public RunContainer() {
        this(4);
    }

    protected RunContainer(ArrayContainer arr, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = new short[2 * nbrRuns];
        if (nbrRuns == 0) {
            return;
        }
        int prevVal = -2;
        int runLen = 0;
        int runCount = 0;
        for (int i = 0; i < arr.cardinality; ++i) {
            int curVal = Util.toIntUnsigned(arr.content[i]);
            if (curVal == prevVal + 1) {
                ++runLen;
            } else {
                if (runCount > 0) {
                    this.setLength(runCount - 1, (short)runLen);
                }
                this.setValue(runCount, (short)curVal);
                runLen = 0;
                ++runCount;
            }
            prevVal = curVal;
        }
        this.setLength(runCount - 1, (short)runLen);
    }

    protected RunContainer(BitmapContainer bc, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = new short[2 * nbrRuns];
        if (nbrRuns == 0) {
            return;
        }
        int longCtr = 0;
        long curWord = bc.bitmap[0];
        int runCount = 0;
        while (true) {
            if (curWord == 0L && longCtr < bc.bitmap.length - 1) {
                curWord = bc.bitmap[++longCtr];
                continue;
            }
            if (curWord == 0L) {
                return;
            }
            int localRunStart = Long.numberOfTrailingZeros(curWord);
            int runStart = localRunStart + 64 * longCtr;
            long curWordWith1s = curWord | curWord - 1L;
            int runEnd = 0;
            while (curWordWith1s == -1L && longCtr < bc.bitmap.length - 1) {
                curWordWith1s = bc.bitmap[++longCtr];
            }
            if (curWordWith1s == -1L) {
                runEnd = 64 + longCtr * 64;
                this.setValue(runCount, (short)runStart);
                this.setLength(runCount, (short)(runEnd - runStart - 1));
                return;
            }
            int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
            runEnd = localRunEnd + longCtr * 64;
            this.setValue(runCount, (short)runStart);
            this.setLength(runCount, (short)(runEnd - runStart - 1));
            ++runCount;
            curWord = curWordWith1s & curWordWith1s + 1L;
        }
    }

    public RunContainer(int capacity) {
        this.valueslength = new short[2 * capacity];
    }

    private RunContainer(int nbrruns, short[] valueslength) {
        this.nbrruns = nbrruns;
        this.valueslength = Arrays.copyOf(valueslength, valueslength.length);
    }

    public RunContainer(MappeableRunContainer bc) {
        this.nbrruns = bc.numberOfRuns();
        this.valueslength = bc.toShortArray();
    }

    public RunContainer(short[] array, int numRuns) {
        if (array.length < 2 * numRuns) {
            throw new RuntimeException("Mismatch between buffer and numRuns");
        }
        this.nbrruns = numRuns;
        this.valueslength = array;
    }

    @Override
    public Container add(int begin, int end) {
        RunContainer rc = (RunContainer)this.clone();
        return rc.iadd(begin, end);
    }

    @Override
    public Container add(short k) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        if (index >= 0) {
            return this;
        }
        if ((index = -index - 2) >= 0) {
            int le;
            int offset = Util.toIntUnsigned(k) - Util.toIntUnsigned(this.getValue(index));
            if (offset <= (le = Util.toIntUnsigned(this.getLength(index)))) {
                return this;
            }
            if (offset == le + 1) {
                if (index + 1 < this.nbrruns && Util.toIntUnsigned(this.getValue(index + 1)) == Util.toIntUnsigned(k) + 1) {
                    this.setLength(index, (short)(this.getValue(index + 1) + this.getLength(index + 1) - this.getValue(index)));
                    this.recoverRoomAtIndex(index + 1);
                    return this;
                }
                this.incrementLength(index);
                return this;
            }
            if (index + 1 < this.nbrruns && Util.toIntUnsigned(this.getValue(index + 1)) == Util.toIntUnsigned(k) + 1) {
                this.setValue(index + 1, k);
                this.setLength(index + 1, (short)(this.getLength(index + 1) + 1));
                return this;
            }
        }
        if (index == -1 && 0 < this.nbrruns && this.getValue(0) == k + 1) {
            this.incrementLength(0);
            this.decrementValue(0);
            return this;
        }
        this.makeRoomAtIndex(index + 1);
        this.setValue(index + 1, k);
        this.setLength(index + 1, (short)0);
        return this;
    }

    @Override
    public Container and(ArrayContainer x) {
        ArrayContainer ac = new ArrayContainer(x.cardinality);
        if (this.nbrruns == 0) {
            return ac;
        }
        int rlepos = 0;
        int arraypos = 0;
        int rleval = Util.toIntUnsigned(this.getValue(rlepos));
        int rlelength = Util.toIntUnsigned(this.getLength(rlepos));
        while (arraypos < x.cardinality) {
            int arrayval = Util.toIntUnsigned(x.content[arraypos]);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return ac;
                }
                rleval = Util.toIntUnsigned(this.getValue(rlepos));
                rlelength = Util.toIntUnsigned(this.getLength(rlepos));
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, (short)rleval);
                continue;
            }
            ac.content[ac.cardinality] = (short)arrayval;
            ++ac.cardinality;
            ++arraypos;
        }
        return ac;
    }

    @Override
    public Container and(BitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            if (card > x.cardinality) {
                card = x.cardinality;
            }
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!x.contains((short)runValue)) continue;
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = x.clone();
        int start = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int end = Util.toIntUnsigned(this.getValue(rlepos));
            int prevOnes = answer.cardinalityInRange(start, end);
            Util.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, 0);
            start = end + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        int ones = answer.cardinalityInRange(start, 65536);
        Util.resetBitmapRange(answer.bitmap, start, 65536);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container and(RunContainer x) {
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.nbrruns)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        int start = Util.toIntUnsigned(this.getValue(rlepos));
        int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = Util.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            int lateststart;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = Util.toIntUnsigned(this.getValue(rlepos));
                end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            int n = lateststart = start > xstart ? start : xstart;
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = Util.toIntUnsigned(this.getValue(rlepos));
                    end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = Util.toIntUnsigned(this.getValue(rlepos));
                    end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            }
            answer.valueslength[2 * answer.nbrruns] = (short)lateststart;
            answer.valueslength[2 * answer.nbrruns + 1] = (short)(earliestend - lateststart - 1);
            ++answer.nbrruns;
        }
        return answer.toEfficientContainer();
    }

    @Override
    public int andCardinality(ArrayContainer x) {
        if (this.nbrruns == 0) {
            return x.cardinality;
        }
        int rlepos = 0;
        int arraypos = 0;
        int andCardinality = 0;
        int rleval = Util.toIntUnsigned(this.getValue(rlepos));
        int rlelength = Util.toIntUnsigned(this.getLength(rlepos));
        while (arraypos < x.cardinality) {
            int arrayval = Util.toIntUnsigned(x.content[arraypos]);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return andCardinality;
                }
                rleval = Util.toIntUnsigned(this.getValue(rlepos));
                rlelength = Util.toIntUnsigned(this.getLength(rlepos));
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            ++andCardinality;
            ++arraypos;
        }
        return andCardinality;
    }

    @Override
    public int andCardinality(BitmapContainer x) {
        int cardinality = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int runStart = Util.toIntUnsigned(this.getValue(rlepos));
            int runEnd = runStart + Util.toIntUnsigned(this.getLength(rlepos));
            for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                if (!x.contains((short)runValue)) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    @Override
    public int andCardinality(RunContainer x) {
        int cardinality = 0;
        int rlepos = 0;
        int xrlepos = 0;
        int start = Util.toIntUnsigned(this.getValue(rlepos));
        int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = Util.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            int lateststart;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = Util.toIntUnsigned(this.getValue(rlepos));
                end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            int n = lateststart = start > xstart ? start : xstart;
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = Util.toIntUnsigned(this.getValue(rlepos));
                    end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = Util.toIntUnsigned(this.getValue(rlepos));
                    end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                    xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                }
            }
            cardinality += earliestend - lateststart;
        }
        return cardinality;
    }

    @Override
    public Container andNot(ArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyandNot(x).toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            ArrayContainer ac = new ArrayContainer(card);
            ac.cardinality = Util.unsignedDifference(this.getShortIterator(), x.getShortIterator(), ac.content);
            return ac;
        }
        return this.toBitmapOrArrayContainer(card).iandNot(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (x.contains((short)runValue)) continue;
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = x.clone();
        int lastPos = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(this.getValue(rlepos));
            int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
            int prevOnes = answer.cardinalityInRange(lastPos, start);
            int flippedOnes = answer.cardinalityInRange(start, end);
            Util.resetBitmapRange(answer.bitmap, lastPos, start);
            Util.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes + flippedOnes, end - start - flippedOnes);
            lastPos = end;
        }
        int ones = answer.cardinalityInRange(lastPos, 65536);
        Util.resetBitmapRange(answer.bitmap, lastPos, 65536);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container andNot(RunContainer x) {
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.nbrruns)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        int start = Util.toIntUnsigned(this.getValue(rlepos));
        int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = Util.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                answer.valueslength[2 * answer.nbrruns] = (short)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (short)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = Util.toIntUnsigned(this.getValue(rlepos));
                end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            if (start < xstart) {
                answer.valueslength[2 * answer.nbrruns] = (short)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (short)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xend < end) {
                start = xend;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = Util.toIntUnsigned(this.getValue(rlepos));
            end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        if (rlepos < this.nbrruns) {
            answer.valueslength[2 * answer.nbrruns] = (short)start;
            answer.valueslength[2 * answer.nbrruns + 1] = (short)(end - start - 1);
            ++answer.nbrruns;
            if (++rlepos < this.nbrruns) {
                System.arraycopy(this.valueslength, 2 * rlepos, answer.valueslength, 2 * answer.nbrruns, 2 * (this.nbrruns - rlepos));
                answer.nbrruns = answer.nbrruns + this.nbrruns - rlepos;
            }
        }
        return answer.toEfficientContainer();
    }

    private void appendValueLength(int value, int index) {
        int length;
        int previousValue = Util.toIntUnsigned(this.getValue(index));
        int offset = value - previousValue;
        if (offset > (length = Util.toIntUnsigned(this.getLength(index)))) {
            this.setLength(index, (short)offset);
        }
    }

    private boolean canPrependValueLength(int value, int index) {
        int nextValue;
        return index < this.nbrruns && (nextValue = Util.toIntUnsigned(this.getValue(index))) == value + 1;
    }

    @Override
    public void clear() {
        this.nbrruns = 0;
    }

    @Override
    public Container clone() {
        return new RunContainer(this.nbrruns, this.valueslength);
    }

    private void closeValueLength(int value, int index) {
        int initialValue = Util.toIntUnsigned(this.getValue(index));
        this.setLength(index, (short)(value - initialValue));
    }

    @Override
    public boolean contains(short x) {
        int le;
        int offset;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            return true;
        }
        return (index = -index - 2) != -1 && (offset = Util.toIntUnsigned(x) - Util.toIntUnsigned(this.getValue(index))) <= (le = Util.toIntUnsigned(this.getLength(index)));
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int i1 = 0;
        int i2 = 0;
        int runCount = this.numberOfRuns();
        while (i1 < runCount && i2 < runContainer.numberOfRuns()) {
            short start1 = this.getValue(i1);
            int stop1 = start1 + Util.toIntUnsigned(this.getLength(i1));
            short start2 = runContainer.getValue(i2);
            int stop2 = start2 + Util.toIntUnsigned(runContainer.getLength(i2));
            if (start1 > start2) {
                return false;
            }
            if (stop1 > stop2) {
                ++i1;
                continue;
            }
            if (stop1 == stop2) {
                ++i1;
                ++i2;
                continue;
            }
            ++i2;
        }
        return i1 == runCount;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        int cardinality = this.getCardinality();
        int runCount = this.numberOfRuns();
        if (arrayContainer.getCardinality() > cardinality) {
            return false;
        }
        int ia = 0;
        int ir = 0;
        while (ia < arrayContainer.getCardinality() && ir <= runCount) {
            short start = this.getValue(ir);
            int stop = start + Util.toIntUnsigned(this.getLength(ir));
            if (arrayContainer.content[ia] < start) {
                return false;
            }
            if (arrayContainer.content[ia] > stop) {
                ++ir;
                continue;
            }
            ++ia;
        }
        return ia <= cardinality && ir <= runCount;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        int ib;
        int cardinality = this.getCardinality();
        if (bitmapContainer.getCardinality() != -1 && bitmapContainer.getCardinality() > cardinality) {
            return false;
        }
        int runCount = this.numberOfRuns();
        int ir = 0;
        for (ib = 0; ib < bitmapContainer.bitmap.length && ir < runCount; ib = (int)((short)(ib + 1))) {
            long w = bitmapContainer.bitmap[ib];
            while (w != 0L && ir < runCount) {
                short start = this.getValue(ir);
                int stop = start + Util.toIntUnsigned(this.getLength(ir));
                long t = w & -w;
                long r = ib * 64 + Long.numberOfTrailingZeros(w);
                if (r < (long)start) {
                    return false;
                }
                if (r > (long)stop) {
                    ir = (short)(ir + 1);
                    continue;
                }
                w ^= t;
            }
            if (w == 0L) {
                continue;
            }
            return false;
        }
        if (ib < bitmapContainer.bitmap.length) {
            while (ib < bitmapContainer.bitmap.length) {
                if (bitmapContainer.bitmap[ib] != 0L) {
                    return false;
                }
                ib = (short)(ib + 1);
            }
        }
        return true;
    }

    private Container convertToLazyBitmapIfNeeded() {
        if (this.nbrruns > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int start = Util.toIntUnsigned(this.getValue(rlepos));
                int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                Util.setBitmapRange(answer.bitmap, start, end);
            }
            answer.cardinality = -1;
            return answer;
        }
        return this;
    }

    private void copyToOffset(int offset) {
        int minCapacity = 2 * (offset + this.nbrruns);
        if (this.valueslength.length < minCapacity) {
            int newCapacity = this.valueslength.length;
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            short[] newvalueslength = new short[newCapacity];
            this.copyValuesLength(this.valueslength, 0, newvalueslength, offset, this.nbrruns);
            this.valueslength = newvalueslength;
        } else {
            this.copyValuesLength(this.valueslength, 0, this.valueslength, offset, this.nbrruns);
        }
    }

    private void copyValuesLength(short[] src, int srcIndex, short[] dst, int dstIndex, int length) {
        System.arraycopy(src, 2 * srcIndex, dst, 2 * dstIndex, 2 * length);
    }

    private void decrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (short)(this.valueslength[n] - 1);
    }

    private void decrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (short)(this.valueslength[n] - 1);
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.nbrruns = Short.reverseBytes(in.readShort());
        if (this.valueslength.length < 2 * this.nbrruns) {
            this.valueslength = new short[2 * this.nbrruns];
        }
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            this.valueslength[k] = Short.reverseBytes(in.readShort());
        }
    }

    protected void ensureCapacity(int minNbRuns) {
        int minCapacity = 2 * minNbRuns;
        if (this.valueslength.length < minCapacity) {
            int newCapacity = this.valueslength.length;
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            short[] nv = new short[newCapacity];
            this.copyValuesLength(this.valueslength, 0, nv, 0, this.nbrruns);
            this.valueslength = nv;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RunContainer) {
            return this.equals((RunContainer)o);
        }
        if (o instanceof ArrayContainer) {
            return this.equals((ArrayContainer)o);
        }
        if (o instanceof Container) {
            if (((Container)o).getCardinality() != this.getCardinality()) {
                return false;
            }
            PeekableShortIterator me = this.getShortIterator();
            PeekableShortIterator you = ((Container)o).getShortIterator();
            while (me.hasNext()) {
                if (me.next() == you.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equals(RunContainer runContainer) {
        if (runContainer.nbrruns != this.nbrruns) {
            return false;
        }
        for (int i = 0; i < this.nbrruns; ++i) {
            if (this.getValue(i) != runContainer.getValue(i)) {
                return false;
            }
            if (this.getLength(i) == runContainer.getLength(i)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ArrayContainer arrayContainer) {
        int pos = 0;
        for (int i = 0; i < this.nbrruns; i = (int)((short)(i + 1))) {
            short runStart = this.getValue(i);
            short length = this.getLength(i);
            if (pos + length >= arrayContainer.getCardinality()) {
                return false;
            }
            if (arrayContainer.content[pos] != runStart) {
                return false;
            }
            if (arrayContainer.content[pos + length] != runStart + length) {
                return false;
            }
            pos += length + 1;
        }
        return pos == arrayContainer.getCardinality();
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        for (int k = 0; k < this.nbrruns; ++k) {
            int limit = Util.toIntUnsigned(this.getLength(k));
            int base = Util.toIntUnsigned(this.getValue(k));
            for (int le = 0; le <= limit; ++le) {
                x[pos++] = base + le | mask;
            }
        }
    }

    @Override
    public Container flip(short x) {
        if (this.contains(x)) {
            return this.remove(x);
        }
        return this.add(x);
    }

    @Override
    protected int getArraySizeInBytes() {
        return 2 + 4 * this.nbrruns;
    }

    @Override
    public int getCardinality() {
        int sum = this.nbrruns;
        for (int k = 0; k < this.nbrruns; ++k) {
            sum += Util.toIntUnsigned(this.getLength(k));
        }
        return sum;
    }

    short getLength(int index) {
        return this.valueslength[2 * index + 1];
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseRunContainerShortIterator(this);
    }

    @Override
    public PeekableShortIterator getShortIterator() {
        return new RunContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.nbrruns * 4 + 4;
    }

    short getValue(int index) {
        return this.valueslength[2 * index];
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.nbrruns * 2; ++k) {
            hash += 31 * hash + this.valueslength[k];
        }
        return hash;
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.add((short)begin);
            return this;
        }
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)begin);
        int eIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)(end - 1));
        if (bIndex >= 0 && eIndex >= 0) {
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex >= 0 && eIndex < 0) {
            if (this.canPrependValueLength(end - 1, (eIndex = -eIndex - 2) + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex < 0 && eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin - 1, bIndex)) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            this.prependValueLength(begin, bIndex + 1);
            this.mergeValuesLength(bIndex + 1, eIndex);
            return this;
        }
        bIndex = -bIndex - 2;
        if ((eIndex = -eIndex - 2) >= 0) {
            if (bIndex >= 0) {
                if (!this.valueLengthContains(begin - 1, bIndex)) {
                    if (bIndex == eIndex) {
                        if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                            this.prependValueLength(begin, eIndex + 1);
                            return this;
                        }
                        this.makeRoomAtIndex(eIndex + 1);
                        this.setValue(eIndex + 1, (short)begin);
                        this.setLength(eIndex + 1, (short)(end - 1 - begin));
                        return this;
                    }
                    this.prependValueLength(begin, ++bIndex);
                }
            } else {
                bIndex = 0;
                this.prependValueLength(begin, bIndex);
            }
            if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (this.canPrependValueLength(end - 1, 0)) {
            this.prependValueLength(begin, 0);
        } else {
            this.makeRoomAtIndex(0);
            this.setValue(0, (short)begin);
            this.setLength(0, (short)(end - 1 - begin));
        }
        return this;
    }

    @Override
    public Container iand(ArrayContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(BitmapContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(RunContainer x) {
        return this.and(x);
    }

    @Override
    public Container iandNot(ArrayContainer x) {
        return this.andNot(x);
    }

    @Override
    public Container iandNot(BitmapContainer x) {
        return this.andNot(x);
    }

    @Override
    public Container iandNot(RunContainer x) {
        return this.andNot(x);
    }

    protected Container ilazyor(ArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.ilazyorToRun(x);
    }

    private Container ilazyorToRun(ArrayContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableShortIterator i = x.getShortIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (Util.compareUnsigned(this.getValue(rlepos + offset), i.peekNext()) <= 0) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
            }
        }
        return this.convertToLazyBitmapIfNeeded();
    }

    private void increaseCapacity() {
        int newCapacity = this.valueslength.length == 0 ? 4 : (this.valueslength.length < 64 ? this.valueslength.length * 2 : (this.valueslength.length < 1024 ? this.valueslength.length * 3 / 2 : this.valueslength.length * 5 / 4));
        short[] nv = new short[newCapacity];
        System.arraycopy(this.valueslength, 0, nv, 0, 2 * this.nbrruns);
        this.valueslength = nv;
    }

    private void incrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (short)(this.valueslength[n] + 1);
    }

    private void incrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (short)(this.valueslength[n] + 1);
    }

    private void initValueLength(int value, int index) {
        int initialValue = Util.toIntUnsigned(this.getValue(index));
        int length = Util.toIntUnsigned(this.getLength(index));
        this.setValue(index, (short)value);
        this.setLength(index, (short)(length - (value - initialValue)));
    }

    @Override
    public Container inot(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this;
        }
        if (this.valueslength.length <= 2 * this.nbrruns + 1) {
            boolean lastValueBeforeRange = false;
            boolean firstValueInRange = false;
            boolean lastValueInRange = false;
            boolean firstValuePastRange = false;
            if (rangeStart > 0) {
                lastValueBeforeRange = this.contains((short)(rangeStart - 1));
            }
            if (lastValueBeforeRange == (firstValueInRange = this.contains((short)rangeStart))) {
                lastValueInRange = this.contains((short)(rangeEnd - 1));
                if (rangeEnd != 65536) {
                    firstValuePastRange = this.contains((short)rangeEnd);
                }
                if (lastValueInRange == firstValuePastRange) {
                    return this.not(rangeStart, rangeEnd);
                }
            }
        }
        int myNbrRuns = this.nbrruns;
        RunContainer ans = this;
        ans.nbrruns = 0;
        for (k = 0; k < myNbrRuns && Util.toIntUnsigned(this.getValue(k)) < rangeStart; ++k) {
            ++ans.nbrruns;
        }
        short bufferedValue = 0;
        short bufferedLength = 0;
        short nextValue = 0;
        short nextLength = 0;
        if (k < myNbrRuns) {
            bufferedValue = this.getValue(k);
            bufferedLength = this.getLength(k);
        }
        ans.smartAppendExclusive((short)rangeStart, (short)(rangeEnd - rangeStart - 1));
        while (k < myNbrRuns) {
            if (ans.nbrruns > k + 1) {
                throw new RuntimeException("internal error in inot, writer has overtaken reader!! " + k + " " + ans.nbrruns);
            }
            if (k + 1 < myNbrRuns) {
                nextValue = this.getValue(k + 1);
                nextLength = this.getLength(k + 1);
            }
            ans.smartAppendExclusive(bufferedValue, bufferedLength);
            bufferedValue = nextValue;
            bufferedLength = nextLength;
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public boolean intersects(ArrayContainer x) {
        if (this.nbrruns == 0) {
            return false;
        }
        int rlepos = 0;
        int arraypos = 0;
        int rleval = Util.toIntUnsigned(this.getValue(rlepos));
        int rlelength = Util.toIntUnsigned(this.getLength(rlepos));
        while (arraypos < x.cardinality) {
            int arrayval = Util.toIntUnsigned(x.content[arraypos]);
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return false;
                }
                rleval = Util.toIntUnsigned(this.getValue(rlepos));
                rlelength = Util.toIntUnsigned(this.getLength(rlepos));
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer x) {
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int runStart = Util.toIntUnsigned(this.getValue(rlepos));
            int runEnd = runStart + Util.toIntUnsigned(this.getLength(rlepos));
            for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                if (!x.contains((short)runValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        int rlepos = 0;
        int xrlepos = 0;
        int start = Util.toIntUnsigned(this.getValue(rlepos));
        int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = Util.toIntUnsigned(x.getValue(xrlepos));
        int xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = Util.toIntUnsigned(this.getValue(rlepos));
                end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = Util.toIntUnsigned(x.getValue(xrlepos));
                xend = xstart + Util.toIntUnsigned(x.getLength(xrlepos)) + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Container ior(ArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableShortIterator i = x.getShortIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (Util.compareUnsigned(this.getValue(rlepos + offset), i.peekNext()) <= 0) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
            }
        }
        return this.toEfficientContainer();
    }

    @Override
    public Container ior(BitmapContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.or(x);
    }

    @Override
    public Container ior(RunContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int xnbrruns = x.nbrruns;
        int offset = Math.max(nbrruns, xnbrruns);
        this.copyToOffset(offset);
        this.nbrruns = 0;
        int rlepos = 0;
        int xrlepos = 0;
        while (rlepos < nbrruns && xrlepos < xnbrruns) {
            short value = this.getValue(offset + rlepos);
            short xvalue = x.getValue(xrlepos);
            short length = this.getLength(offset + rlepos);
            short xlength = x.getLength(xrlepos);
            if (Util.compareUnsigned(value, xvalue) <= 0) {
                this.smartAppend(value, length);
                ++rlepos;
                continue;
            }
            this.smartAppend(xvalue, xlength);
            ++xrlepos;
        }
        while (rlepos < nbrruns) {
            this.smartAppend(this.getValue(offset + rlepos), this.getLength(offset + rlepos));
            ++rlepos;
        }
        while (xrlepos < xnbrruns) {
            this.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        return this.toBitmapIfNeeded();
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.remove((short)begin);
            return this;
        }
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)begin);
        int eIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (short)(end - 1));
        if (bIndex >= 0) {
            if (eIndex < 0) {
                eIndex = -eIndex - 2;
            }
            if (this.valueLengthContains(end, eIndex)) {
                this.initValueLength(end, eIndex);
                this.recoverRoomsInRange(bIndex - 1, eIndex - 1);
            } else {
                this.recoverRoomsInRange(bIndex - 1, eIndex);
            }
        } else if (bIndex < 0 && eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin, bIndex)) {
                this.closeValueLength(begin - 1, bIndex);
            }
            if (this.getLength(eIndex) == 0) {
                this.recoverRoomsInRange(eIndex, eIndex + 1);
            } else {
                this.incrementValue(eIndex);
                this.decrementLength(eIndex);
            }
            this.recoverRoomsInRange(bIndex, eIndex - 1);
        } else {
            bIndex = -bIndex - 2;
            if ((eIndex = -eIndex - 2) >= 0) {
                if (bIndex >= 0) {
                    if (bIndex == eIndex) {
                        if (this.valueLengthContains(begin, bIndex)) {
                            if (this.valueLengthContains(end, eIndex)) {
                                this.makeRoomAtIndex(bIndex);
                                this.closeValueLength(begin - 1, bIndex);
                                this.initValueLength(end, bIndex + 1);
                                return this;
                            }
                            this.closeValueLength(begin - 1, bIndex);
                        }
                    } else {
                        if (this.valueLengthContains(begin, bIndex)) {
                            this.closeValueLength(begin - 1, bIndex);
                        }
                        if (this.valueLengthContains(end, eIndex)) {
                            this.initValueLength(end, eIndex);
                            --eIndex;
                        }
                        this.recoverRoomsInRange(bIndex, eIndex);
                    }
                } else if (this.valueLengthContains(end, eIndex)) {
                    this.initValueLength(end, eIndex);
                    this.recoverRoomsInRange(bIndex, eIndex - 1);
                } else {
                    this.recoverRoomsInRange(bIndex, eIndex);
                }
            }
        }
        return this;
    }

    protected boolean isFull() {
        return this.nbrruns == 1 && this.getValue(0) == 0 && this.getLength(0) == -1;
    }

    public static Container full() {
        return new RunContainer(1, new short[]{0, -1});
    }

    @Override
    public Iterator<Short> iterator() {
        final PeekableShortIterator i = this.getShortIterator();
        return new Iterator<Short>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Short next() {
                return i.next();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer x) {
        return this.xor(x);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return this.xor(x);
    }

    @Override
    public Container ixor(RunContainer x) {
        return this.xor(x);
    }

    private RunContainer lazyandNot(ArrayContainer x) {
        if (x.getCardinality() == 0) {
            return this;
        }
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.cardinality)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        int start = Util.toIntUnsigned(this.getValue(rlepos));
        int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        int xstart = Util.toIntUnsigned(x.content[xrlepos]);
        while (rlepos < this.nbrruns && xrlepos < x.cardinality) {
            if (end <= xstart) {
                answer.valueslength[2 * answer.nbrruns] = (short)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (short)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = Util.toIntUnsigned(this.getValue(rlepos));
                end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
                continue;
            }
            if (xstart + 1 <= start) {
                if (++xrlepos >= x.cardinality) continue;
                xstart = Util.toIntUnsigned(x.content[xrlepos]);
                continue;
            }
            if (start < xstart) {
                answer.valueslength[2 * answer.nbrruns] = (short)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (short)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xstart + 1 < end) {
                start = xstart + 1;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = Util.toIntUnsigned(this.getValue(rlepos));
            end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
        }
        if (rlepos < this.nbrruns) {
            answer.valueslength[2 * answer.nbrruns] = (short)start;
            answer.valueslength[2 * answer.nbrruns + 1] = (short)(end - start - 1);
            ++answer.nbrruns;
            if (++rlepos < this.nbrruns) {
                System.arraycopy(this.valueslength, 2 * rlepos, answer.valueslength, 2 * answer.nbrruns, 2 * (this.nbrruns - rlepos));
                answer.nbrruns = answer.nbrruns + this.nbrruns - rlepos;
            }
        }
        return answer;
    }

    protected Container lazyor(ArrayContainer x) {
        return this.lazyorToRun(x);
    }

    private Container lazyorToRun(ArrayContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.getCardinality())], 0);
        int rlepos = 0;
        PeekableShortIterator i = x.getShortIterator();
        while (i.hasNext() && rlepos < this.nbrruns) {
            if (Util.compareUnsigned(this.getValue(rlepos), i.peekNext()) <= 0) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                answer.smartAppend(i.next());
            }
        } else {
            while (rlepos < this.nbrruns) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer.convertToLazyBitmapIfNeeded();
    }

    private Container lazyxor(ArrayContainer x) {
        if (x.getCardinality() == 0) {
            return this;
        }
        if (this.nbrruns == 0) {
            return x;
        }
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.getCardinality())], 0);
        int rlepos = 0;
        PeekableShortIterator i = x.getShortIterator();
        short cv = i.next();
        while (true) {
            if (Util.compareUnsigned(this.getValue(rlepos), cv) < 0) {
                answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                if (++rlepos != this.nbrruns) continue;
                answer.smartAppendExclusive(cv);
                while (i.hasNext()) {
                    answer.smartAppendExclusive(i.next());
                }
                break;
            }
            answer.smartAppendExclusive(cv);
            if (!i.hasNext()) {
                while (rlepos < this.nbrruns) {
                    answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                    ++rlepos;
                }
                break;
            }
            cv = i.next();
        }
        return answer;
    }

    @Override
    public Container limit(int maxcardinality) {
        int r;
        if (maxcardinality >= this.getCardinality()) {
            return this.clone();
        }
        int cardinality = 0;
        for (r = 0; r < this.nbrruns && maxcardinality > (cardinality += Util.toIntUnsigned(this.getLength(r)) + 1); ++r) {
        }
        RunContainer rc = new RunContainer(Arrays.copyOf(this.valueslength, 2 * (r + 1)), r + 1);
        rc.setLength(r, (short)(Util.toIntUnsigned(rc.getLength(r)) - cardinality + maxcardinality));
        return rc;
    }

    private void makeRoomAtIndex(int index) {
        if (2 * (this.nbrruns + 1) > this.valueslength.length) {
            this.increaseCapacity();
        }
        this.copyValuesLength(this.valueslength, index, this.valueslength, index + 1, this.nbrruns - index);
        ++this.nbrruns;
    }

    private void mergeValuesLength(int begin, int end) {
        if (begin < end) {
            int bValue = Util.toIntUnsigned(this.getValue(begin));
            int eValue = Util.toIntUnsigned(this.getValue(end));
            int eLength = Util.toIntUnsigned(this.getLength(end));
            int newLength = eValue - bValue + eLength;
            this.setLength(begin, (short)newLength);
            this.recoverRoomsInRange(begin, end);
        }
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this.clone();
        }
        RunContainer ans = new RunContainer(this.nbrruns + 1);
        for (k = 0; k < this.nbrruns && Util.toIntUnsigned(this.getValue(k)) < rangeStart; ++k) {
            ans.valueslength[2 * k] = this.valueslength[2 * k];
            ans.valueslength[2 * k + 1] = this.valueslength[2 * k + 1];
            ++ans.nbrruns;
        }
        ans.smartAppendExclusive((short)rangeStart, (short)(rangeEnd - rangeStart - 1));
        while (k < this.nbrruns) {
            ans.smartAppendExclusive(this.getValue(k), this.getLength(k));
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public int numberOfRuns() {
        return this.nbrruns;
    }

    @Override
    public Container or(ArrayContainer x) {
        return this.lazyor(x).repairAfterLazy();
    }

    @Override
    public Container or(BitmapContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        BitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(this.getValue(rlepos));
            int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            Util.setBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, end - start);
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer;
    }

    @Override
    public Container or(RunContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        if (x.isFull()) {
            return RunContainer.full();
        }
        RunContainer answer = new RunContainer(new short[2 * (this.nbrruns + x.nbrruns)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        while (xrlepos < x.nbrruns && rlepos < this.nbrruns) {
            if (Util.compareUnsigned(this.getValue(rlepos), x.getValue(xrlepos)) <= 0) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (xrlepos < x.nbrruns) {
            answer.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (rlepos < this.nbrruns) {
            answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
            ++rlepos;
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer.toBitmapIfNeeded();
    }

    private void prependValueLength(int value, int index) {
        int initialValue = Util.toIntUnsigned(this.getValue(index));
        int length = Util.toIntUnsigned(this.getLength(index));
        this.setValue(index, (short)value);
        this.setLength(index, (short)(initialValue - value + length));
    }

    @Override
    public int rank(short lowbits) {
        int x = Util.toIntUnsigned(lowbits);
        int answer = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int value = Util.toIntUnsigned(this.getValue(k));
            int length = Util.toIntUnsigned(this.getLength(k));
            if (x < value) {
                return answer;
            }
            if (value + length + 1 > x) {
                return answer + x - value + 1;
            }
            answer += length + 1;
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private void recoverRoomAtIndex(int index) {
        this.copyValuesLength(this.valueslength, index + 1, this.valueslength, index, this.nbrruns - index - 1);
        --this.nbrruns;
    }

    private void recoverRoomsInRange(int begin, int end) {
        if (end + 1 < this.nbrruns) {
            this.copyValuesLength(this.valueslength, end + 1, this.valueslength, begin + 1, this.nbrruns - 1 - end);
        }
        this.nbrruns -= end - begin;
    }

    @Override
    public Container remove(int begin, int end) {
        RunContainer rc = (RunContainer)this.clone();
        return rc.iremove(begin, end);
    }

    @Override
    public Container remove(short x) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            if (this.getLength(index) == 0) {
                this.recoverRoomAtIndex(index);
            } else {
                this.incrementValue(index);
                this.decrementLength(index);
            }
            return this;
        }
        if ((index = -index - 2) >= 0) {
            int le;
            int offset = Util.toIntUnsigned(x) - Util.toIntUnsigned(this.getValue(index));
            if (offset < (le = Util.toIntUnsigned(this.getLength(index)))) {
                this.setLength(index, (short)(offset - 1));
                int newvalue = Util.toIntUnsigned(x) + 1;
                int newlength = le - offset - 1;
                this.makeRoomAtIndex(index + 1);
                this.setValue(index + 1, (short)newvalue);
                this.setLength(index + 1, (short)newlength);
                return this;
            }
            if (offset == le) {
                this.decrementLength(index);
            }
        }
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        return this.toEfficientContainer();
    }

    @Override
    public Container runOptimize() {
        return this.toEfficientContainer();
    }

    @Override
    public short select(int j) {
        int offset = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int nextOffset = offset + Util.toIntUnsigned(this.getLength(k)) + 1;
            if (nextOffset > j) {
                return (short)(this.getValue(k) + (j - offset));
            }
            offset = nextOffset;
        }
        throw new IllegalArgumentException("Cannot select " + j + " since cardinality is " + this.getCardinality());
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public int serializedSizeInBytes() {
        return RunContainer.serializedSizeInBytes(this.nbrruns);
    }

    private void setLength(int index, short v) {
        this.setLength(this.valueslength, index, v);
    }

    private void setLength(short[] valueslength, int index, short v) {
        valueslength[2 * index + 1] = v;
    }

    private void setValue(int index, short v) {
        this.setValue(this.valueslength, index, v);
    }

    private void setValue(short[] valueslength, int index, short v) {
        valueslength[2 * index] = v;
    }

    private int skipAhead(RunContainer skippingOn, int pos, int targetToExceed) {
        int end;
        int left = pos;
        int span = 1;
        int probePos = 0;
        do {
            if ((probePos = left + span) >= skippingOn.nbrruns - 1 && (end = Util.toIntUnsigned(skippingOn.getValue(probePos = skippingOn.nbrruns - 1)) + Util.toIntUnsigned(skippingOn.getLength(probePos)) + 1) <= targetToExceed) {
                return skippingOn.nbrruns;
            }
            end = Util.toIntUnsigned(skippingOn.getValue(probePos)) + Util.toIntUnsigned(skippingOn.getLength(probePos)) + 1;
            span *= 2;
        } while (end <= targetToExceed);
        int right = probePos;
        while (right - left > 1) {
            int mid = (right + left) / 2;
            int midVal = Util.toIntUnsigned(skippingOn.getValue(mid)) + Util.toIntUnsigned(skippingOn.getLength(mid)) + 1;
            if (midVal > targetToExceed) {
                right = mid;
                continue;
            }
            left = mid;
        }
        return right;
    }

    private void smartAppend(short val) {
        int oldend;
        block5: {
            block4: {
                if (this.nbrruns == 0) break block4;
                oldend = Util.toIntUnsigned(this.valueslength[2 * (this.nbrruns - 1)]) + Util.toIntUnsigned(this.valueslength[2 * (this.nbrruns - 1) + 1]);
                if (Util.toIntUnsigned(val) <= oldend + 1) break block5;
            }
            this.valueslength[2 * this.nbrruns] = val;
            this.valueslength[2 * this.nbrruns + 1] = 0;
            ++this.nbrruns;
            return;
        }
        if (val == (short)(oldend + 1)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (short)(this.valueslength[n] + 1);
        }
    }

    private void smartAppend(short start, short length) {
        int oldend;
        block5: {
            block4: {
                if (this.nbrruns == 0) break block4;
                oldend = Util.toIntUnsigned(this.getValue(this.nbrruns - 1)) + Util.toIntUnsigned(this.getLength(this.nbrruns - 1));
                if (Util.toIntUnsigned(start) <= oldend + 1) break block5;
            }
            this.valueslength[2 * this.nbrruns] = start;
            this.valueslength[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        int newend = Util.toIntUnsigned(start) + Util.toIntUnsigned(length) + 1;
        if (newend > oldend) {
            this.setLength(this.nbrruns - 1, (short)(newend - 1 - Util.toIntUnsigned(this.getValue(this.nbrruns - 1))));
        }
    }

    private void smartAppendExclusive(short val) {
        int oldend;
        block10: {
            block9: {
                if (this.nbrruns == 0) break block9;
                oldend = Util.toIntUnsigned(this.getValue(this.nbrruns - 1)) + Util.toIntUnsigned(this.getLength(this.nbrruns - 1)) + 1;
                if (Util.toIntUnsigned(val) <= oldend) break block10;
            }
            this.valueslength[2 * this.nbrruns] = val;
            this.valueslength[2 * this.nbrruns + 1] = 0;
            ++this.nbrruns;
            return;
        }
        if (oldend == Util.toIntUnsigned(val)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (short)(this.valueslength[n] + 1);
            return;
        }
        int newend = Util.toIntUnsigned(val) + 1;
        if (Util.toIntUnsigned(val) == Util.toIntUnsigned(this.getValue(this.nbrruns - 1))) {
            if (newend != oldend) {
                this.setValue(this.nbrruns - 1, (short)newend);
                this.setLength(this.nbrruns - 1, (short)(oldend - newend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (short)(val - Util.toIntUnsigned(this.getValue(this.nbrruns - 1)) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (short)newend);
            this.setLength(this.nbrruns, (short)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (oldend < newend) {
            this.setValue(this.nbrruns, (short)oldend);
            this.setLength(this.nbrruns, (short)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    private void smartAppendExclusive(short start, short length) {
        int oldend;
        block11: {
            block10: {
                if (this.nbrruns == 0) break block10;
                oldend = Util.toIntUnsigned(this.getValue(this.nbrruns - 1)) + Util.toIntUnsigned(this.getLength(this.nbrruns - 1)) + 1;
                if (Util.toIntUnsigned(start) <= oldend) break block11;
            }
            this.valueslength[2 * this.nbrruns] = start;
            this.valueslength[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        if (oldend == Util.toIntUnsigned(start)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (short)(this.valueslength[n] + (length + 1));
            return;
        }
        int newend = Util.toIntUnsigned(start) + Util.toIntUnsigned(length) + 1;
        if (Util.toIntUnsigned(start) == Util.toIntUnsigned(this.getValue(this.nbrruns - 1))) {
            if (newend < oldend) {
                this.setValue(this.nbrruns - 1, (short)newend);
                this.setLength(this.nbrruns - 1, (short)(oldend - newend - 1));
                return;
            }
            if (newend > oldend) {
                this.setValue(this.nbrruns - 1, (short)oldend);
                this.setLength(this.nbrruns - 1, (short)(newend - oldend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (short)(start - Util.toIntUnsigned(this.getValue(this.nbrruns - 1)) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (short)newend);
            this.setLength(this.nbrruns, (short)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (newend > oldend) {
            this.setValue(this.nbrruns, (short)oldend);
            this.setLength(this.nbrruns, (short)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    private Container toBitmapIfNeeded() {
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(this.nbrruns);
        int sizeAsBitmapContainer = BitmapContainer.serializedSizeInBytes(0);
        if (sizeAsBitmapContainer > sizeAsRunContainer) {
            return this;
        }
        return this.toBitmapContainer();
    }

    Container toBitmapOrArrayContainer(int card) {
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(this.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(this.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(this.getValue(rlepos));
            int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
            Util.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    private Container toEfficientContainer() {
        int card;
        int sizeAsArrayContainer;
        int sizeAsBitmapContainer;
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(this.nbrruns);
        if (sizeAsRunContainer <= Math.min(sizeAsBitmapContainer = BitmapContainer.serializedSizeInBytes(0), sizeAsArrayContainer = ArrayContainer.serializedSizeInBytes(card = this.getCardinality()))) {
            return this;
        }
        return this.toBitmapOrArrayContainer(card);
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableRunContainer(this);
    }

    public ShortBuffer toShortBuffer() {
        ShortBuffer sb = ShortBuffer.allocate(this.nbrruns * 2);
        sb.put(this.valueslength, 0, this.nbrruns * 2);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < this.nbrruns; ++k) {
            sb.append("[");
            sb.append(Util.toIntUnsigned(this.getValue(k)));
            sb.append(",");
            sb.append(Util.toIntUnsigned(this.getValue(k)) + Util.toIntUnsigned(this.getLength(k)));
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.valueslength.length == 2 * this.nbrruns) {
            return;
        }
        this.valueslength = Arrays.copyOf(this.valueslength, 2 * this.nbrruns);
    }

    private boolean valueLengthContains(int value, int index) {
        int length;
        int initialValue = Util.toIntUnsigned(this.getValue(index));
        return value <= initialValue + (length = Util.toIntUnsigned(this.getLength(index)));
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        out.writeShort(Short.reverseBytes((short)this.nbrruns));
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            out.writeShort(Short.reverseBytes(this.valueslength[k]));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyxor(x).repairAfterLazy();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            return x.xor(this.getShortIterator());
        }
        return this.toBitmapOrArrayContainer(card).ixor(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        BitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(this.getValue(rlepos));
            int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
            int prevOnes = answer.cardinalityInRange(start, end);
            Util.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, end - start - prevOnes);
        }
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container xor(RunContainer x) {
        RunContainer answer;
        block6: {
            if (x.nbrruns == 0) {
                return this.clone();
            }
            if (this.nbrruns == 0) {
                return x.clone();
            }
            answer = new RunContainer(new short[2 * (this.nbrruns + x.nbrruns)], 0);
            int rlepos = 0;
            int xrlepos = 0;
            while (true) {
                if (Util.compareUnsigned(this.getValue(rlepos), x.getValue(xrlepos)) < 0) {
                    answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                    if (++rlepos != this.nbrruns) continue;
                    while (xrlepos < x.nbrruns) {
                        answer.smartAppendExclusive(x.getValue(xrlepos), x.getLength(xrlepos));
                        ++xrlepos;
                    }
                    break block6;
                }
                answer.smartAppendExclusive(x.getValue(xrlepos), x.getLength(xrlepos));
                if (++xrlepos == x.nbrruns) break;
            }
            while (rlepos < this.nbrruns) {
                answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        return answer.toEfficientContainer();
    }

    @Override
    public void forEach(short msb, IntConsumer ic) {
        int high = msb << 16;
        for (int k = 0; k < this.nbrruns; ++k) {
            int base = this.getValue(k) & 0xFFFF | high;
            int le = this.getLength(k) & 0xFFFF;
            for (int l = base; l <= base + le; ++l) {
                ic.accept(l);
            }
        }
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        int card = this.getCardinality();
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(this.getValue(rlepos));
            int end = start + Util.toIntUnsigned(this.getLength(rlepos)) + 1;
            Util.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    @Override
    public int first() {
        this.assertNonEmpty(this.numberOfRuns() == 0);
        return Util.toIntUnsigned(this.valueslength[0]);
    }

    @Override
    public int last() {
        this.assertNonEmpty(this.numberOfRuns() == 0);
        int index = this.numberOfRuns() - 1;
        int start = Util.toIntUnsigned(this.getValue(index));
        int length = Util.toIntUnsigned(this.getLength(index));
        return start + length;
    }
}

