/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.ShortIterator;

public final class Util {
    public static boolean USE_BRANCHLESS_BINSEARCH = true;

    private Util() {
    }

    public static int advanceUntil(short[] array, int pos, int length, short min) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || Util.toIntUnsigned(array[lower]) >= Util.toIntUnsigned(min)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && Util.toIntUnsigned(array[lower + spansize]) < Util.toIntUnsigned(min)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array[upper] == min) {
            return upper;
        }
        if (Util.toIntUnsigned(array[upper]) < Util.toIntUnsigned(min)) {
            return length;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (array[mid] == min) {
                return mid;
            }
            if (Util.toIntUnsigned(array[mid]) < Util.toIntUnsigned(min)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public static void fillArrayAND(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] & bitmap2[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    public static void fillArrayANDNOT(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] & (bitmap2[k] ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    public static void fillArrayXOR(short[] container, long[] bitmap1, long[] bitmap2) {
        int pos = 0;
        if (bitmap1.length != bitmap2.length) {
            throw new IllegalArgumentException("not supported");
        }
        for (int k = 0; k < bitmap1.length; ++k) {
            long t;
            for (long bitset = bitmap1[k] ^ bitmap2[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    protected static short highbits(int x) {
        return (short)(x >>> 16);
    }

    protected static short lowbits(int x) {
        return (short)(x & 0xFFFF);
    }

    protected static short maxLowBit() {
        return -1;
    }

    protected static int maxLowBitAsInteger() {
        return 65535;
    }

    protected static int toIntUnsigned(short x) {
        return x & 0xFFFF;
    }

    public static int unsignedBinarySearch(short[] array, int begin, int end, short k) {
        if (USE_BRANCHLESS_BINSEARCH) {
            return Util.branchlessUnsignedBinarySearch(array, begin, end, k);
        }
        return Util.branchyUnsignedBinarySearch(array, begin, end, k);
    }

    protected static int branchlessUnsignedBinarySearch(short[] array, int begin, int end, short k) {
        int ikey = Util.toIntUnsigned(k);
        if (end > 0 && Util.toIntUnsigned(array[end - 1]) < ikey) {
            return -end - 1;
        }
        int n = end - begin;
        if (n == 0) {
            return -1;
        }
        int pos = 0;
        while (n > 1) {
            int half = n >>> 1;
            n -= half;
            int index = pos + half;
            int val = array[index + begin] & 0xFFFF;
            int diff = val - ikey;
            int mask = diff >> 31;
            int addition = half & mask;
            pos += addition;
        }
        if (Util.toIntUnsigned(array[pos + begin]) < ikey) {
            ++pos;
        }
        if (pos + begin < end && Util.toIntUnsigned(array[pos + begin]) == ikey) {
            return pos + begin;
        }
        return -(pos + begin + 1);
    }

    protected static int branchyUnsignedBinarySearch(short[] array, int begin, int end, short k) {
        int ikey = Util.toIntUnsigned(k);
        if (end > 0 && Util.toIntUnsigned(array[end - 1]) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(array[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public static int unsignedDifference(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos;
        block6: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == length2) {
                System.arraycopy(set1, 0, buffer, 0, length1);
                return length1;
            }
            if (0 == length1) {
                return 0;
            }
            while (true) {
                if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                    buffer[pos++] = set1[k1];
                    if (++k1 < length1) continue;
                    break block6;
                }
                if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                    ++k2;
                    if (++k1 < length1) {
                        if (k2 < length2) continue;
                        System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                        return pos + length1 - k1;
                    }
                    break block6;
                }
                if (++k2 >= length2) break;
            }
            System.arraycopy(set1, k1, buffer, pos, length1 - k1);
            return pos + length1 - k1;
        }
        return pos;
    }

    public static int unsignedDifference(ShortIterator set1, ShortIterator set2, short[] buffer) {
        int pos = 0;
        if (!set2.hasNext()) {
            while (set1.hasNext()) {
                buffer[pos++] = set1.next();
            }
            return pos;
        }
        if (!set1.hasNext()) {
            return 0;
        }
        short v1 = set1.next();
        short v2 = set2.next();
        while (true) {
            if (Util.toIntUnsigned(v1) < Util.toIntUnsigned(v2)) {
                buffer[pos++] = v1;
                if (!set1.hasNext()) {
                    return pos;
                }
                v1 = set1.next();
                continue;
            }
            if (v1 == v2) {
                if (!set1.hasNext()) break;
                if (!set2.hasNext()) {
                    while (set1.hasNext()) {
                        buffer[pos++] = set1.next();
                    }
                    return pos;
                }
                v1 = set1.next();
                v2 = set2.next();
                continue;
            }
            if (!set2.hasNext()) {
                buffer[pos++] = v1;
                while (set1.hasNext()) {
                    buffer[pos++] = set1.next();
                }
                return pos;
            }
            v2 = set2.next();
        }
        return pos;
    }

    public static int unsignedExclusiveUnion2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, 0, buffer, 0, length2);
            return length2;
        }
        while (true) {
            if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                buffer[pos++] = set1[k1];
                if (++k1 < length1) continue;
                System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                return pos + length2 - k2;
            }
            if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                ++k2;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 < length2) continue;
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            buffer[pos++] = set2[k2];
            if (++k2 >= length2) break;
        }
        System.arraycopy(set1, k1, buffer, pos, length1 - k1);
        return pos + length1 - k1;
    }

    public static int unsignedIntersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        if (set1.length * 64 < set2.length) {
            return Util.unsignedOneSidedGallopingIntersect2by2(set1, length1, set2, length2, buffer);
        }
        if (set2.length * 64 < set1.length) {
            return Util.unsignedOneSidedGallopingIntersect2by2(set2, length2, set1, length1, buffer);
        }
        return Util.unsignedLocalIntersect2by2(set1, length1, set2, length2, buffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsignedLocalIntersect2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (true) {
            if (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1])) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1]));
            }
            if (Util.toIntUnsigned(set1[k1]) >= Util.toIntUnsigned(set2[k2])) {
                buffer[pos++] = set1[k1];
                if (++k1 == length1) {
                    return pos;
                }
                if (++k2 != length2) continue;
                return pos;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2]));
        }
    }

    protected static int unsignedOneSidedGallopingIntersect2by2(short[] smallSet, int smallLength, short[] largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (Util.toIntUnsigned(largeSet[k1]) >= Util.toIntUnsigned(smallSet[k2]) || (k1 = Util.advanceUntil(largeSet, k1, largeLength, smallSet[k2])) != largeLength) {
            if (Util.toIntUnsigned(smallSet[k2]) < Util.toIntUnsigned(largeSet[k1])) {
                if (++k2 != smallLength) continue;
                break;
            }
            buffer[pos++] = smallSet[k2];
            if (++k2 != smallLength && (k1 = Util.advanceUntil(largeSet, k1, largeLength, smallSet[k2])) != largeLength) continue;
            break;
        }
        return pos;
    }

    public static int unsignedUnion2by2(short[] set1, int length1, short[] set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            System.arraycopy(set1, 0, buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            System.arraycopy(set2, 0, buffer, 0, length2);
            return length2;
        }
        while (true) {
            if (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2])) {
                buffer[pos++] = set1[k1];
                if (++k1 < length1) continue;
                System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                return pos + length2 - k2;
            }
            if (Util.toIntUnsigned(set1[k1]) == Util.toIntUnsigned(set2[k2])) {
                buffer[pos++] = set1[k1];
                ++k2;
                if (++k1 >= length1) {
                    System.arraycopy(set2, k2, buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 < length2) continue;
                System.arraycopy(set1, k1, buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            buffer[pos++] = set2[k2];
            if (++k2 >= length2) break;
        }
        System.arraycopy(set1, k1, buffer, pos, length1 - k1);
        return pos + length1 - k1;
    }

    public static int select(long w, int j) {
        int counter;
        int ww;
        int seen = 0;
        int part = (int)(w & 0xFFFFFFFFFFFFFFFFL);
        int n = Integer.bitCount(part);
        if (n <= j) {
            part = (int)(w >>> 32);
            seen += 32;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFFFF)) <= j) {
            part = ww >>> 16;
            seen += 16;
            j -= n;
        }
        if ((n = Integer.bitCount(part = (ww = part) & 0xFF)) <= j) {
            part = ww >>> 8;
            seen += 8;
            j -= n;
        }
        ww = part;
        for (counter = 0; counter < 8 && (j -= ww >>> counter & 1) >= 0; ++counter) {
        }
        return seen + counter;
    }

    public static void flipBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        int n = firstword;
        bitmap[n] = bitmap[n] ^ (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword; i < endword; ++i) {
            bitmap[i] = bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] ^ -1L >>> -end;
    }

    public static void resetBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] & (-1L << start & -1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] & (-1L << start ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = 0L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] & (-1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void setBitmapRange(long[] bitmap, int start, int end) {
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            bitmap[n] = bitmap[n] | -1L << start & -1L >>> -end;
            return;
        }
        int n = firstword;
        bitmap[n] = bitmap[n] | -1L << start;
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap[i] = -1L;
        }
        int n2 = endword;
        bitmap[n2] = bitmap[n2] | -1L >>> -end;
    }

    public static int compareUnsigned(short a, short b) {
        return Util.toIntUnsigned(a) - Util.toIntUnsigned(b);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean unsignedIntersects(short[] set1, int length1, short[] set2, int length2) {
        if (0 == length1) return false;
        if (0 == length2) {
            return false;
        }
        int k1 = 0;
        int k2 = 0;
        while (true) {
            if (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1])) {
                do {
                    if (++k2 != length2) continue;
                    return false;
                } while (Util.toIntUnsigned(set2[k2]) < Util.toIntUnsigned(set1[k1]));
            }
            if (Util.toIntUnsigned(set1[k1]) >= Util.toIntUnsigned(set2[k2])) return true;
            do {
                if (++k1 != length1) continue;
                return false;
            } while (Util.toIntUnsigned(set1[k1]) < Util.toIntUnsigned(set2[k2]));
        }
    }
}

