/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringArray;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.PointableRoaringArray;

public class ImmutableRoaringBitmap
implements Iterable<Integer>,
Cloneable {
    PointableRoaringArray highLowContainer = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MutableRoaringBitmap and(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        MappeableContainerPointer i1 = x1.highLowContainer.getContainerPointer();
        MappeableContainerPointer i2 = x2.highLowContainer.getContainerPointer();
        if (!i1.hasContainer() || !i2.hasContainer()) return answer;
        while (true) {
            if (i1.key() < i2.key()) {
                i1.advance();
                if (i1.hasContainer()) continue;
                return answer;
            }
            if (i1.key() > i2.key()) {
                i2.advance();
                if (i2.hasContainer()) continue;
                return answer;
            }
            MappeableContainer c = i1.getContainer().and(i2.getContainer());
            if (c.getCardinality() > 0) {
                answer.getMappeableRoaringArray().append(i1.key(), c);
            }
            i1.advance();
            i2.advance();
            if (!i1.hasContainer() || !i2.hasContainer()) return answer;
        }
    }

    public static MutableRoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        MappeableContainerPointer i1 = x1.highLowContainer.getContainerPointer();
        MappeableContainerPointer i2 = x2.highLowContainer.getContainerPointer();
        if (i1.hasContainer() && i2.hasContainer()) {
            while (true) {
                if (i1.key() < i2.key()) {
                    answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                    i1.advance();
                    if (i1.hasContainer()) continue;
                    break;
                }
                if (i1.key() > i2.key()) {
                    i2.advance();
                    if (i2.hasContainer()) continue;
                    break;
                }
                MappeableContainer c = i1.getContainer().andNot(i2.getContainer());
                if (c.getCardinality() > 0) {
                    answer.getMappeableRoaringArray().append(i1.key(), c);
                }
                i1.advance();
                i2.advance();
                if (!i1.hasContainer() || !i2.hasContainer()) break;
            }
        }
        if (!i2.hasContainer()) {
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    public static MutableRoaringBitmap flip(ImmutableRoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            throw new RuntimeException("Invalid range " + rangeStart + " -- " + rangeEnd);
        }
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        short hbStart = BufferUtil.highbits(rangeStart);
        short lbStart = BufferUtil.lowbits(rangeStart);
        short hbLast = BufferUtil.highbits(rangeEnd - 1);
        short lbLast = BufferUtil.lowbits(rangeEnd - 1);
        answer.getMappeableRoaringArray().appendCopiesUntil(bm.highLowContainer, hbStart);
        int max = BufferUtil.toIntUnsigned(BufferUtil.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? BufferUtil.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? BufferUtil.toIntUnsigned(lbLast) : max;
            int i = bm.highLowContainer.getIndex(hb);
            int j = answer.getMappeableRoaringArray().getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                MappeableContainer c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, hb, MappeableContainer.rangeOfOnes(containerStart, containerLast));
        }
        answer.getMappeableRoaringArray().appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer;
        block7: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block6: {
                answer = new MutableRoaringBitmap();
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() < i2.key()) {
                            answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        if (i1.key() > i2.key()) {
                            answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                            i2.advance();
                            if (i2.hasContainer()) continue;
                            break;
                        }
                        answer.getMappeableRoaringArray().append(i1.key(), i1.getContainer().or(i2.getContainer()));
                        i1.advance();
                        i2.advance();
                        if (!i1.hasContainer() || !i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block6;
                while (i2.hasContainer()) {
                    answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                    i2.advance();
                }
                break block7;
            }
            if (i2.hasContainer()) break block7;
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer;
        block8: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block7: {
                answer = new MutableRoaringBitmap();
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() < i2.key()) {
                            answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        if (i1.key() > i2.key()) {
                            i2.advance();
                            if (i2.hasContainer()) continue;
                            break;
                        }
                        MappeableContainer c = i1.getContainer().xor(i2.getContainer());
                        if (c.getCardinality() > 0) {
                            answer.getMappeableRoaringArray().append(i1.key(), c);
                        }
                        i1.advance();
                        i2.advance();
                        if (!i1.hasContainer() || !i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block7;
                while (i2.hasContainer()) {
                    answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                    i2.advance();
                }
                break block8;
            }
            if (i2.hasContainer()) break block8;
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    protected ImmutableRoaringBitmap() {
    }

    public ImmutableRoaringBitmap(ByteBuffer b) {
        this.highLowContainer = new ImmutableRoaringArray(b);
    }

    public ImmutableRoaringBitmap clone() {
        try {
            MutableRoaringBitmap x = (MutableRoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    public boolean contains(int x) {
        short hb = BufferUtil.highbits(x);
        MappeableContainer c = this.highLowContainer.getContainer(hb);
        return c != null && c.contains(BufferUtil.lowbits(x));
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringBitmap) {
            if (this.highLowContainer.size() != ((ImmutableRoaringBitmap)o).highLowContainer.size()) {
                return false;
            }
            MappeableContainerPointer mp1 = this.highLowContainer.getContainerPointer();
            MappeableContainerPointer mp2 = ((ImmutableRoaringBitmap)o).highLowContainer.getContainerPointer();
            while (mp1.hasContainer()) {
                if (mp1.key() != mp2.key()) {
                    return false;
                }
                if (mp1.getCardinality() != mp2.getCardinality()) {
                    return false;
                }
                if (!mp1.getContainer().equals(mp2.getContainer())) {
                    return false;
                }
                mp1.advance();
                mp2.advance();
            }
            return true;
        }
        return false;
    }

    public int getCardinality() {
        int size = 0;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += this.highLowContainer.getCardinality(i);
        }
        return size;
    }

    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    public IntIterator getIntIterator() {
        return new ImmutableRoaringIntIterator();
    }

    public int getSizeInBytes() {
        int size = 4;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += 4 + BufferUtil.getSizeInBytesFromCardinality(this.highLowContainer.getCardinality(i));
        }
        return size;
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            ShortIterator iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < ImmutableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getShortIterator();
                    this.hs = BufferUtil.toIntUnsigned(ImmutableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify.");
            }
        }.init();
    }

    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = BufferUtil.toIntUnsigned(this.highLowContainer.getKeyAtIndex(pos)) << 16;
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    public MutableRoaringBitmap toMutableRoaringBitmap() {
        MutableRoaringBitmap c = new MutableRoaringBitmap();
        MappeableContainerPointer mcp = this.highLowContainer.getContainerPointer();
        while (mcp.hasContainer()) {
            c.getMappeableRoaringArray().appendCopy(mcp.key(), mcp.getContainer());
            mcp.advance();
        }
        return c;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public int rank(int x) {
        int size = 0;
        short xhigh = BufferUtil.highbits(x);
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            short key = this.highLowContainer.getKeyAtIndex(i);
            if (key < xhigh) {
                size += this.highLowContainer.getCardinality(i);
                continue;
            }
            return size + this.highLowContainer.getContainerAtIndex(i).rank(BufferUtil.lowbits(x));
        }
        return size;
    }

    public int select(int j) {
        int leftover = j;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            int thiscard = this.highLowContainer.getCardinality(i);
            if (thiscard > leftover) {
                int keycontrib = this.highLowContainer.getKeyAtIndex(i) << 16;
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(i);
                int lowcontrib = BufferUtil.toIntUnsigned(c.select(leftover));
                return lowcontrib + keycontrib;
            }
            leftover -= thiscard;
        }
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getCardinality());
    }

    public MutableRoaringBitmap limit(int maxcardinality) {
        MappeableContainer c;
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        int currentcardinality = 0;
        for (int i = 0; currentcardinality < maxcardinality && i < this.highLowContainer.size(); currentcardinality += c.getCardinality(), ++i) {
            c = this.highLowContainer.getContainerAtIndex(i);
            if (c.getCardinality() + currentcardinality <= maxcardinality) {
                ((MutableRoaringArray)answer.highLowContainer).append(this.highLowContainer.getKeyAtIndex(i), c.clone());
                continue;
            }
            int leftover = maxcardinality - currentcardinality;
            MappeableContainer limited = c.limit(leftover);
            ((MutableRoaringArray)answer.highLowContainer).append(this.highLowContainer.getKeyAtIndex(i), limited);
            break;
        }
        return answer;
    }

    private final class ImmutableRoaringIntIterator
    implements IntIterator {
        MappeableContainerPointer cp;
        int hs;
        ShortIterator iter;
        boolean ok;

        public ImmutableRoaringIntIterator() {
            this.cp = ImmutableRoaringBitmap.this.highLowContainer.getContainerPointer();
            this.hs = 0;
            this.init();
        }

        @Override
        public boolean hasNext() {
            return this.ok;
        }

        public IntIterator init() {
            this.ok = this.cp.hasContainer();
            if (this.ok) {
                this.iter = this.cp.getContainer().getShortIterator();
                this.hs = BufferUtil.toIntUnsigned(this.cp.key()) << 16;
            }
            return this;
        }

        @Override
        public IntIterator clone() {
            try {
                ImmutableRoaringIntIterator x = (ImmutableRoaringIntIterator)super.clone();
                x.iter = this.iter.clone();
                x.cp = this.cp.clone();
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public int next() {
            int x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
            if (!this.iter.hasNext()) {
                this.cp.advance();
                this.init();
            }
            return x;
        }
    }
}

