/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;

public final class ArrayContainer
extends Container
implements Cloneable,
Serializable {
    private static final int DEFAULT_INIT_SIZE = 4;
    static final int DEFAULT_MAX_SIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    short[] content;

    public ArrayContainer() {
        this(4);
    }

    public ArrayContainer(int capacity) {
        this.content = new short[capacity];
    }

    public ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun + 1;
        this.content = new short[valuesInRange];
        for (int i = 0; i < valuesInRange; ++i) {
            this.content[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private ArrayContainer(int newCard, short[] newContent) {
        this.cardinality = newCard;
        this.content = Arrays.copyOf(newContent, newCard);
    }

    protected ArrayContainer(short[] newContent) {
        this.cardinality = newContent.length;
        this.content = newContent;
    }

    @Override
    public Container add(short x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                BitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
            this.content[-loc - 1] = x;
            ++this.cardinality;
        }
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public ArrayContainer andNot(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public ArrayContainer andNot(BitmapContainer value2) {
        ArrayContainer answer = new ArrayContainer(this.content.length);
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(this.content[k])) continue;
            answer.content[pos++] = this.content[k];
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public ArrayContainer clone() {
        return new ArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return Util.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        byte[] buffer = new byte[2];
        in.readFully(buffer);
        this.cardinality = buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
        if (this.content.length < this.cardinality) {
            this.content = new short[this.cardinality];
        }
        for (int k = 0; k < this.cardinality; ++k) {
            in.readFully(buffer);
            this.content[k] = (short)((buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayContainer) {
            ArrayContainer srb = (ArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            for (int i = 0; i < this.cardinality; ++i) {
                if (this.content[i] == srb.content[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        for (int k = 0; k < this.cardinality; ++k) {
            x[k + i] = Util.toIntUnsigned(this.content[k]) | mask;
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return this.cardinality * 2;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public short next() {
                return ArrayContainer.this.content[this.pos++];
            }

            @Override
            public ShortIterator clone() {
                try {
                    return (ShortIterator)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                --this.pos;
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2 + 4;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * this.content[k];
        }
        return hash;
    }

    @Override
    public ArrayContainer iand(ArrayContainer value2) {
        ArrayContainer value1 = this;
        value1.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content);
        return this;
    }

    @Override
    public Container iand(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (!value2.contains(this.content[k])) continue;
            this.content[pos++] = this.content[k];
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public ArrayContainer iandNot(ArrayContainer value2) {
        this.cardinality = Util.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content);
        return this;
    }

    @Override
    public ArrayContainer iandNot(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(this.content[k])) continue;
            this.content[pos++] = this.content[k];
        }
        this.cardinality = pos;
        return this;
    }

    private void increaseCapacity() {
        int newCapacity;
        int n = this.content.length < 64 ? this.content.length * 2 : (newCapacity = this.content.length < 1024 ? this.content.length * 3 / 2 : this.content.length * 5 / 4);
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        this.content = Arrays.copyOf(this.content, newCapacity);
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange + 1;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        short[] buffer = new short[newValuesInRange];
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.length) {
                if (newCardinality >= 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                this.content = Arrays.copyOf(this.content, newCardinality);
            }
            System.arraycopy(this.content, lastIndex + 1, this.content, lastIndex + 1 + cardinalityChange, this.cardinality - 1 - lastIndex);
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                System.arraycopy(this.content, startIndex + newValuesInRange - cardinalityChange, this.content, startIndex + newValuesInRange, newCardinality - (startIndex + newValuesInRange));
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public Container ior(ArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public Container ior(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return ArrayContainer.this.content[s];
            }

            @Override
            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    protected void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content);
    }

    private void negateRange(short[] buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange <= lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                buffer[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastRange) {
            buffer[outPos++] = (short)valInRange;
            ++valInRange;
        }
        if (outPos != buffer.length) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.length);
        }
        int i = startIndex;
        for (short item : buffer) {
            this.content[i++] = item;
        }
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange > lastOfRange) {
            return this.clone();
        }
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange + 1) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) >= 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer(newCardinality);
        System.arraycopy(this.content, 0, answer.content, 0, startIndex);
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange <= lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                answer.content[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastOfRange) {
            answer.content[outPos++] = (short)valInRange;
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content[outPos++] = this.content[i];
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    public Container or(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(value2.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << value2.content[k];
            }
            for (k = 0; k < this.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(this.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << this.content[k];
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredCapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(short x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        out.write(this.cardinality & 0xFF);
        out.write(this.cardinality >>> 8 & 0xFF);
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content[k] & 0xFF);
            out.write(this.content[k] >>> 8 & 0xFF);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return this.cardinality * 2 + 2;
    }

    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content[i]);
            sb.append(",");
        }
        sb.append(this.content[this.cardinality - 1]);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        this.content = Arrays.copyOf(this.content, this.cardinality);
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content[k] & 0xFF);
            out.write(this.content[k] >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(value2.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << value2.content[k];
            }
            for (k = 0; k < this.cardinality; ++k) {
                int n = i = Util.toIntUnsigned(this.content[k]) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << this.content[k];
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredCapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public int rank(short lowbits) {
        int answer = Util.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    @Override
    public short select(int j) {
        return this.content[j];
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality < this.getCardinality()) {
            return new ArrayContainer(maxcardinality, this.content);
        }
        return this.clone();
    }
}

