/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;

public final class RoaringArray
implements Cloneable,
Externalizable {
    protected static final short SERIAL_COOKIE = 12346;
    private static final long serialVersionUID = 7L;
    Element[] array = new Element[4];
    int size = 0;
    static final int INITIAL_CAPACITY = 4;

    protected RoaringArray() {
    }

    protected void append(short key, Container value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopy(RoaringArray sa, int index) {
        this.extendArray(1);
        this.array[this.size++] = new Element(sa.array[index].key, sa.array[index].value.clone());
    }

    protected void appendCopy(RoaringArray sa, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopiesUntil(RoaringArray sourceArray, short stoppingKey) {
        int stopKey = Util.toIntUnsigned(stoppingKey);
        for (int i = 0; i < sourceArray.size && Util.toIntUnsigned(sourceArray.array[i].key) < stopKey; ++i) {
            this.extendArray(1);
            this.array[this.size++] = new Element(sourceArray.array[i].key, sourceArray.array[i].value.clone());
        }
    }

    protected void appendCopiesAfter(RoaringArray sa, short beforeStart) {
        int startLocation = sa.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(sa.size - startLocation);
        for (int i = startLocation; i < sa.size; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    public RoaringArray clone() throws CloneNotSupportedException {
        RoaringArray sa = (RoaringArray)super.clone();
        sa.array = Arrays.copyOf(this.array, this.size);
        for (int k = 0; k < this.size; ++k) {
            sa.array[k] = sa.array[k].clone();
        }
        sa.size = this.size;
        return sa;
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringArray) {
            RoaringArray srb = (RoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                Element self = this.array[i];
                Element other = srb.array[i];
                if (self.key == other.key && self.value.equals(other.value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newCapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    protected Container getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    protected Container getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    protected int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    protected int advanceUntil(short x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || Util.toIntUnsigned(this.array[lower].key) >= Util.toIntUnsigned(x)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && Util.toIntUnsigned(this.array[lower + spansize].key) < Util.toIntUnsigned(x)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.array[upper].key == x) {
            return upper;
        }
        if (Util.toIntUnsigned(this.array[upper].key) < Util.toIntUnsigned(x)) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.array[mid].key == x) {
                return mid;
            }
            if (Util.toIntUnsigned(this.array[mid].key) < Util.toIntUnsigned(x)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    protected short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    public int hashCode() {
        int hashvalue = 0;
        for (int k = 0; k < this.size; ++k) {
            hashvalue = 31 * hashvalue + this.array[k].hashCode();
        }
        return hashvalue;
    }

    protected void insertNewKeyValueAt(int i, short key, Container value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    protected void resize(int newLength) {
        Arrays.fill(this.array, newLength, this.size, null);
        this.size = newLength;
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void removeIndexRange(int begin, int end) {
        if (end <= begin) {
            return;
        }
        int range = end - begin;
        System.arraycopy(this.array, end, this.array, begin, this.size - end);
        for (int i = 1; i <= range; ++i) {
            this.array[this.size - i] = null;
        }
        this.size -= range;
    }

    protected void copyRange(int begin, int end, int newBegin) {
        int range = end - begin;
        System.arraycopy(this.array, begin, this.array, newBegin, range);
    }

    protected void setContainerAtIndex(int i, Container c) {
        this.array[i].value = c;
    }

    protected void replaceKeyAndContainerAtIndex(int i, short key, Container c) {
        this.array[i].key = key;
        this.array[i].value = c;
    }

    protected int size() {
        return this.size;
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        int k;
        out.writeInt(Integer.reverseBytes(12346));
        out.writeInt(Integer.reverseBytes(this.size));
        for (int k2 = 0; k2 < this.size; ++k2) {
            out.writeShort(Short.reverseBytes(this.array[k2].key));
            out.writeShort(Short.reverseBytes((short)(this.array[k2].value.getCardinality() - 1)));
        }
        int startOffset = 8 + 4 * this.size + 4 * this.size;
        for (k = 0; k < this.size; ++k) {
            out.writeInt(Integer.reverseBytes(startOffset));
            startOffset += BufferUtil.getSizeInBytesFromCardinality(this.array[k].value.getCardinality());
        }
        for (k = 0; k < this.size; ++k) {
            this.array[k].value.writeArray(out);
        }
    }

    public int serializedSizeInBytes() {
        int count = 8 + 4 * this.size + 4 * this.size;
        for (int k = 0; k < this.size; ++k) {
            count += this.array[k].value.getArraySizeInBytes();
        }
        return count;
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        this.clear();
        int cookie = Integer.reverseBytes(in.readInt());
        if (cookie != 12346) {
            throw new IOException("I failed to find the right cookie.");
        }
        this.size = Integer.reverseBytes(in.readInt());
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = Short.reverseBytes(in.readShort());
            cardinalities[k] = 1 + (0xFFFF & Short.reverseBytes(in.readShort()));
            isBitmap[k] = cardinalities[k] > 4096;
        }
        in.skipBytes(this.size * 4);
        for (k = 0; k < this.size; ++k) {
            Container val;
            int l;
            if (isBitmap[k]) {
                long[] bitmapArray = new long[1024];
                for (l = 0; l < bitmapArray.length; ++l) {
                    bitmapArray[l] = Long.reverseBytes(in.readLong());
                }
                val = new BitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                short[] shortArray = new short[cardinalities[k]];
                for (l = 0; l < shortArray.length; ++l) {
                    shortArray[l] = Short.reverseBytes(in.readShort());
                }
                val = new ArrayContainer(shortArray);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    protected ContainerPointer getContainerPointer() {
        return new ContainerPointer(){
            int k = 0;

            @Override
            public Container getContainer() {
                if (this.k >= RoaringArray.this.size) {
                    return null;
                }
                return RoaringArray.this.array[this.k].value;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public short key() {
                return RoaringArray.this.array[this.k].key;
            }

            @Override
            public int compareTo(ContainerPointer o) {
                if (this.key() != o.key()) {
                    return Util.toIntUnsigned(this.key()) - Util.toIntUnsigned(o.key());
                }
                return o.getContainer().getCardinality() - this.getContainer().getCardinality();
            }
        };
    }

    protected static final class Element
    implements Cloneable,
    Comparable<Element> {
        short key;
        Container value = null;

        public Element(short key, Container value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key * 0xF0F0F0 + this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element e = (Element)o;
                return e.key == this.key && e.value.equals(this.value);
            }
            return false;
        }

        public Element clone() throws CloneNotSupportedException {
            Element c = (Element)super.clone();
            c.value = this.value.clone();
            return c;
        }

        @Override
        public int compareTo(Element o) {
            return Util.toIntUnsigned(this.key) - Util.toIntUnsigned(o.key);
        }
    }
}

