/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.Util;

public final class RoaringBitmap
implements Cloneable,
Serializable,
Iterable<Integer>,
Externalizable {
    private static final long serialVersionUID = 6L;
    RoaringArray highLowContainer = new RoaringArray();

    public static RoaringBitmap and(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = x1.highLowContainer.getContainerAtIndex(pos1).and(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        return answer;
    }

    public static RoaringBitmap andNot(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = x1.highLowContainer.getContainerAtIndex(pos1).andNot(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap bitmapOf(int ... dat) {
        RoaringBitmap ans = new RoaringBitmap();
        for (int i : dat) {
            ans.add(i);
        }
        return ans;
    }

    public static RoaringBitmap flip(RoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return bm.clone();
        }
        RoaringBitmap answer = new RoaringBitmap();
        short hbStart = Util.highbits(rangeStart);
        short lbStart = Util.lowbits(rangeStart);
        short hbLast = Util.highbits(rangeEnd - 1);
        short lbLast = Util.lowbits(rangeEnd - 1);
        answer.highLowContainer.appendCopiesUntil(bm.highLowContainer, hbStart);
        int max = Util.toIntUnsigned(Util.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? Util.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? Util.toIntUnsigned(lbLast) : max;
            int i = bm.highLowContainer.getIndex(hb);
            int j = answer.highLowContainer.getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                Container c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, Container.rangeOfOnes(containerStart, containerLast));
        }
        answer.highLowContainer.appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap xor(RoaringBitmap x1, RoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = x1.highLowContainer.getContainerAtIndex(pos1).xor(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public void add(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).add(Util.lowbits(x)));
        } else {
            ArrayContainer newac = new ArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(Util.lowbits(x)));
        }
    }

    public void and(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    this.highLowContainer.removeAtIndex(pos1);
                    if (pos1 == --length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = this.highLowContainer.getContainerAtIndex(pos1).iand(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        this.highLowContainer.resize(pos1);
    }

    public void andNot(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = this.highLowContainer.getContainerAtIndex(pos1).iandNot(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
    }

    public void clear() {
        this.highLowContainer = new RoaringArray();
    }

    public RoaringBitmap clone() {
        try {
            RoaringBitmap x = (RoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    public boolean contains(int x) {
        short hb = Util.highbits(x);
        Container c = this.highLowContainer.getContainer(hb);
        return c != null && c.contains(Util.lowbits(x));
    }

    public void deserialize(DataInput in) throws IOException {
        this.highLowContainer.deserialize(in);
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringBitmap) {
            RoaringBitmap srb = (RoaringBitmap)o;
            return srb.highLowContainer.equals(this.highLowContainer);
        }
        return false;
    }

    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return;
        }
        short hbStart = Util.highbits(rangeStart);
        short lbStart = Util.lowbits(rangeStart);
        short hbLast = Util.highbits(rangeEnd - 1);
        short lbLast = Util.lowbits(rangeEnd - 1);
        int max = Util.toIntUnsigned(Util.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? Util.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? Util.toIntUnsigned(lbLast) : max;
            int i = this.highLowContainer.getIndex(hb);
            if (i >= 0) {
                Container c = this.highLowContainer.getContainerAtIndex(i).inot(containerStart, containerLast);
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(i, c);
                    continue;
                }
                this.highLowContainer.removeAtIndex(i);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, Container.rangeOfOnes(containerStart, containerLast));
        }
    }

    public int getCardinality() {
        int size = 0;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += this.highLowContainer.getContainerAtIndex(i).getCardinality();
        }
        return size;
    }

    public IntIterator getIntIterator() {
        return new IntIterator(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highLowContainer.size();
            }

            public IntIterator init() {
                if (this.pos < RoaringBitmap.this.highLowContainer.size()) {
                    this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public int next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }
        }.init();
    }

    public int getSizeInBytes() {
        int size = 8;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            Container c = this.highLowContainer.getContainerAtIndex(i);
            size += 2 + c.getSizeInBytes();
        }
        return size;
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < RoaringBitmap.this.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < RoaringBitmap.this.highLowContainer.size()) {
                    this.iter = RoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(RoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    RoaringBitmap.this.remove(this.x);
                }
            }
        }.init();
    }

    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    public void or(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).ior(x2.highLowContainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.highLowContainer.readExternal(in);
    }

    public void remove(int x) {
        short hb = Util.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return;
        }
        this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).remove(Util.lowbits(x)));
        if (this.highLowContainer.getContainerAtIndex(i).getCardinality() == 0) {
            this.highLowContainer.removeAtIndex(i);
        }
    }

    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = Util.toIntUnsigned(this.highLowContainer.getKeyAtIndex(pos)) << 16;
            Container c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void trim() {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).trim();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.highLowContainer.writeExternal(out);
    }

    public void xor(RoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container c = this.highLowContainer.getContainerAtIndex(pos1).ixor(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }
}

