/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRoaringArray;

public final class MappeableRoaringBitmap
extends ImmutableRoaringBitmap
implements Cloneable,
Serializable,
Iterable<Integer>,
Externalizable {
    private static final long serialVersionUID = 3L;

    public static MappeableRoaringBitmap and(MappeableRoaringBitmap x1, MappeableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).and(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        return answer;
    }

    public static MappeableRoaringBitmap andNot(MappeableRoaringBitmap x1, MappeableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).andNot(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static MappeableRoaringBitmap bitmapOf(int ... dat) {
        MappeableRoaringBitmap ans = new MappeableRoaringBitmap();
        for (int i : dat) {
            ans.add(i);
        }
        return ans;
    }

    public static MappeableRoaringBitmap flip(MappeableRoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return bm.clone();
        }
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        short hbStart = BufferUtil.highbits(rangeStart);
        short lbStart = BufferUtil.lowbits(rangeStart);
        short hbLast = BufferUtil.highbits(rangeEnd - 1);
        short lbLast = BufferUtil.lowbits(rangeEnd - 1);
        answer.highLowContainer.appendCopiesUntil(bm.highLowContainer, hbStart);
        int max = BufferUtil.toIntUnsigned(BufferUtil.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? BufferUtil.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? BufferUtil.toIntUnsigned(lbLast) : max;
            int i = bm.highLowContainer.getIndex(hb);
            int j = answer.highLowContainer.getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                MappeableContainer c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, MappeableContainer.rangeOfOnes(containerStart, containerLast));
        }
        answer.highLowContainer.appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    public static MappeableRoaringBitmap or(MappeableRoaringBitmap x1, MappeableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static MappeableRoaringBitmap xor(MappeableRoaringBitmap x1, MappeableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).xor(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public MappeableRoaringBitmap() {
        this.highLowContainer = new MappeableRoaringArray();
    }

    public void add(int x) {
        short hb = BufferUtil.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i >= 0) {
            this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).add(BufferUtil.lowbits(x)));
        } else {
            MappeableArrayContainer newac = new MappeableArrayContainer();
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, newac.add(BufferUtil.lowbits(x)));
        }
    }

    public void and(ImmutableRoaringBitmap array) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = array.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = array.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    this.highLowContainer.removeAtIndex(pos1);
                    if (pos1 == --length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = array.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos1).iand(array.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = array.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        this.highLowContainer.resize(pos1);
    }

    public void andNot(ImmutableRoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos1).iandNot(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
    }

    public void clear() {
        this.highLowContainer = new MappeableRoaringArray();
    }

    public void deserialize(DataInput in) throws IOException {
        this.highLowContainer.deserialize(in);
    }

    public void flip(int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            return;
        }
        short hbStart = BufferUtil.highbits(rangeStart);
        short lbStart = BufferUtil.lowbits(rangeStart);
        short hbLast = BufferUtil.highbits(rangeEnd - 1);
        short lbLast = BufferUtil.lowbits(rangeEnd - 1);
        int max = BufferUtil.toIntUnsigned(BufferUtil.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? BufferUtil.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? BufferUtil.toIntUnsigned(lbLast) : max;
            int i = this.highLowContainer.getIndex(hb);
            if (i >= 0) {
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(i).inot(containerStart, containerLast);
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(i, c);
                    continue;
                }
                this.highLowContainer.removeAtIndex(i);
                continue;
            }
            this.highLowContainer.insertNewKeyValueAt(-i - 1, hb, MappeableContainer.rangeOfOnes(containerStart, containerLast));
        }
    }

    private IntIterator getIntIterator() {
        return new IntIterator(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < MappeableRoaringBitmap.this.highLowContainer.size();
            }

            public IntIterator init() {
                if (this.pos < MappeableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = MappeableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = BufferUtil.toIntUnsigned(MappeableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public int next() {
                this.x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    MappeableRoaringBitmap.this.remove(this.x);
                }
            }
        }.init();
    }

    @Override
    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < MappeableRoaringBitmap.this.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < MappeableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = MappeableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = BufferUtil.toIntUnsigned(MappeableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                if ((this.x & this.hs) == this.hs) {
                    this.iter.remove();
                } else {
                    MappeableRoaringBitmap.this.remove(this.x);
                }
            }
        }.init();
    }

    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    public void or(ImmutableRoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                this.highLowContainer.setContainerAtIndex(pos1, this.highLowContainer.getContainerAtIndex(pos1).ior(x2.highLowContainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.highLowContainer.readExternal(in);
    }

    public void remove(int x) {
        short hb = BufferUtil.highbits(x);
        int i = this.highLowContainer.getIndex(hb);
        if (i < 0) {
            return;
        }
        this.highLowContainer.setContainerAtIndex(i, this.highLowContainer.getContainerAtIndex(i).remove(BufferUtil.lowbits(x)));
        if (this.highLowContainer.getContainerAtIndex(i).getCardinality() == 0) {
            this.highLowContainer.removeAtIndex(i);
        }
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    @Override
    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void trim() {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).trim();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.highLowContainer.writeExternal(out);
    }

    public void xor(ImmutableRoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = this.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = this.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = this.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    this.highLowContainer.insertNewKeyValueAt(pos1, s2, x2.highLowContainer.getContainerAtIndex(pos2));
                    ++pos1;
                    ++length1;
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos1).ixor(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    this.highLowContainer.setContainerAtIndex(pos1, c);
                    ++pos1;
                } else {
                    this.highLowContainer.removeAtIndex(pos1);
                    --length1;
                }
                if (pos1 == length1 || ++pos2 == length2) break;
                s1 = this.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            this.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        }
    }
}

