/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRoaringArray;
import org.roaringbitmap.buffer.MappeableRoaringBitmap;

public class ImmutableRoaringBitmap
implements Iterable<Integer>,
Cloneable {
    protected MappeableRoaringArray highLowContainer = null;

    public static MappeableRoaringBitmap and(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).and(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        return answer;
    }

    public static MappeableRoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).andNot(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public MappeableRoaringBitmap clone() {
        try {
            MappeableRoaringBitmap x = (MappeableRoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    public static MappeableRoaringBitmap flip(ImmutableRoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= rangeEnd) {
            throw new RuntimeException("Invalid range " + rangeStart + " -- " + rangeEnd);
        }
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        short hbStart = BufferUtil.highbits(rangeStart);
        short lbStart = BufferUtil.lowbits(rangeStart);
        short hbLast = BufferUtil.highbits(rangeEnd - 1);
        short lbLast = BufferUtil.lowbits(rangeEnd - 1);
        answer.highLowContainer.appendCopiesUntil(bm.highLowContainer, hbStart);
        int max = BufferUtil.toIntUnsigned(BufferUtil.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? BufferUtil.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? BufferUtil.toIntUnsigned(lbLast) : max;
            int i = bm.highLowContainer.getIndex(hb);
            int j = answer.highLowContainer.getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                MappeableContainer c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.highLowContainer.insertNewKeyValueAt(-j - 1, hb, MappeableContainer.rangeOfOnes(containerStart, containerLast));
        }
        answer.highLowContainer.appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    public static MappeableRoaringBitmap or(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                answer.highLowContainer.append(s1, x1.highLowContainer.getContainerAtIndex(pos1).or(x2.highLowContainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static MappeableRoaringBitmap xor(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MappeableRoaringBitmap answer = new MappeableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            short s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highLowContainer.appendCopy(x1.highLowContainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highLowContainer.appendCopy(x2.highLowContainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highLowContainer.getKeyAtIndex(pos2);
                    continue;
                }
                MappeableContainer c = x1.highLowContainer.getContainerAtIndex(pos1).xor(x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.highLowContainer.append(s1, c);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highLowContainer.getKeyAtIndex(pos1);
                s2 = x2.highLowContainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highLowContainer.appendCopy(x2.highLowContainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highLowContainer.appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    protected ImmutableRoaringBitmap() {
    }

    public ImmutableRoaringBitmap(ByteBuffer b) {
        this.highLowContainer = new MappeableRoaringArray(b);
    }

    public boolean contains(int x) {
        short hb = BufferUtil.highbits(x);
        MappeableContainer c = this.highLowContainer.getContainer(hb);
        return c != null && c.contains(BufferUtil.lowbits(x));
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringBitmap) {
            ImmutableRoaringBitmap srb = (ImmutableRoaringBitmap)o;
            return srb.highLowContainer.equals(this.highLowContainer);
        }
        return false;
    }

    public int getCardinality() {
        int size = 0;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += this.highLowContainer.getContainerAtIndex(i).getCardinality();
        }
        return size;
    }

    private IntIterator getIntIterator() {
        return new IntIterator(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highLowContainer.size();
            }

            public IntIterator init() {
                if (this.pos < ImmutableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = BufferUtil.toIntUnsigned(ImmutableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public int next() {
                this.x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify");
            }
        }.init();
    }

    public int getSizeInBytes() {
        int size = 2;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(i);
            size += 4 + c.getSizeInBytes();
        }
        return size;
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < ImmutableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = BufferUtil.toIntUnsigned(ImmutableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = BufferUtil.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify.");
            }
        }.init();
    }

    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = BufferUtil.toIntUnsigned(this.highLowContainer.getKeyAtIndex(pos)) << 16;
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.highLowContainer.writeExternal(out);
    }
}

