/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.RoaringBitmap;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static RoaringBitmap and(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0].clone();
        }
        RoaringBitmap[] array = Arrays.copyOf(bitmaps, bitmaps.length);
        Arrays.sort(array, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        RoaringBitmap answer = RoaringBitmap.and(array[0], array[1]);
        for (int k = 2; k < array.length; ++k) {
            answer.and(array[k]);
        }
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.or(x1, x2));
        }
        return pq.poll();
    }

    public static RoaringBitmap horizontal_or(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().or(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.ior(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.xor(x1, x2));
        }
        return pq.poll();
    }

    public static RoaringBitmap horizontal_xor(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }
}

