/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.LongBuffer;
import java.util.Iterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.ArrayContainer;
import org.roaringbitmap.buffer.Container;
import org.roaringbitmap.buffer.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitmapContainer
extends Container
implements Cloneable,
Serializable {
    protected static final int maxcapacity = 65536;
    private static final long serialVersionUID = 2L;
    private static boolean USEINPLACE = true;
    LongBuffer bitmap;
    int cardinality;

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = LongBuffer.allocate(1024);
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun + 1;
        this.bitmap = LongBuffer.allocate(1024);
        if (this.cardinality == 65536) {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, -1L);
            }
        } else {
            int firstWord = firstOfRun / 64;
            int lastWord = lastOfRun / 64;
            int zeroPrefixLength = firstOfRun & 0x3F;
            int zeroSuffixLength = 63 - (lastOfRun & 0x3F);
            for (int k = firstWord; k < lastWord + 1; ++k) {
                this.bitmap.put(k, -1L);
            }
            this.bitmap.put(firstWord, this.bitmap.get(firstWord) ^ (1L << zeroPrefixLength) - 1L);
            long blockOfOnes = (1L << zeroSuffixLength) - 1L;
            long maskOnLeft = blockOfOnes << 64 - zeroSuffixLength;
            this.bitmap.put(lastWord, this.bitmap.get(lastWord) ^ maskOnLeft);
        }
    }

    private BitmapContainer(int newcardinality, LongBuffer newbitmap) {
        this.cardinality = newcardinality;
        this.bitmap = LongBuffer.allocate(newbitmap.limit());
        newbitmap.rewind();
        this.bitmap.put(newbitmap);
    }

    public BitmapContainer(LongBuffer array, int cardinality) {
        if (array.limit() != 1024) {
            throw new RuntimeException("Mismatch between buffer and storage requirements: " + array.limit() + " vs. " + 1024);
        }
        this.cardinality = cardinality;
        this.bitmap = array;
    }

    @Override
    public Container add(short i) {
        int x = Util.toIntUnsigned(i);
        long previous = this.bitmap.get(x / 64);
        this.bitmap.put(x / 64, previous | 1L << x);
        this.cardinality = (int)((long)this.cardinality + ((previous ^ this.bitmap.get(x / 64)) >>> x));
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.limit());
        short[] sarray = answer.content.array();
        if (value2.content.hasArray()) {
            short[] c = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                if (!this.contains(c[k])) continue;
                sarray[answer.cardinality++] = c[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                if (!this.contains(value2.content.get(k))) continue;
                sarray[answer.cardinality++] = value2.content.get(k);
            }
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int k;
        int newcardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newcardinality += Long.bitCount(tb[k] & v2b[k]);
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newcardinality += Long.bitCount(this.bitmap.get(k2) & value2.bitmap.get(k2));
            }
        }
        if (newcardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            long[] bitarray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] tb = this.bitmap.array();
                long[] v2b = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitarray[k3] = tb[k3] & v2b[k3];
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitarray[k] = this.bitmap.get(k) & value2.bitmap.get(k);
                }
            }
            answer.cardinality = newcardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            org.roaringbitmap.Util.fillArrayAND(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            Util.fillArrayAND(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        long[] bitarray = answer.bitmap.array();
        if (value2.content.hasArray() && this.bitmap.hasArray()) {
            short[] v2 = value2.content.array();
            long[] ba = this.bitmap.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i;
                int n = i = Util.toIntUnsigned(v2[k]) >>> 6;
                bitarray[n] = bitarray[n] & (1L << v2[k] ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((bitarray[i] ^ ba[i]) >>> v2[k]));
            }
        } else {
            for (int k = 0; k < value2.cardinality; ++k) {
                int i;
                int n = i = Util.toIntUnsigned(value2.content.get(k)) >>> 6;
                bitarray[n] = bitarray[n] & (1L << value2.content.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((bitarray[i] ^ this.bitmap.get(i)) >>> value2.content.get(k)));
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int k;
        int newcardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newcardinality += Long.bitCount(b[k] & (v2[k] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newcardinality += Long.bitCount(this.bitmap.get(k2) & (value2.bitmap.get(k2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (newcardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            long[] bitarray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitarray[k3] = b[k3] & (v2[k3] ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitarray[k] = this.bitmap.get(k) & (value2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            answer.cardinality = newcardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            org.roaringbitmap.Util.fillArrayANDNOT(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            Util.fillArrayANDNOT(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, 0L);
            }
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean contains(short i) {
        int x = Util.toIntUnsigned(i);
        return (this.bitmap.get(x / 64) & 1L << x) != 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (this.bitmap.hasArray() && srb.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] s = srb.bitmap.array();
                for (int k = 0; k < this.bitmap.limit(); ++k) {
                    if (b[k] == s[k]) continue;
                    return false;
                }
            } else {
                for (int k = 0; k < this.bitmap.limit(); ++k) {
                    if (this.bitmap.get(k) == srb.bitmap.get(k)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        } else {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
                }
            }
        } else {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
                }
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int i;
            int j;
            {
                this.i = BitmapContainer.this.nextSetBit(0);
            }

            public boolean hasNext() {
                return this.i >= 0;
            }

            public short next() {
                this.j = this.i;
                this.i = BitmapContainer.this.nextSetBit(this.i + 1);
                return (short)this.j;
            }

            public void remove() {
                BitmapContainer.this.remove((short)this.j);
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.limit() * 8;
    }

    public int hashCode() {
        long hash = 0L;
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            hash += 31L * this.bitmap.get(k);
        }
        return (int)(hash >> 32);
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        int k;
        int newcardinality = 0;
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newcardinality += Long.bitCount(this.bitmap.get(k) & b2.bitmap.get(k));
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, this.bitmap.get(k) & b2.bitmap.get(k));
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content.get(k));
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newcardinality = 0;
        long[] b = this.bitmap.array();
        if (b2.bitmap.hasArray()) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newcardinality += Long.bitCount(b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (newcardinality > 4096) {
                for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                    this.bitmap.put(k2, b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
                }
                this.cardinality = newcardinality;
                return this;
            }
            ArrayContainer ac = new ArrayContainer(newcardinality);
            org.roaringbitmap.Util.fillArrayANDNOT(ac.content.array(), b, b2Arr);
            ac.cardinality = newcardinality;
            return ac;
        }
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newcardinality += Long.bitCount(b[k] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayANDNOT(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        return this.not(this, firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        long[] b = this.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = Util.toIntUnsigned(v2[k]) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (((b[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> v2[k]));
                int n = i;
                b[n] = b[n] | 1L << v2[k];
            }
            return this;
        }
        for (int k = 0; k < value2.cardinality; ++k) {
            int i = Util.toIntUnsigned(value2.content.get(k)) >>> 6;
            this.cardinality = (int)((long)this.cardinality + (((b[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> value2.content.get(k)));
            int n = i;
            b[n] = b[n] | 1L << value2.content.get(k);
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        long[] b = this.bitmap.array();
        this.cardinality = 0;
        if (b2.bitmap.hasArray()) {
            long[] b2Arr = b2.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] | b2Arr[k];
                this.cardinality += Long.bitCount(b[k]);
            }
            return this;
        }
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            int n = k;
            b[n] = b[n] | b2.bitmap.get(k);
            this.cardinality += Long.bitCount(b[k]);
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            int i;
            int j;
            {
                this.i = BitmapContainer.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Short next() {
                this.j = this.i;
                this.i = BitmapContainer.this.nextSetBit(this.i + 1);
                return (short)this.j;
            }

            @Override
            public void remove() {
                BitmapContainer.this.remove((short)this.j);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        long[] b = this.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = Util.toIntUnsigned(v2[k]) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((b[index] & 1L << v2[k]) >>> v2[k])));
                int n = index;
                b[n] = b[n] ^ 1L << v2[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = Util.toIntUnsigned(value2.content.get(k)) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((b[index] & 1L << value2.content.get(k)) >>> value2.content.get(k))));
                int n = index;
                b[n] = b[n] ^ 1L << value2.content.get(k);
            }
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer B2) {
        int k;
        long[] b = this.bitmap.array();
        if (B2.bitmap.hasArray()) {
            int k2;
            long[] b2 = B2.bitmap.array();
            int newcardinality = 0;
            for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newcardinality += Long.bitCount(b[k2] ^ b2[k2]);
            }
            if (newcardinality > 4096) {
                for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                    int n = k2;
                    b[n] = b[n] ^ b2[k2];
                }
                this.cardinality = newcardinality;
                return this;
            }
            ArrayContainer ac = new ArrayContainer(newcardinality);
            org.roaringbitmap.Util.fillArrayXOR(ac.content.array(), b, b2);
            ac.cardinality = newcardinality;
            return ac;
        }
        int newcardinality = 0;
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newcardinality += Long.bitCount(b[k] ^ B2.bitmap.get(k));
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] ^ B2.bitmap.get(k);
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayXOR(ac.content.array(), this.bitmap, B2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        long[] bitarray = this.bitmap.array();
        if (this.bitmap.hasArray() && arrayContainer.content.hasArray()) {
            long[] b = this.bitmap.array();
            short[] ac = arrayContainer.content.array();
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = ac[k];
                bitarray[Util.toIntUnsigned((short)x) / 64] = b[Util.toIntUnsigned(x) / 64] | 1L << x;
            }
        } else {
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = arrayContainer.content.get(k);
                bitarray[Util.toIntUnsigned((short)x) / 64] = this.bitmap.get(Util.toIntUnsigned(x) / 64) | 1L << x;
            }
        }
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.bitmap.limit()) {
            return -1;
        }
        long w = this.bitmap.get(x);
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.limit()) {
            if (this.bitmap.get(x) != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap.get(x));
            }
            ++x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < this.bitmap.limit()) {
            if (this.bitmap.get(x) != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    private Container not(BitmapContainer answer, int firstOfRange, int lastOfRange) {
        assert (this.bitmap.limit() == 1024);
        if (lastOfRange - firstOfRange + 1 == 65536) {
            int newCardinality = 65536 - this.cardinality;
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                answer.bitmap.put(k, this.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            if (newCardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        int cardinalityChange = 0;
        int rangeFirstWord = firstOfRange / 64;
        int rangeFirstBitPos = firstOfRange & 0x3F;
        int rangeLastWord = lastOfRange / 64;
        long rangeLastBitPos = lastOfRange & 0x3F;
        if (answer != this) {
            int i;
            for (i = 0; i < rangeFirstWord; ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
            for (i = rangeLastWord + 1; i < this.bitmap.limit(); ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
        }
        long maskOnLeft = rangeLastBitPos == 63L ? -1L : (1L << (int)(rangeLastBitPos + 1L)) - 1L;
        long mask = -1L;
        mask ^= (1L << rangeFirstBitPos) - 1L;
        if (rangeFirstWord == rangeLastWord) {
            cardinalityChange = -Long.bitCount(this.bitmap.get(rangeFirstWord));
            answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ (mask &= maskOnLeft));
            answer.cardinality = this.cardinality + (cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord)));
            if (answer.cardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeFirstWord));
        answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ mask);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord));
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeLastWord));
        answer.bitmap.put(rangeLastWord, this.bitmap.get(rangeLastWord) ^ maskOnLeft);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeLastWord));
        for (int i = rangeFirstWord + 1; i < rangeLastWord; ++i) {
            cardinalityChange += 64 - 2 * Long.bitCount(this.bitmap.get(i));
            answer.bitmap.put(i, this.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        answer.cardinality = this.cardinality + cardinalityChange;
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        return this.not(new BitmapContainer(), firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        long[] bitarray = answer.bitmap.array();
        if (answer.bitmap.hasArray() && value2.content.hasArray()) {
            long[] ab = answer.bitmap.array();
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = Util.toIntUnsigned(v2[k]) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (((ab[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << v2[k]) >>> v2[k]));
                int n = i;
                bitarray[n] = bitarray[n] | 1L << value2.content.get(k);
            }
        } else {
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = Util.toIntUnsigned(value2.content.get(k)) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (((answer.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> value2.content.get(k)));
                int n = i;
                bitarray[n] = bitarray[n] | 1L << value2.content.get(k);
            }
        }
        return answer;
    }

    @Override
    public Container or(BitmapContainer value2) {
        if (USEINPLACE) {
            BitmapContainer value1 = this.clone();
            return value1.ior(value2);
        }
        BitmapContainer answer = new BitmapContainer();
        long[] bitarray = answer.bitmap.array();
        answer.cardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (int k = 0; k < answer.bitmap.limit(); ++k) {
                bitarray[k] = b[k] | v2[k];
                answer.cardinality += Long.bitCount(bitarray[k]);
            }
        } else {
            for (int k = 0; k < answer.bitmap.limit(); ++k) {
                bitarray[k] = this.bitmap.get(k) | value2.bitmap.get(k);
                answer.cardinality += Long.bitCount(bitarray[k]);
            }
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[8];
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            in.readFully(buffer);
            this.bitmap.put(k, ((long)buffer[7] << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + (long)((buffer[2] & 0xFF) << 16) + (long)((buffer[1] & 0xFF) << 8) + (long)(buffer[0] & 0xFF));
            this.cardinality += Long.bitCount(this.bitmap.get(k));
        }
    }

    @Override
    public Container remove(short i) {
        int x = Util.toIntUnsigned(i);
        if (this.cardinality == 4096 && (this.bitmap.get(x / 64) & 1L << x) != 0L) {
            --this.cardinality;
            this.bitmap.put(x / 64, this.bitmap.get(x / 64) & (1L << x ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality - ((this.bitmap.get(x / 64) & 1L << x) >>> x));
        this.bitmap.put(x / 64, this.bitmap.get(x / 64) & (1L << x ^ 0xFFFFFFFFFFFFFFFFL));
        return this;
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        return ac;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = this.nextSetBit(0);
        while (i >= 0) {
            sb.append(i);
            if ((i = this.nextSetBit(i + 1)) < 0) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        byte[] buffer = new byte[8];
        for (int k = 0; k < 1024; ++k) {
            long w = this.bitmap.get(k);
            buffer[0] = (byte)w;
            buffer[1] = (byte)(w >>> 8);
            buffer[2] = (byte)(w >>> 16);
            buffer[3] = (byte)(w >>> 24);
            buffer[4] = (byte)(w >>> 32);
            buffer[5] = (byte)(w >>> 40);
            buffer[6] = (byte)(w >>> 48);
            buffer[7] = (byte)(w >>> 56);
            out.write(buffer, 0, 8);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        long[] bitarray = answer.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = Util.toIntUnsigned(v2[k]) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((bitarray[index] & 1L << v2[k]) >>> v2[k])));
                int n = index;
                bitarray[n] = bitarray[n] ^ 1L << v2[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = Util.toIntUnsigned(value2.content.get(k)) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((bitarray[index] & 1L << value2.content.get(k)) >>> value2.content.get(k))));
                int n = index;
                bitarray[n] = bitarray[n] ^ 1L << value2.content.get(k);
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int k;
        int newCardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newCardinality += Long.bitCount(b[k] ^ v2[k]);
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) ^ value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            long[] bitarray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitarray[k3] = b[k3] ^ v2[k3];
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitarray[k] = this.bitmap.get(k) ^ value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            org.roaringbitmap.Util.fillArrayXOR(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            Util.fillArrayXOR(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }
}

