/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.richfaces.component.util.HtmlUtil;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
import org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper;
//
//
//


import org.richfaces.renderkit.InputNumberSliderRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.InputNumberSliderRenderer
 */
public class InputNumberSliderRenderer extends InputNumberSliderRendererBase {

	public InputNumberSliderRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/slider.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("script/SliderScript.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/events.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIInputNumberSlider.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIInputNumberSlider component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
prepareVariables(context, component);

variables.setVariable("spacer", getResource( "/org/richfaces/renderkit/html/images/spacer.gif" ).getUri(context, component) );

variables.setVariable("arrow", getResource( "org.richfaces.renderkit.html.images.SliderArrowImage" ).getUri(context, component) );


		
            String width = (String) component.getAttributes().get("width");
            if (width == null || width.length() == 0) {
                if ("vertical".equalsIgnoreCase((String)variables.getVariable("orientation"))) {
                    width = "20px";                    
                } else {
                    width = "200px";
                }
            } else {
                width = HtmlUtil.qualifySize(width);
            }
            variables.setVariable("width", width);
            String height = (String) component.getAttributes().get("height");
            if (height == null || height.length() == 0) {
                if ("vertical".equalsIgnoreCase((String)variables.getVariable("orientation"))) {
                    height = "200px";
                } else {
                    height = "20px";
                }
            } else {
                height = HtmlUtil.qualifySize(height);
            }
            variables.setVariable("height", height);
        
	

        
    if ("vertical".equalsIgnoreCase((String)variables.getVariable("orientation"))) {
        
        
    
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inslider-vertical rich-slider " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "height: " + convertToString(variables.getVariable("height")) + ";" + convertToString(variables.getVariable("style")) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "bgcolor" ,
	    "cellpadding" ,
	    "cellspacing" ,
	    "dir" ,
	    "frame" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "rules" ,
	    "summary" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("tbody", component);

writer.startElement("tr", component);


                    if ("right".equalsIgnoreCase((String)variables.getVariable("inputPosition"))) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "text-align: left; vertical-align: bottom" );
			

                    if (((Boolean)variables.getVariable("showInput")).booleanValue()) {
                    
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "rich-inslider-field-top rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                            } else {
                                
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                    } 
                    
writer.endElement("td");

                }
            
writer.endElement("tr");

	             if (((Boolean)variables.getVariable("showArrows")).booleanValue()) {
	        
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-td-arrow" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "TipArrowInc" );
						getUtils().writeAttribute(writer, "style", "display: none; " + convertToString(component.getAttributes().get("tipStyle")) );
			

	                           writer.write("&#160;");
	                         
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-inc-vertical rich-inslider-arrow " + convertToString(component.getAttributes().get("increaseClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "ArrowInc" );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("increaseStyle") );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");

	             } 
	        
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "height: 100%;" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "height: 100%;" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-size-height" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Track" );
						getUtils().writeAttribute(writer, "rowspan", "2" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-track-vertical rich-inslider-track " + convertToString(component.getAttributes().get("barClass")) );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("barStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inslider-track-decor-1 rich-inslider-track-border" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "style", "height: 98%" );
			
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-track-decor-2" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "display: block;" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Tip" );
						getUtils().writeAttribute(writer, "style", "display: none;left: 9px; " + convertToString(component.getAttributes().get("tipStyle")) );
			

                                             writer.write("&#160;");
                                           
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-handler-vertical " + convertToString(component.getAttributes().get("handleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Handle" );
						getUtils().writeAttribute(writer, "style", "visibility:visible; top: -7px; left:1px;" );
			

                                             writer.write("&#160;");
                                           
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");

                                        if (attributeToBoolean(component, "showBoundaryValues")){
                                    
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-top-num " + convertToString(component.getAttributes().get("boundClass")) );
			
writer.writeText(convertToString(component.getAttributes().get("maxValue")),null);

writer.endElement("td");

		                                } else{
		                            
writer.startElement("td", component);

writer.endElement("td");

                                        }
                                    
writer.endElement("tr");
writer.startElement("tr", component);


                                    if (attributeToBoolean(component, "showBoundaryValues")){
                                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-bottom-num " + convertToString(component.getAttributes().get("boundClass")) );
			
writer.writeText(convertToString(component.getAttributes().get("minValue")),null);

writer.endElement("td");

		                                } else {
		                            
writer.startElement("td", component);

writer.endElement("td");

                                        } 
                                    
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("td");
writer.endElement("tr");

		             if (((Boolean)variables.getVariable("showArrows")).booleanValue()) {
		        
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-td-arrow" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "TipArrowDec" );
						getUtils().writeAttribute(writer, "style", "display: none; " + convertToString(component.getAttributes().get("tipStyle")) );
			

                               writer.write("&#160;");
                             
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-dec-vertical rich-inslider-arrow " + convertToString(component.getAttributes().get("decreaseClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "ArrowDec" );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("decreaseStyle") );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");

		             } 
		        
writer.startElement("tr", component);


                    if ("left".equalsIgnoreCase((String)variables.getVariable("inputPosition"))) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "style", "text-align: left; vertical-align: bottom" );
			

                    if (((Boolean)variables.getVariable("showInput")).booleanValue()) {
                    
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "rich-inslider-field-bottom rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                            } else {
                                
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                    }
                    
writer.endElement("td");

                    }
                
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);

java.util.HashMap options = new java.util.HashMap();
	getUtils().addToScriptHash(options, "handleSelectedClass", component.getAttributes().get("handleSelectedClass"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "disabled", component.getAttributes().get("disabled"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "required", component.getAttributes().get("required"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "onerror", component.getAttributes().get("onerror"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "onchange", component.getAttributes().get("onchange"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "clientErrorMessage", component.getAttributes().get("clientErrorMessage"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "showArrows", component.getAttributes().get("showArrows"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "showToolTip", component.getAttributes().get("showToolTip"),  "true" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "step", component.getAttributes().get("step"),  "1" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "minValue", component.getAttributes().get("minValue"),  "0" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "maxValue", component.getAttributes().get("maxValue"),  "100" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "delay", component.getAttributes().get("delay"),  "200" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "onslide", component.getAttributes().get("onslide"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);

	getUtils().addToScriptHash(options, "sliderValue", getInputValue(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "width", variables.getVariable("width"),  "200px" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "height", variables.getVariable("height"),  "20px" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "orientation", "vertical",  null , ScriptHashVariableWrapper.DEFAULT);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.Slider(\"" + convertToString(clientId) + "\""),null);

if ( Boolean.valueOf( String.valueOf( ( !  getUtils().isEmpty( options )  ) ) ).booleanValue() ) {


writer.writeText(convertToString(","),null);

org.ajax4jsf.javascript.ScriptUtils.writeToStream(writer, options);

}
writer.writeText(convertToString(")"),null);

writer.endElement("script");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

          
    } else { 
        
    
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inslider rich-slider " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "width: " + convertToString(variables.getVariable("width")) + ";" + convertToString(variables.getVariable("style")) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "bgcolor" ,
	    "cellpadding" ,
	    "cellspacing" ,
	    "dir" ,
	    "frame" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "rules" ,
	    "summary" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("tbody", component);

writer.startElement("tr", component);


                    if ("left".equalsIgnoreCase((String)variables.getVariable("inputPosition"))) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "rowspan", "2" );
						getUtils().writeAttribute(writer, "style", "text-align: right; vertical-align: bottom" );
			

                    if (((Boolean)variables.getVariable("showInput")).booleanValue()) {
                    
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "rich-inslider-field-left rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                            } else {
                                
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                    }
                    
writer.endElement("td");

                    }
                

	                 if (((Boolean)variables.getVariable("showArrows")).booleanValue()) {
	            
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-td-arrow" );
						getUtils().writeAttribute(writer, "rowspan", "2" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "TipArrowDec" );
						getUtils().writeAttribute(writer, "style", "display: none; " + convertToString(component.getAttributes().get("tipStyle")) );
			

	                           writer.write("&#160;");
	                         
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-dec-horizontal rich-inslider-arrow " + convertToString(component.getAttributes().get("decreaseClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "ArrowDec" );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("decreaseStyle") );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");

	                 }
	            
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-left-num " + convertToString(component.getAttributes().get("boundClass")) );
			

				    if (attributeToBoolean(component, "showBoundaryValues")){
                
writer.writeText(convertToString(component.getAttributes().get("minValue")),null);


				    }
                
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-right-num " + convertToString(component.getAttributes().get("boundClass")) );
			

				    if (attributeToBoolean(component, "showBoundaryValues")){
                
writer.writeText(convertToString(component.getAttributes().get("maxValue")),null);


				    }
                
writer.endElement("td");

	                 if (((Boolean)variables.getVariable("showArrows")).booleanValue()) {
	           	
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-td-arrow" );
						getUtils().writeAttribute(writer, "rowspan", "2" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "TipArrowInc" );
						getUtils().writeAttribute(writer, "style", "display: none; " + convertToString(component.getAttributes().get("tipStyle")) );
			

	                           writer.write("&#160;");
	                         
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-inc-horizontal rich-inslider-arrow " + convertToString(component.getAttributes().get("increaseClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "ArrowInc" );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("increaseStyle") );
			
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");

	                 } 
	            

                    if ("right".equalsIgnoreCase((String)variables.getVariable("inputPosition"))) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "rowspan", "2" );
						getUtils().writeAttribute(writer, "style", "text-align: left; vertical-align: bottom" );
			

					if (((Boolean)variables.getVariable("showInput")).booleanValue()) {
					
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "rich-inslider-field-right rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

							} else {
								
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

					}
					
writer.endElement("td");

                    }
                
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-size rich-inslider-vert-spacer" );
						getUtils().writeAttribute(writer, "colspan", "2" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inslider-size" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Track" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Tip" );
						getUtils().writeAttribute(writer, "style", "display: none;" + convertToString(component.getAttributes().get("tipStyle")) );
			

                                              writer.write("&#160;");
                                            
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-handler " + convertToString(component.getAttributes().get("handleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Handle" );
						getUtils().writeAttribute(writer, "style", "visibility:hidden;" );
			

                                              writer.write("&#160;");
                                            
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-track " + convertToString(component.getAttributes().get("barClass")) );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("barStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-inslider-track-decor-1" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-inslider-track-decor-2" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "alt", "" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "display: block;" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
java.util.HashMap options = new java.util.HashMap();
	getUtils().addToScriptHash(options, "handleSelectedClass", component.getAttributes().get("handleSelectedClass"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "disabled", component.getAttributes().get("disabled"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "required", component.getAttributes().get("required"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "onerror", component.getAttributes().get("onerror"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "onchange", component.getAttributes().get("onchange"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "clientErrorMessage", component.getAttributes().get("clientErrorMessage"),  null , ScriptHashVariableWrapper.DEFAULT);
	getUtils().addToScriptHash(options, "showArrows", component.getAttributes().get("showArrows"),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "showToolTip", component.getAttributes().get("showToolTip"),  "true" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "step", component.getAttributes().get("step"),  "1" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "minValue", component.getAttributes().get("minValue"),  "0" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "maxValue", component.getAttributes().get("maxValue"),  "100" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "delay", component.getAttributes().get("delay"),  "200" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "onslide", component.getAttributes().get("onslide"),  null , ScriptHashVariableWrapper.EVENT_HANDLER);

	getUtils().addToScriptHash(options, "sliderValue", getInputValue(context,component),  null , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "width", variables.getVariable("width"),  "200px" , ScriptHashVariableWrapper.DEFAULT);

	getUtils().addToScriptHash(options, "height", variables.getVariable("height"),  "20px" , ScriptHashVariableWrapper.DEFAULT);

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.Slider(\"" + convertToString(clientId) + "\""),null);

if ( Boolean.valueOf( String.valueOf( ( !  getUtils().isEmpty( options )  ) ) ).booleanValue() ) {


writer.writeText(convertToString(","),null);

org.ajax4jsf.javascript.ScriptUtils.writeToStream(writer, options);

}
writer.writeText(convertToString(")"),null);

writer.endElement("script");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

        
    }
    
    

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIInputNumberSlider)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
