package org.richfaces.model.internal;

import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyResolver;

/**
 * Expression evaluated by applying application
 * property resolver to the base object
 * @author Maksim Kaszynski
 *
 */
final class SimplePropertyExpression extends Expression {
	/**
	 * 
	 */
	private final PropertyResolver resolver;

	/**
	 * @param n
	 * @param resolver
	 */
	SimplePropertyExpression(String n, PropertyResolver resolver) {
		super(n);
		this.resolver = resolver;
	}

	public Object evaluate(Object base) {
		Object o = null;
		try {
			return resolver.getValue(base, getExpressionString());
		} catch (EvaluationException e) {
			
		} 
		
		return o;
	}
}