/**
 *
 */

package org.richfaces.component;

import org.richfaces.model.StackingTreeModel;
import org.richfaces.model.StackingTreeModelDataProvider;
import org.richfaces.model.StackingTreeModelProvider;
import org.richfaces.model.VisualStackingTreeModel;


/**
 * JSF component class
 *
 */
public abstract class UITreeNodesAdaptor extends StackingTreeModelProvider {
	
	public static final String COMPONENT_TYPE = "org.richfaces.TreeNodesAdaptor";
	
	public static final String COMPONENT_FAMILY = "org.richfaces.TreeNodesAdaptor";
	
	public abstract String getVar();
	public abstract void setVar(String var);
	
	public abstract boolean isIncludedNode();
	public abstract void setIncludedNode(boolean includeNode);
	
	protected boolean includeNode() {
		return isIncludedNode();
	}
	
	protected StackingTreeModel createStackingTreeModel() {
		StackingTreeModel treeModel = new VisualStackingTreeModel(getId(), getVar(), new StackingTreeModelDataProvider() {

			public Object getData() {
				return UITreeNodesAdaptor.this.getData();
			}
			
		}, UITreeNodesAdaptor.this) {
			protected boolean isActive() {
				return UITreeNodesAdaptor.this.isRendered();
			}
			
			protected boolean isActiveData() {
				return UITreeNodesAdaptor.this.includeNode();
			}
		};
		
		return treeModel;
	}
}
