/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.Messages;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.util.RendererUtils;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class RendererBase
extends Renderer {
    private static final Logger LOG = RichfacesLogger.RENDERKIT.getLogger();
    private static final RendererUtils UTILS = RendererUtils.getInstance();
    private SkinFactory skinFactory = null;

    public void decode(FacesContext context, UIComponent component) {
        this.checkNull(context, component, "decode");
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)"", (Object)this.getComponentClass().getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)Messages.getMessage((String)"START_DECODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        this.preDecode(context, component);
        if (component.isRendered()) {
            String behaviorEventName = RenderKitUtils.decodeBehaviors(context, component);
            if (behaviorEventName != null) {
                this.queueComponentEventForBehaviorEvent(context, component, behaviorEventName);
            }
            this.doDecode(context, component);
        }
    }

    protected void queueComponentEventForBehaviorEvent(FacesContext context, UIComponent component, String eventName) {
    }

    protected void preDecode(FacesContext context, UIComponent component) {
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.checkForCorrectParams(context, component, "encodeBegin");
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)Messages.getMessage((String)"START_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeBegin(writer, context, component);
        }
    }

    private void checkForCorrectParams(FacesContext context, UIComponent component, String exceptionMessageParam) {
        this.checkNull(context, component, exceptionMessageParam);
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"COMPONENT_CLASS_ERROR", (Object)component.getClientId(context), (Object)this.getComponentClass().getName()));
        }
    }

    private void checkNull(Object context, Object component, String exceptionMessageParam) {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage((String)"CONTEXT_NULL_ERROR", (Object)exceptionMessageParam));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR", (Object)exceptionMessageParam));
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.checkForCorrectParams(context, component, "encodeBegin");
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)Messages.getMessage((String)"CHILDREN_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeChildren(writer, context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.checkForCorrectParams(context, component, "encodeEnd");
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeEnd(writer, context, component);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)Messages.getMessage((String)"FINISH_ENCODING_COMPONENT_INFO", (Object)component.getClientId(context), (Object)component.getClass().getName()));
        }
    }

    protected Skin getSkin(FacesContext context) {
        if (this.skinFactory == null) {
            this.skinFactory = SkinFactory.getInstance();
        }
        return this.skinFactory.getSkin(context);
    }

    public RendererUtils getUtils() {
        return UTILS;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIComponent.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                child.encodeAll(facesContext);
            }
        }
    }

    public String concatClasses(Object ... objects) {
        return HtmlUtil.concatClasses(objects);
    }

    public String concatStyles(Object ... objects) {
        return HtmlUtil.concatStyles(objects);
    }

    public String getResourcePath(FacesContext context, String library, String resourceName) {
        return RenderKitUtils.getResourcePath(context, library, resourceName);
    }
}

