/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.pickList;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.pickList.AbstractPickList;
import org.richfaces.bootstrap.ui.pickList.PickListRendererBase;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.ForEachLoop;
import org.richfaces.renderkit.RenderKitUtils;

public class PickListRenderer
extends PickListRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH2 = RenderKitUtils.attributes().generic("onchange", "onchange", new String[]{"change"});

    private static boolean convertToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf(object.toString());
    }

    public void renderColumnHeaders(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns) throws IOException {
        AbstractPickList component = (AbstractPickList)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("thead", (UIComponent)component);
        responseWriter.startElement("tr", (UIComponent)component);
        while (columns.hasNext()) {
            UIComponent header;
            Object columnObject = columns.next();
            UIColumn column = (UIColumn)columnObject;
            responseWriter.startElement("th", (UIComponent)component);
            if (PickListRenderer.convertToBoolean(RenderKitUtils.hasFacet((UIComponent)column, (String)"header")) && (header = column.getHeader()).isRendered()) {
                header.encodeBegin(facesContext);
                this.renderChildren(facesContext, header);
                header.encodeEnd(facesContext);
            }
            responseWriter.endElement("th");
        }
        responseWriter.endElement("tr");
        responseWriter.endElement("thead");
    }

    public void renderColumns(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns, Iterator clientSelectItems) throws IOException {
        AbstractPickList component = (AbstractPickList)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("tbody", (UIComponent)component);
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object oldVar = requestMap.get(component.getVar());
        String[] columnClasses = component.getColumnClasses() != null ? component.getColumnClasses().split(",") : null;
        while (clientSelectItems.hasNext()) {
            Object itemObject = clientSelectItems.next();
            ClientSelectItem item = (ClientSelectItem)itemObject;
            columns = component.columns();
            requestMap.put(component.getVar(), item.getSelectItem().getValue());
            responseWriter.startElement("tr", (UIComponent)component);
            String value = item.getConvertedValue();
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("data-key", (Object)value, null);
            }
            ForEachLoop forEach3 = ForEachLoop.getInstance((Iterator)columns);
            for (Object columnObject : forEach3) {
                ForEachLoop.Status varStatus = forEach3.getStatus();
                UIColumn column = (UIColumn)columnObject;
                responseWriter.startElement("td", (UIComponent)component);
                String value2 = this.getColumnClass(column, columnClasses, varStatus.getIndex());
                if (null != value2 && RenderKitUtils.shouldRenderAttribute((Object)value2)) {
                    responseWriter.writeAttribute("class", (Object)value2, null);
                }
                column.encodeBegin(facesContext);
                this.renderChildren(facesContext, (UIComponent)column);
                column.encodeEnd(facesContext);
                responseWriter.endElement("td");
            }
            responseWriter.endElement("tr");
        }
        requestMap.put(component.getVar(), oldVar);
        oldVar = null;
        responseWriter.endElement("tbody");
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        AbstractPickList component = (AbstractPickList)uiComponent;
        String clientId = component.getClientId(facesContext);
        List clientSelectItems = this.getClientSelectItems(facesContext, (UIComponent)component);
        Iterator<ClientSelectItem> sourceSelectItems = this.getSourceSelectItems(clientSelectItems);
        Iterator<ClientSelectItem> targetSelectItems = this.getTargetSelectItems(clientSelectItems);
        responseWriter.startElement("div", (UIComponent)component);
        String value = component.getStyleClass();
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (!this.hasColumnChildren(facesContext, (UIComponent)component)) {
            String value2;
            ClientSelectItem item;
            ClientSelectItem itemObject;
            responseWriter.startElement("ol", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"source", null);
            value = PickListRenderer.convertToString(clientId) + "SourceList";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value, null);
            }
            while (sourceSelectItems.hasNext()) {
                item = itemObject = sourceSelectItems.next();
                responseWriter.startElement("li", (UIComponent)component);
                value2 = item.getConvertedValue();
                if (null != value2 && value2.length() > 0) {
                    responseWriter.writeAttribute("data-key", (Object)value2, null);
                }
                if ((text = item.getLabel()) != null) {
                    responseWriter.writeText((Object)text, null);
                }
                responseWriter.endElement("li");
            }
            responseWriter.endElement("ol");
            responseWriter.startElement("ol", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"target", null);
            value = PickListRenderer.convertToString(clientId) + "TargetList";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value, null);
            }
            while (targetSelectItems.hasNext()) {
                item = itemObject = targetSelectItems.next();
                responseWriter.startElement("li", (UIComponent)component);
                value2 = item.getConvertedValue();
                if (null != value2 && value2.length() > 0) {
                    responseWriter.writeAttribute("data-key", (Object)value2, null);
                }
                if ((text = item.getLabel()) != null) {
                    responseWriter.writeText((Object)text, null);
                }
                responseWriter.endElement("li");
            }
            responseWriter.endElement("ol");
        } else {
            Iterator columns = component.columns();
            responseWriter.startElement("table", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"source", null);
            String value3 = PickListRenderer.convertToString(clientId) + "List";
            if (null != value3 && value3.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value3, null);
            }
            if (columns != null && columns.hasNext()) {
                if (this.isHeaderExists(facesContext, (UIComponent)component)) {
                    this.renderColumnHeaders(responseWriter, facesContext, (UIComponent)component, columns);
                }
                this.renderColumns(responseWriter, facesContext, (UIComponent)component, columns, sourceSelectItems);
            }
            responseWriter.endElement("table");
            responseWriter.startElement("table", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"target", null);
            value3 = PickListRenderer.convertToString(clientId) + "List";
            if (null != value3 && value3.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value3, null);
            }
            if (columns != null && columns.hasNext()) {
                if (this.isHeaderExists(facesContext, (UIComponent)component)) {
                    this.renderColumnHeaders(responseWriter, facesContext, (UIComponent)component, columns);
                }
                this.renderColumns(responseWriter, facesContext, (UIComponent)component, columns, targetSelectItems);
            }
            responseWriter.endElement("table");
        }
        responseWriter.endElement("div");
        responseWriter.startElement("script", (UIComponent)component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        LinkedHashMap widgetOptions = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"header", (Object)component.getCaption(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"disabled", (Object)component.isDisabled(), null, null);
        LinkedHashMap bridgeOptions = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(bridgeOptions, (FacesContext)facesContext, (UIComponent)component, (RenderKitUtils.Attributes)ATTRIBUTES_FOR_SCRIPT_HASH2, (RenderKitUtils.ScriptHashVariableWrapper)RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        text = "jQuery(function() {\n                var $pickList = $(document.getElementById('" + PickListRenderer.convertToString(clientId) + "'));\n                $pickList.pickList(" + PickListRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{widgetOptions})) + ");\n                $pickList.pickListBridge(" + PickListRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{bridgeOptions})) + ");\n            });";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

