/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceUtils {
    private static final String QUOTED_STRING_REGEX = "(?:\\\\[\\x00-\\x7F]|[^\"\\\\])+";
    private static final Pattern ETAG_PATTERN = Pattern.compile("(?:W/)?\"((?:\\\\[\\x00-\\x7F]|[^\"\\\\])+)\"(?:,\\s*)?");

    private ResourceUtils() {
    }

    public static String formatWeakTag(String eTag) {
        String formattedTag = ResourceUtils.formatTag(eTag);
        if (formattedTag == null) {
            return null;
        }
        return "W/" + formattedTag;
    }

    public static String formatTag(String eTag) {
        if (eTag == null) {
            return null;
        }
        if (!eTag.matches(QUOTED_STRING_REGEX)) {
            throw new IllegalArgumentException();
        }
        return "\"" + eTag + "\"";
    }

    public static boolean matchTag(String eTag, String eTagHeaderValue) {
        if (eTag == null || eTagHeaderValue == null) {
            throw new NullPointerException();
        }
        Matcher eTagMatcher = ETAG_PATTERN.matcher(eTag);
        if (!eTagMatcher.find()) {
            throw new IllegalArgumentException();
        }
        eTag = eTagMatcher.group(1);
        Matcher eTagHeaderMatcher = ETAG_PATTERN.matcher(eTagHeaderValue);
        while (eTagHeaderMatcher.find()) {
            if (!eTag.equals(eTagHeaderMatcher.group(1))) continue;
            return true;
        }
        return false;
    }
}

