/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ContextInitParameters {
    public static final String HANDLE_VIEW_EXPIRED_ON_CLIENT = "org.ajax4jsf.handleViewExpiredOnClient";
    public static final String[] DATATABLE_USES_VIEW_LOCALE = new String[]{"org.richfaces.datatableUsesViewLocale"};

    private ContextInitParameters() {
    }

    public static boolean isDatatableUsesViewLocale(FacesContext context) {
        return ContextInitParameters.getBoolean(context, DATATABLE_USES_VIEW_LOCALE, false);
    }

    static int getInteger(FacesContext context, String[] paramNames, int defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        try {
            return Integer.parseInt(initParameter);
        }
        catch (NumberFormatException e) {
            throw new FacesException("Context parameter " + paramNames + " must have integer value");
        }
    }

    static String getString(FacesContext context, String[] paramNames, String defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        return initParameter;
    }

    static boolean getBoolean(FacesContext context, String[] paramNames, boolean defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        if ("true".equalsIgnoreCase(initParameter) || "yes".equalsIgnoreCase(initParameter)) {
            return true;
        }
        if ("false".equalsIgnoreCase(initParameter) || "no".equalsIgnoreCase(initParameter)) {
            return false;
        }
        throw new FacesException("Illegal value [" + initParameter + "] for a init parameter +" + paramNames + ", only logical values 'true' or 'false' is allowed");
    }

    static String getInitParameter(FacesContext context, String[] paramNames) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        for (int i = 0; i < paramNames.length && null == value; ++i) {
            value = externalContext.getInitParameter(paramNames[i]);
        }
        return value;
    }
}

