/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.webapp.taglib;

import javax.faces.component.UIComponent;

import org.ajax4jsf.renderkit.RendererUtils.HTML;


/**
 * Base tag for all components with common Html attributes.
 * @author asmirnov@exadel.com (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.1 $ $Date: 2007/01/09 18:59:55 $
 *
 */
public abstract class HtmlComponentTagBase extends UIComponentTagBase {
    //HTML universal attributes
    private String _dir;
    private String _lang;
    private String _style;
    private String _styleClass;
    private String _title;

    //HTML event handler attributes
    private String _onclick;
    private String _ondblclick;
    private String _onkeydown;
    private String _onkeypress;
    private String _onkeyup;
    private String _onmousedown;
    private String _onmousemove;
    private String _onmouseout;
    private String _onmouseover;
    private String _onmouseup;

    public void release() {
        super.release();

        _dir=null;
        _lang=null;
        _style=null;
        _styleClass=null;
        _title=null;
        _onclick=null;
        _ondblclick=null;
        _onkeydown=null;
        _onkeypress=null;
        _onkeyup=null;
        _onmousedown=null;
        _onmousemove=null;
        _onmouseout=null;
        _onmouseover=null;
        _onmouseup=null;

    }

    protected void setProperties(UIComponent component)
    {
        super.setProperties(component);
        setStringProperty(component, HTML.dir_ATTRIBUTE, _dir);
        setStringProperty(component, HTML.lang_ATTRIBUTE, _lang);
        setStringProperty(component, HTML.style_ATTRIBUTE, _style);
        setStringProperty(component, HTML.title_ATTRIBUTE, _title);
        setStringProperty(component, HTML.STYLE_CLASS_ATTR, _styleClass);
        setStringProperty(component, HTML.onclick_ATTRIBUTE, _onclick);
        setStringProperty(component, HTML.ondblclick_ATTRIBUTE, _ondblclick);
        setStringProperty(component, HTML.onmousedown_ATTRIBUTE, _onmousedown);
        setStringProperty(component, HTML.onmouseup_ATTRIBUTE, _onmouseup);
        setStringProperty(component, HTML.onmouseover_ATTRIBUTE, _onmouseover);
        setStringProperty(component, HTML.onmousemove_ATTRIBUTE, _onmousemove);
        setStringProperty(component, HTML.onmouseout_ATTRIBUTE, _onmouseout);
        setStringProperty(component, HTML.onkeypress_ATTRIBUTE, _onkeypress);
        setStringProperty(component, HTML.onkeydown_ATTRIBUTE, _onkeydown);
        setStringProperty(component, HTML.onkeyup_ATTRIBUTE, _onkeyup);
    }

    public void setStyleClass(String styleClass)
    {
        _styleClass = styleClass;
    }

    public void setDir(String dir)
    {
        _dir = dir;
    }

    public void setLang(String lang)
    {
        _lang = lang;
    }

    public void setStyle(String style)
    {
        _style = style;
    }

    public void setTitle(String title)
    {
        _title = title;
    }

    public void setOnclick(String onclick)
    {
        _onclick = onclick;
    }

    public void setOndblclick(String ondblclick)
    {
        _ondblclick = ondblclick;
    }

    public void setOnmousedown(String onmousedown)
    {
        _onmousedown = onmousedown;
    }

    public void setOnmouseup(String onmouseup)
    {
        _onmouseup = onmouseup;
    }

    public void setOnmouseover(String onmouseover)
    {
        _onmouseover = onmouseover;
    }

    public void setOnmousemove(String onmousemove)
    {
        _onmousemove = onmousemove;
    }

    public void setOnmouseout(String onmouseout)
    {
        _onmouseout = onmouseout;
    }

    public void setOnkeypress(String onkeypress)
    {
        _onkeypress = onkeypress;
    }

    public void setOnkeydown(String onkeydown)
    {
        _onkeydown = onkeydown;
    }

    public void setOnkeyup(String onkeyup)
    {
        _onkeyup = onkeyup;
    }

}
