/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.model.AbstractTreeDataModel;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.TreeDataModelNodeAdaptor;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeDataModel<T>
extends AbstractTreeDataModel {
    private Object wrappedData;
    private Class<T> clazz;
    private TreeRowKey currentRowKey;
    private TreeRowKey oldRowKey;
    private Boolean rowAvailable = Boolean.FALSE;
    private T rowTreeData;
    protected final TreeDataModelNodeAdaptor<T> nodeAdaptor;
    private MissingNodeHandler<T> missingNodeHandler;

    public TreeDataModel(Class<T> clazz, TreeDataModelNodeAdaptor<T> nodeAdaptor, MissingNodeHandler<T> missingNodeHandler) {
        this.clazz = clazz;
        this.nodeAdaptor = nodeAdaptor;
        this.missingNodeHandler = missingNodeHandler;
    }

    public final Class<T> getClazz() {
        return this.clazz;
    }

    public final TreeDataModelNodeAdaptor<T> getNodeAdaptor() {
        return this.nodeAdaptor;
    }

    @Override
    public Object getRowKey() {
        return this.currentRowKey;
    }

    @Override
    public void setRowKey(Object rowKey) {
        if (rowKey != null) {
            ListRowKey newRowKey = (ListRowKey)rowKey;
            this.currentRowKey = newRowKey;
            this.rowAvailable = null;
        } else {
            this.currentRowKey = null;
            this.oldRowKey = null;
            this.rowTreeData = null;
            this.rowAvailable = Boolean.FALSE;
        }
    }

    protected void doWalk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        TreeRange treeRange;
        ListRowKey listRowKey = (ListRowKey)rowKey;
        T node = this.locateTreeNode(listRowKey);
        if (node != null && ((treeRange = (TreeRange)range) == null || treeRange.processNode(listRowKey))) {
            Iterator<Map.Entry<Object, T>> children;
            if (this.nodeAdaptor.getParent(node) != null) {
                this.processElement(context, dataVisitor, argument, listRowKey, last);
            }
            if ((treeRange == null || treeRange.processChildren(listRowKey)) && !this.nodeAdaptor.isLeaf(node) && (children = this.nodeAdaptor.getChildren(node)) != null) {
                Object nextChildNode;
                Object identifier;
                Object childNode;
                Map.Entry<Object, T> childEntry;
                Map.Entry<Object, T> entry = childEntry = children.hasNext() ? children.next() : null;
                if (childEntry != null) {
                    childNode = childEntry.getValue();
                    identifier = childEntry.getKey();
                } else {
                    childNode = null;
                    identifier = null;
                }
                do {
                    Object nextIdentifier;
                    Map.Entry<Object, T> nextChildEntry;
                    Map.Entry<Object, T> entry2 = nextChildEntry = children.hasNext() ? children.next() : null;
                    if (nextChildEntry != null) {
                        nextChildNode = nextChildEntry.getValue();
                        nextIdentifier = nextChildEntry.getKey();
                    } else {
                        nextChildNode = null;
                        nextIdentifier = null;
                    }
                    if (childNode != null) {
                        boolean isLast = nextChildNode == null;
                        ListRowKey<Object> newRowKey = rowKey != null ? new ListRowKey<Object>(listRowKey, identifier) : new ListRowKey<Object>(identifier);
                        this.doWalk(context, dataVisitor, range, newRowKey, argument, isLast);
                    }
                    identifier = nextIdentifier;
                } while ((childNode = nextChildNode) != null);
            }
        }
    }

    @Override
    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        if (rowKey != null) {
            this.setRowKey(rowKey);
            if (!this.isRowAvailable()) {
                throw new IllegalStateException("No tree element available or row key not set!");
            }
        }
        this.doWalk(context, dataVisitor, range, rowKey, argument, last);
    }

    public T locateTreeNode(TreeRowKey rowKey) {
        return this.locateTreeNode(rowKey, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T locateTreeNode(TreeRowKey rowKey, boolean allowCreate) {
        boolean useCached;
        boolean bl = useCached = this.rowTreeData != null && rowKey != null && rowKey.equals(this.oldRowKey);
        if (useCached) return this.rowTreeData;
        T rootNode = this.getData();
        if (rootNode == null) return null;
        if (rowKey == null) return rootNode;
        int commonPathLength = rowKey.getCommonPathLength(this.oldRowKey);
        if (this.oldRowKey == null) {
            this.rowTreeData = rootNode;
        } else {
            int currentUpOpsCount;
            int currentOpsCount;
            int rootOpsCount = rowKey.depth();
            if (rootOpsCount > (currentOpsCount = (currentUpOpsCount = this.oldRowKey.depth() - commonPathLength) + rootOpsCount - commonPathLength)) {
                for (int i = 0; i < this.oldRowKey.depth() - commonPathLength; ++i) {
                    this.rowTreeData = this.nodeAdaptor.getParent(this.rowTreeData);
                }
            } else {
                commonPathLength = 0;
                this.rowTreeData = rootNode;
                this.oldRowKey = null;
            }
        }
        this.oldRowKey = rowKey;
        Iterator iterator = rowKey.getSubPathIterator(commonPathLength);
        while (iterator.hasNext()) {
            Object pathSegment = iterator.next();
            T childRowTreeData = this.nodeAdaptor.getChild(this.rowTreeData, pathSegment);
            if (childRowTreeData == null) {
                if (!allowCreate) {
                    return null;
                }
                if (this.missingNodeHandler == null) return null;
                childRowTreeData = this.missingNodeHandler.handleMissingNode(this.rowTreeData, pathSegment);
                if (childRowTreeData == null) {
                    return null;
                }
            }
            this.rowTreeData = childRowTreeData;
        }
        return this.rowTreeData;
    }

    public boolean isRowAvailable() {
        if (Boolean.FALSE.equals(this.rowAvailable)) {
            return false;
        }
        T data = this.locateTreeNode(this.currentRowKey);
        return data != null;
    }

    public Object getRowData() {
        if (this.isRowAvailable()) {
            T treeNode = this.locateTreeNode(this.currentRowKey);
            if (treeNode != null) {
                return this.nodeAdaptor.getRowData(treeNode);
            }
            return null;
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    @Override
    public boolean isLeaf() {
        T treeNode;
        if (this.isRowAvailable() && (treeNode = this.locateTreeNode(this.currentRowKey)) != null) {
            return this.nodeAdaptor.isLeaf(treeNode);
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    @Override
    public void walkModel(FacesContext context, DataVisitor visitor, Range range, Object key, Object argument, boolean last) throws IOException {
        this.walk(context, visitor, range, key, argument, last);
    }

    public Object getWrappedData() {
        return this.wrappedData;
    }

    public void setWrappedData(Object data) {
        this.wrappedData = data;
    }

    protected T getData() {
        return this.clazz.cast(this.wrappedData);
    }

    @Override
    public TreeNode<T> getTreeNode() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MissingNodeHandler<T> {
        public T handleMissingNode(T var1, Object var2);
    }
}

