/**
 * 
 */
package org.richfaces.model.selection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * @author Maksim Kaszynski
 *
 */
public class SimpleSelection implements Selection {

	private static final long serialVersionUID = 1L;

	private Set keys = new HashSet();
	
	public boolean addKey(Object rowKey) {
		return keys.add(rowKey);
	}
	
	public boolean removeKey(Object rowKey) {
		return keys.remove(rowKey);
	}
	
	public Iterator getKeys() {
		return keys.iterator();
	}

	public int size() {
		return keys.size();
	}
	
	public boolean isSelected(Object rowKey) {
		return keys.contains(rowKey);
	}

	public void clear() {
		keys.clear();
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((keys == null) ? 0 : keys.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SimpleSelection other = (SimpleSelection) obj;
		if (keys == null) {
			if (other.keys != null)
				return false;
		} else if (!keys.equals(other.keys))
			return false;
		return true;
	}
	
	
}
