/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.communication;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Context;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.BleManagerCallbacks;
import no.nordicsemi.android.ble.ReadRequest;
import no.nordicsemi.android.ble.WriteRequest;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsBleCallbacks;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsConnectionStatusListener;
import org.revolutionrobotics.bluetooth.android.domain.Device;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBatteryService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsConfigurationService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsDeviceService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsLiveControllerService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsMotorService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsSensorService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J?\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0*2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020&0,J\u0012\u00101\u001a\f02R\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0014J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u000e\u00107\u001a\u00020&2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020&2\u0006\u00108\u001a\u000209J\u001c\u0010;\u001a\u00020<2\b\u00105\u001a\u0004\u0018\u0001062\b\u0010=\u001a\u0004\u0018\u00010>H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "Lno/nordicsemi/android/ble/BleManager;", "Lno/nordicsemi/android/ble/BleManagerCallbacks;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "batteryService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService;", "getBatteryService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService;", "callbacks", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsBleCallbacks;", "configurationService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsConfigurationService;", "getConfigurationService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsConfigurationService;", "deviceService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService;", "getDeviceService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService;", "gattConnection", "Landroid/bluetooth/BluetoothGatt;", "liveControllerService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService;", "getLiveControllerService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService;", "motorService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService;", "getMotorService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService;", "sensorService", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService;", "getSensorService", "()Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService;", "services", "", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "connect", "", "device", "Lorg/revolutionrobotics/bluetooth/android/domain/Device;", "onConnected", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "getGattCallback", "Lno/nordicsemi/android/ble/BleManager$BleManagerGattCallback;", "readCharacteristic", "Lno/nordicsemi/android/ble/ReadRequest;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "registerConnectionListener", "listener", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsConnectionStatusListener;", "unregisterConnectionListener", "writeCharacteristic", "Lno/nordicsemi/android/ble/WriteRequest;", "data", "", "GattCallback", "bluetooth-android_release"})
public final class RoboticsDeviceConnector
extends BleManager<BleManagerCallbacks> {
    private BluetoothGatt gattConnection;
    private final RoboticsBleCallbacks callbacks;
    private final Set<RoboticsBLEService> services;

    @NotNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new GattCallback();
    }

    @NotNull
    public final RoboticsDeviceService getDeviceService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsDeviceService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsDeviceService");
        }
        return (RoboticsDeviceService)t;
    }

    @NotNull
    public final RoboticsLiveControllerService getLiveControllerService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsLiveControllerService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsLiveControllerService");
        }
        return (RoboticsLiveControllerService)t;
    }

    @NotNull
    public final RoboticsBatteryService getBatteryService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsBatteryService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsBatteryService");
        }
        return (RoboticsBatteryService)t;
    }

    @NotNull
    public final RoboticsConfigurationService getConfigurationService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsConfigurationService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsConfigurationService");
        }
        return (RoboticsConfigurationService)t;
    }

    @NotNull
    public final RoboticsMotorService getMotorService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsMotorService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsMotorService");
        }
        return (RoboticsMotorService)t;
    }

    @NotNull
    public final RoboticsSensorService getSensorService() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = this.services;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv2;
                boolean bl = false;
                if (!(it instanceof RoboticsSensorService)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.revolutionrobotics.bluetooth.android.service.RoboticsSensorService");
        }
        return (RoboticsSensorService)t;
    }

    public final void connect(@NotNull Device device, @NotNull Function0<Unit> onConnected, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull(onConnected, (String)"onConnected");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.connect(device.getBluetoothDevice()).timeout(100000L).retry(3, 100).done(new SuccessCallback(onConnected){
            final /* synthetic */ Function0 $onConnected;

            public final void onRequestCompleted(@NotNull BluetoothDevice it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$onConnected.invoke();
            }
            {
                this.$onConnected = function0;
            }
        }).fail(new FailCallback(onError){
            final /* synthetic */ Function1 $onError;

            public final void onRequestFailed(@NotNull BluetoothDevice device, int status) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                this.$onError.invoke((Object)new BLEConnectionException(status));
            }
            {
                this.$onError = function1;
            }
        }).enqueue();
    }

    public final void registerConnectionListener(@NotNull RoboticsConnectionStatusListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        listener.onConnectionStateChanged(this.isConnected());
        this.callbacks.registerConnectionListener(listener);
    }

    public final void unregisterConnectionListener(@NotNull RoboticsConnectionStatusListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.callbacks.unregisterConnectionListener(listener);
    }

    @NotNull
    public WriteRequest writeCharacteristic(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data) {
        WriteRequest writeRequest = super.writeCharacteristic(characteristic, data);
        Intrinsics.checkExpressionValueIsNotNull((Object)writeRequest, (String)"super.writeCharacteristic(characteristic, data)");
        return writeRequest;
    }

    @NotNull
    public ReadRequest readCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        ReadRequest readRequest = super.readCharacteristic(characteristic);
        Intrinsics.checkExpressionValueIsNotNull((Object)readRequest, (String)"super.readCharacteristic(characteristic)");
        return readRequest;
    }

    public RoboticsDeviceConnector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.callbacks = new RoboticsBleCallbacks();
        this.services = SetsKt.setOf((Object[])new RoboticsBLEService[]{new RoboticsDeviceService(this), new RoboticsLiveControllerService(this), new RoboticsBatteryService(this), new RoboticsConfigurationService(this), new RoboticsMotorService(this), new RoboticsSensorService(this)});
        this.setGattCallbacks(this.callbacks);
    }

    public static final /* synthetic */ BluetoothGatt access$getGattConnection$p(RoboticsDeviceConnector $this) {
        return $this.gattConnection;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector$GattCallback;", "Lno/nordicsemi/android/ble/BleManager$BleManagerGattCallback;", "Lno/nordicsemi/android/ble/BleManager;", "Lno/nordicsemi/android/ble/BleManagerCallbacks;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "initialize", "", "isRequiredServiceSupported", "", "gatt", "Landroid/bluetooth/BluetoothGatt;", "onDeviceDisconnected", "bluetooth-android_release"})
    private final class GattCallback
    extends BleManager.BleManagerGattCallback {
        protected void onDeviceDisconnected() {
            Iterable $this$forEach$iv = RoboticsDeviceConnector.this.services;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv;
                boolean bl = false;
                it.disconnect();
            }
        }

        protected boolean isRequiredServiceSupported(@NotNull BluetoothGatt gatt) {
            Intrinsics.checkParameterIsNotNull((Object)gatt, (String)"gatt");
            RoboticsDeviceConnector.this.gattConnection = gatt;
            Iterable $this$forEach$iv = RoboticsDeviceConnector.this.services;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RoboticsBLEService it = (RoboticsBLEService)element$iv;
                boolean bl = false;
                it.init(gatt);
            }
            return true;
        }

        protected void initialize() {
            super.initialize();
            RoboticsDeviceConnector.this.requestConnectionPriority(1).enqueue();
            RoboticsDeviceConnector.this.requestMtu(512).enqueue();
        }

        public GattCallback() {
            super((BleManager)RoboticsDeviceConnector.this);
        }
    }
}

