/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.data.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00180\u001eH\u0004J(\u0010 \u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "bluetoothGatt", "Landroid/bluetooth/BluetoothGatt;", "getBluetoothGatt", "()Landroid/bluetooth/BluetoothGatt;", "setBluetoothGatt", "(Landroid/bluetooth/BluetoothGatt;)V", "getDeviceConnector", "()Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "service", "Landroid/bluetooth/BluetoothGattService;", "getService", "()Landroid/bluetooth/BluetoothGattService;", "setService", "(Landroid/bluetooth/BluetoothGattService;)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "disconnect", "", "init", "readMessage", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "callback", "Lkotlin/Function1;", "Lno/nordicsemi/android/ble/data/Data;", "writeMessage", "byteArray", "", "done", "Lkotlin/Function0;", "bluetooth-android_release"})
public abstract class RoboticsBLEService {
    @Nullable
    private BluetoothGattService service;
    @Nullable
    private BluetoothGatt bluetoothGatt;
    @NotNull
    private final RoboticsDeviceConnector deviceConnector;

    @NotNull
    public abstract UUID getServiceId();

    @Nullable
    protected final BluetoothGattService getService() {
        return this.service;
    }

    protected final void setService(@Nullable BluetoothGattService bluetoothGattService) {
        this.service = bluetoothGattService;
    }

    @Nullable
    protected final BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    protected final void setBluetoothGatt(@Nullable BluetoothGatt bluetoothGatt) {
        this.bluetoothGatt = bluetoothGatt;
    }

    public void init(@NotNull BluetoothGatt bluetoothGatt) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothGatt, (String)"bluetoothGatt");
        this.bluetoothGatt = bluetoothGatt;
        this.service = bluetoothGatt.getService(this.getServiceId());
    }

    public void disconnect() {
        BluetoothGatt bluetoothGatt = this.bluetoothGatt;
        if (bluetoothGatt != null) {
            bluetoothGatt.disconnect();
        }
        this.bluetoothGatt = null;
        this.service = null;
    }

    protected final void readMessage(@Nullable BluetoothGattCharacteristic characteristic, @NotNull Function1<? super Data, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        this.deviceConnector.readCharacteristic(characteristic).with(new DataReceivedCallback(callback2){
            final /* synthetic */ Function1 $callback;

            public final void onDataReceived(@NotNull BluetoothDevice device, @NotNull Data data) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$callback.invoke((Object)data);
            }
            {
                this.$callback = function1;
            }
        }).enqueue();
    }

    protected final void writeMessage(@Nullable BluetoothGattCharacteristic characteristic, @NotNull byte[] byteArray, @NotNull Function0<Unit> done) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
            Intrinsics.checkParameterIsNotNull(done, (String)"done");
            BluetoothGattCharacteristic bluetoothGattCharacteristic = characteristic;
            if (bluetoothGattCharacteristic == null) break block0;
            BluetoothGattCharacteristic bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattCharacteristic it = bluetoothGattCharacteristic2;
            boolean bl3 = false;
            this.deviceConnector.writeCharacteristic(characteristic, byteArray).done(new SuccessCallback(this, characteristic, byteArray, done){
                final /* synthetic */ RoboticsBLEService this$0;
                final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                final /* synthetic */ byte[] $byteArray$inlined;
                final /* synthetic */ Function0 $done$inlined;
                {
                    this.this$0 = roboticsBLEService;
                    this.$characteristic$inlined = bluetoothGattCharacteristic;
                    this.$byteArray$inlined = byArray;
                    this.$done$inlined = function0;
                }

                public final void onRequestCompleted(@NotNull BluetoothDevice it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$done$inlined.invoke();
                }
            }).enqueue();
        }
    }

    @NotNull
    protected final RoboticsDeviceConnector getDeviceConnector() {
        return this.deviceConnector;
    }

    public RoboticsBLEService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        this.deviceConnector = deviceConnector;
    }
}

