/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.extensions;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.exception.BLEDisabledException;
import org.revolutionrobotics.bluetooth.android.exception.MissingBLEFeatureException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"getBLEManager", "Landroid/bluetooth/BluetoothManager;", "Landroid/content/Context;", "bluetooth-android_release"})
public final class ContextExtensionsKt {
    @NotNull
    public static final BluetoothManager getBLEManager(@NotNull Context $this$getBLEManager) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getBLEManager, (String)"$this$getBLEManager");
        if (!$this$getBLEManager.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            throw (Throwable)new MissingBLEFeatureException();
        }
        Object object = $this$getBLEManager.getSystemService("bluetooth");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        }
        BluetoothManager bluetoothManager = (BluetoothManager)object;
        BluetoothAdapter bluetoothAdapter = bluetoothManager.getAdapter();
        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothAdapter, (String)"bluetoothManager.adapter");
        if (!bluetoothAdapter.isEnabled()) {
            throw (Throwable)new BLEDisabledException();
        }
        return bluetoothManager;
    }
}

