/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.discover;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.ParcelUuid;
import androidx.annotation.RequiresPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.discover.RoboticsDeviceDiscoverer;
import org.revolutionrobotics.bluetooth.android.domain.Device;
import org.revolutionrobotics.bluetooth.android.exception.BLEScanFailedException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u0006\u0010\u0011\u001a\u00020\nR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\"\u0010\u0006\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer;", "", "()V", "callback", "org/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer$callback$1", "Lorg/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer$callback$1;", "scanResultListener", "Lkotlin/Function1;", "", "Lorg/revolutionrobotics/bluetooth/android/domain/Device;", "", "scanner", "Lno/nordicsemi/android/support/v18/scanner/BluetoothLeScannerCompat;", "discoverRobots", "context", "Landroid/content/Context;", "listener", "stopDiscovering", "Companion", "bluetooth-android_release"})
public final class RoboticsDeviceDiscoverer {
    private Function1<? super List<Device>, Unit> scanResultListener;
    private BluetoothLeScannerCompat scanner;
    private callback.1 callback;
    @NotNull
    private static final UUID SERVICE_ID_LIVE;
    @NotNull
    private static final UUID SERVICE_ID_DEVICE_INFO;
    public static final Companion Companion;

    @RequiresPermission(allOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.BLUETOOTH"})
    public final void discoverRobots(@NotNull Context context, @NotNull Function1<? super List<Device>, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.scanResultListener = listener;
        this.scanner.startScan(CollectionsKt.listOf((Object[])new ScanFilter[]{new ScanFilter.Builder().setServiceUuid(new ParcelUuid(SERVICE_ID_LIVE)).build(), new ScanFilter.Builder().setServiceUuid(new ParcelUuid(SERVICE_ID_DEVICE_INFO)).build()}), new ScanSettings.Builder().setScanMode(2).setUseHardwareBatchingIfSupported(true).build(), (ScanCallback)this.callback);
    }

    public final void stopDiscovering() {
        this.scanner.stopScan((ScanCallback)this.callback);
        this.scanResultListener = null;
    }

    public RoboticsDeviceDiscoverer() {
        BluetoothLeScannerCompat bluetoothLeScannerCompat = BluetoothLeScannerCompat.getScanner();
        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothLeScannerCompat, (String)"BluetoothLeScannerCompat.getScanner()");
        this.scanner = bluetoothLeScannerCompat;
        this.callback = new ScanCallback(this){
            final /* synthetic */ RoboticsDeviceDiscoverer this$0;

            public void onScanFailed(int errorCode) {
                RoboticsDeviceDiscoverer.access$getScanner$p(this.this$0).stopScan((ScanCallback)this);
                this.this$0.stopDiscovering();
                throw (Throwable)new BLEScanFailedException(errorCode);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@NotNull List<ScanResult> results) {
                block1: {
                    Collection<Device> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkParameterIsNotNull(results, (String)"results");
                    Function1 function1 = RoboticsDeviceDiscoverer.access$getScanResultListener$p(this.this$0);
                    if (function1 == null) break block1;
                    Iterable iterable = results;
                    Function1 function12 = function1;
                    boolean $i$f$map = false;
                    void var4_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ScanResult scanResult = (ScanResult)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        BluetoothDevice bluetoothDevice = it.getDevice();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"it.device");
                        String string = bluetoothDevice.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.device.name");
                        BluetoothDevice bluetoothDevice2 = it.getDevice();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice2, (String)"it.device");
                        String string2 = bluetoothDevice2.getAddress();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.device.address");
                        BluetoothDevice bluetoothDevice3 = it.getDevice();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice3, (String)"it.device");
                        Device device = new Device(string, string2, bluetoothDevice3);
                        collection.add(device);
                    }
                    collection = (List)destination$iv$iv;
                    Unit cfr_ignored_0 = (Unit)function12.invoke((Object)collection);
                }
            }

            public void onScanResult(int callbackType, @NotNull ScanResult result) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                    Function1 function1 = RoboticsDeviceDiscoverer.access$getScanResultListener$p(this.this$0);
                    if (function1 == null) break block0;
                    BluetoothDevice bluetoothDevice = result.getDevice();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"result.device");
                    String string = bluetoothDevice.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.name");
                    BluetoothDevice bluetoothDevice2 = result.getDevice();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice2, (String)"result.device");
                    String string2 = bluetoothDevice2.getAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.device.address");
                    BluetoothDevice bluetoothDevice3 = result.getDevice();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice3, (String)"result.device");
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)CollectionsKt.listOf((Object)new Device(string, string2, bluetoothDevice3)));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("d2d5558c-5b9d-11e9-8647-d663bd873d93");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"d2d5558\u2026-11e9-8647-d663bd873d93\")");
        SERVICE_ID_LIVE = uUID;
        UUID uUID2 = UUID.fromString("F000180A-0451-4000-B000-000000000000");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"F000180\u2026-4000-B000-000000000000\")");
        SERVICE_ID_DEVICE_INFO = uUID2;
    }

    public static final /* synthetic */ BluetoothLeScannerCompat access$getScanner$p(RoboticsDeviceDiscoverer $this) {
        return $this.scanner;
    }

    public static final /* synthetic */ void access$setScanner$p(RoboticsDeviceDiscoverer $this, BluetoothLeScannerCompat bluetoothLeScannerCompat) {
        $this.scanner = bluetoothLeScannerCompat;
    }

    public static final /* synthetic */ Function1 access$getScanResultListener$p(RoboticsDeviceDiscoverer $this) {
        return $this.scanResultListener;
    }

    public static final /* synthetic */ void access$setScanResultListener$p(RoboticsDeviceDiscoverer $this, Function1 function1) {
        $this.scanResultListener = function1;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer$Companion;", "", "()V", "SERVICE_ID_DEVICE_INFO", "Ljava/util/UUID;", "getSERVICE_ID_DEVICE_INFO", "()Ljava/util/UUID;", "SERVICE_ID_LIVE", "getSERVICE_ID_LIVE", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getSERVICE_ID_LIVE() {
            return SERVICE_ID_LIVE;
        }

        @NotNull
        public final UUID getSERVICE_ID_DEVICE_INFO() {
            return SERVICE_ID_DEVICE_INFO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

