/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.data.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.BumperInfo;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.UltrasoundInfo;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JE\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "read", "", "sensor", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Sensor;", "onComplete", "Lkotlin/Function1;", "", "onError", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "Companion", "Sensor", "bluetooth-android_release"})
public final class RoboticsSensorService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    public static final int ULTRASOUND_MESSAGE_SIZE = 5;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    public final void read(@NotNull Sensor sensor, @NotNull Function1<? super byte[], Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)sensor), (String)"sensor");
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(sensor.getCharacteristic())) == null) break block0;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            this.getDeviceConnector().readCharacteristic((BluetoothGattCharacteristic)characteristic).with(new DataReceivedCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsSensorService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsSensorService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onDataReceived(@NotNull BluetoothDevice $noName_0, @NotNull Data data) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    byte[] byArray = data.getValue();
                    if (byArray == null) {
                        byArray = new byte[]{};
                    }
                    this.$onComplete$inlined.invoke((Object)byArray);
                }
            }).fail(new FailCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsSensorService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsSensorService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onRequestFailed(@NotNull BluetoothDevice $noName_0, int status) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    this.$onError$inlined.invoke((Object)new BLEConnectionException(status));
                }
            }).enqueue();
        }
    }

    public RoboticsSensorService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        super(deviceConnector);
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Sensor;", "", "characteristic", "Ljava/util/UUID;", "(Ljava/lang/String;ILjava/util/UUID;)V", "getCharacteristic", "()Ljava/util/UUID;", "S1", "S2", "S3", "S4", "bluetooth-android_release"})
    public static final class Sensor
    extends Enum<Sensor> {
        public static final /* enum */ Sensor S1;
        public static final /* enum */ Sensor S2;
        public static final /* enum */ Sensor S3;
        public static final /* enum */ Sensor S4;
        private static final /* synthetic */ Sensor[] $VALUES;
        @NotNull
        private final UUID characteristic;

        static {
            Sensor[] sensorArray = new Sensor[4];
            Sensor[] sensorArray2 = sensorArray;
            UUID uUID = UUID.fromString("135032e6-3e86-404f-b0a9-953fd46dcb17");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"135032e\u2026-404f-b0a9-953fd46dcb17\")");
            sensorArray[0] = S1 = new Sensor(uUID);
            UUID uUID2 = UUID.fromString("36e944ef-34fe-4de2-9310-394d482e20e6");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"36e944e\u2026-4de2-9310-394d482e20e6\")");
            sensorArray[1] = S2 = new Sensor(uUID2);
            UUID uUID3 = UUID.fromString("b3a71566-9af2-4c9d-bc4a-6f754ab6fcf0");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"b3a7156\u2026-4c9d-bc4a-6f754ab6fcf0\")");
            sensorArray[2] = S3 = new Sensor(uUID3);
            UUID uUID4 = UUID.fromString("9ace575c-0b70-4ed5-96f1-979a8eadbc6b");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"9ace575\u2026-4ed5-96f1-979a8eadbc6b\")");
            sensorArray[3] = S4 = new Sensor(uUID4);
            $VALUES = sensorArray;
        }

        @NotNull
        public final UUID getCharacteristic() {
            return this.characteristic;
        }

        private Sensor(UUID characteristic) {
            this.characteristic = characteristic;
        }

        public static Sensor[] values() {
            return (Sensor[])$VALUES.clone();
        }

        public static Sensor valueOf(String string) {
            return Enum.valueOf(Sensor.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Companion;", "", "()V", "SERVICE_ID", "", "ULTRASOUND_MESSAGE_SIZE", "", "getBumberInfo", "Lorg/revolutionrobotics/bluetooth/android/service/BumperInfo;", "bytes", "", "getUltrasoundInfo", "Lorg/revolutionrobotics/bluetooth/android/service/UltrasoundInfo;", "bluetooth-android_release"})
    public static final class Companion {
        @Nullable
        public final BumperInfo getBumberInfo(@NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            byte[] byArray = bytes;
            boolean bl = false;
            return byArray.length == 0 ? null : new BumperInfo(bytes[1] == (byte)2);
        }

        @Nullable
        public final UltrasoundInfo getUltrasoundInfo(@NotNull byte[] bytes) {
            UltrasoundInfo ultrasoundInfo;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            if (bytes.length >= 5) {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                ultrasoundInfo = new UltrasoundInfo(byteBuffer.getInt());
            } else {
                ultrasoundInfo = null;
            }
            return ultrasoundInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

