/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.communication;

import android.util.Log;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import no.nordicsemi.android.ble.data.DataSplitter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.communication.LongMessageSplitter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/revolutionrobotics/bluetooth/android/communication/LongMessageSplitter;", "Lno/nordicsemi/android/ble/data/DataSplitter;", "firstByte", "", "chunkLength", "", "(BI)V", "chunk", "", "message", "index", "maxLength", "toStringCustom", "", "bluetooth-android_release"})
public final class LongMessageSplitter
implements DataSplitter {
    private final byte firstByte;
    private final int chunkLength;

    @Nullable
    public byte[] chunk(@NotNull byte[] message, int index, int maxLength) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        int dataLength = this.chunkLength - 1;
        int startIndex = index * dataLength;
        if (startIndex < message.length) {
            int endIndex = RangesKt.coerceAtMost((int)(startIndex + dataLength), (int)message.length);
            byte[] byArray2 = new byte[endIndex - startIndex + 1];
            boolean bl = false;
            boolean bl2 = false;
            byte[] $this$apply = byArray2;
            boolean bl3 = false;
            $this$apply[0] = this.firstByte;
            ArraysKt.copyInto((byte[])message, (byte[])$this$apply, (int)1, (int)startIndex, (int)endIndex);
            byte[] chunk = byArray2;
            Log.d((String)"LongMessage", (String)("Write message sent: " + this.toStringCustom(chunk)));
            byArray = chunk;
        } else {
            byArray = null;
        }
        return byArray;
    }

    private final String toStringCustom(@NotNull byte[] $this$toStringCustom) {
        return ArraysKt.joinToString$default((byte[])$this$toStringCustom, null, null, null, (int)0, null, (Function1)toStringCustom.1.INSTANCE, (int)31, null);
    }

    public LongMessageSplitter(byte firstByte, int chunkLength) {
        this.firstByte = firstByte;
        this.chunkLength = chunkLength;
    }
}

