/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import androidx.annotation.IntRange;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0014J\u001a\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\"\u0010 \u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u0010J\u0010\u0010#\u001a\u00020\u00102\b\b\u0001\u0010\r\u001a\u00020\u0014J\u0010\u0010$\u001a\u00020\u00102\b\b\u0001\u0010\u000e\u001a\u00020\u0014J\u0015\u0010%\u001a\u00020\u0014*\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "buttonByte", "", "isRunning", "", "schedulerJob", "Lkotlinx/coroutines/Job;", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "x", "y", "disconnect", "", "generateMessage", "", "counter", "", "getMaskBasedOnIndex", "buttonIndex", "onButtonPressed", "onButtonReleased", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicRead", "status", "onCharacteristicWrite", "start", "stop", "updateXDirection", "updateYDirection", "pow", "exponent", "Companion", "bluetooth-android_release"})
public final class RoboticsLiveControllerService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private boolean isRunning;
    private Job schedulerJob;
    private byte x;
    private byte y;
    private byte buttonByte;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    @NotNull
    private static final UUID CHARACTERISTIC_ID;
    public static final long DELAY_TIME_IN_MILLIS = 100L;
    public static final int COUNTER_MAX = 16;
    public static final int POSITION_KEEP_ALIVE = 1;
    public static final int POSITION_X_COORD = 1;
    public static final int POSITION_Y_COORD = 2;
    public static final int POSITION_BUTTON = 11;
    public static final int MESSAGE_LENGTH = 20;
    public static final byte MAX_BYTE_MASK = -1;
    public static final byte DEFAULT_COORDINATE = 127;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public void disconnect() {
        this.stop();
        this.setService(null);
        super.disconnect();
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void counter;
        this.stop();
        this.isRunning = true;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        this.schedulerJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Ref.IntRef)counter, null){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ RoboticsLiveControllerService this$0;
            final /* synthetic */ Ref.IntRef $counter;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$launch = this.p$;
                        while (true) {
                            if (RoboticsLiveControllerService.access$isRunning$p(this.this$0)) {
                                var3_4 = this.$counter.element;
                                this.$counter.element = var3_4 + 1;
                                if (this.$counter.element == 16) {
                                    this.$counter.element = 0;
                                }
                                if ((v0 = this.this$0.getService()) != null && (v0 = v0.getCharacteristic(RoboticsLiveControllerService.Companion.getCHARACTERISTIC_ID())) != null) {
                                    var3_5 = v0;
                                    var4_6 = false;
                                    var5_7 = false;
                                    characteristic = var3_5;
                                    $i$a$-let-RoboticsLiveControllerService$start$1$1 = false;
                                    characteristic.setValue(RoboticsLiveControllerService.access$generateMessage(this.this$0, this.$counter.element));
                                    v1 = this.this$0.getBluetoothGatt();
                                    if (v1 != null) {
                                        Boxing.boxBoolean((boolean)v1.writeCharacteristic((BluetoothGattCharacteristic)characteristic));
                                    }
                                }
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v2 = DelayKt.delay((long)100L, (Continuation)this);
                            if (v2 != var8_2) continue;
                            return var8_2;
                        }
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        if (RoboticsLiveControllerService.access$isRunning$p(this.this$0)) ** continue;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = roboticsLiveControllerService;
                this.$counter = intRef;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stop() {
        this.buttonByte = (byte)0;
        this.isRunning = false;
        Job job = this.schedulerJob;
        if (job != null) {
            job.cancel();
        }
        this.schedulerJob = null;
    }

    public final void updateXDirection(@IntRange(from=0L, to=255L) int x) {
        this.x = (byte)x;
    }

    public final void updateYDirection(@IntRange(from=0L, to=255L) int y) {
        this.y = (byte)y;
    }

    public final void onButtonPressed(@IntRange(from=0L, to=8L) int buttonIndex) {
        byte by;
        byte by2 = this.buttonByte;
        byte by3 = this.getMaskBasedOnIndex(buttonIndex);
        RoboticsLiveControllerService roboticsLiveControllerService = this;
        boolean bl = false;
        roboticsLiveControllerService.buttonByte = by = (byte)(by2 | by3);
    }

    public final void onButtonReleased(@IntRange(from=0L, to=8L) int buttonIndex) {
        byte by;
        byte by2 = this.buttonByte;
        byte by3 = this.getMaskBasedOnIndex(buttonIndex);
        RoboticsLiveControllerService roboticsLiveControllerService = this;
        boolean bl = false;
        by3 = by = (byte)(~by3);
        bl = false;
        roboticsLiveControllerService.buttonByte = by = (byte)(by2 & by3);
    }

    private final byte getMaskBasedOnIndex(int buttonIndex) {
        return (byte)this.pow(2, buttonIndex);
    }

    private final byte[] generateMessage(int counter) {
        byte[] byArray = new byte[20];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[1] = (byte)counter;
        $this$apply[1] = this.x;
        $this$apply[2] = this.y;
        $this$apply[11] = this.buttonByte;
        return byArray;
    }

    private final int pow(int $this$pow, int exponent) {
        int res = 1;
        int n = CollectionsKt.count((Iterable)((Iterable)RangesKt.downTo((int)exponent, (int)1)));
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            res *= $this$pow;
        }
        return res;
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    public RoboticsLiveControllerService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        this.x = (byte)127;
        this.y = (byte)127;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("7486bec3-bb6b-4abd-a9ca-20adc281a0a4");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"7486bec\u2026-4abd-a9ca-20adc281a0a4\")");
        CHARACTERISTIC_ID = uUID;
    }

    public static final /* synthetic */ boolean access$isRunning$p(RoboticsLiveControllerService $this) {
        return $this.isRunning;
    }

    public static final /* synthetic */ void access$setRunning$p(RoboticsLiveControllerService $this, boolean bl) {
        $this.isRunning = bl;
    }

    public static final /* synthetic */ byte[] access$generateMessage(RoboticsLiveControllerService $this, int counter) {
        return $this.generateMessage(counter);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService$Companion;", "", "()V", "CHARACTERISTIC_ID", "Ljava/util/UUID;", "getCHARACTERISTIC_ID", "()Ljava/util/UUID;", "COUNTER_MAX", "", "DEFAULT_COORDINATE", "", "DELAY_TIME_IN_MILLIS", "", "MAX_BYTE_MASK", "MESSAGE_LENGTH", "POSITION_BUTTON", "POSITION_KEEP_ALIVE", "POSITION_X_COORD", "POSITION_Y_COORD", "SERVICE_ID", "", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getCHARACTERISTIC_ID() {
            return CHARACTERISTIC_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

