/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.BumperInfo;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsEventSerializer;
import org.revolutionrobotics.bluetooth.android.service.UltrasoundInfo;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JE\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010 \u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006R`\u0010\u0003\u001aT\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j)\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRB\u0010\u0010\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "errorCallbackMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "", "Lkotlin/collections/HashMap;", "serviceId", "getServiceId", "()Ljava/util/UUID;", "successCallbackMap", "", "disconnect", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicRead", "status", "", "onCharacteristicWrite", "read", "sensor", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Sensor;", "onComplete", "onError", "Companion", "Sensor", "bluetooth-android_release"})
public final class RoboticsSensorService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private final HashMap<UUID, Function1<byte[], Unit>> successCallbackMap;
    private final HashMap<UUID, Function1<BLEException, Unit>> errorCallbackMap;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    public static final int ULTRASOUND_MESSAGE_SIZE = 5;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public void disconnect() {
        this.successCallbackMap.clear();
        this.errorCallbackMap.clear();
        super.disconnect();
    }

    public final void read(@NotNull Sensor sensor, @NotNull Function1<? super byte[], Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)sensor), (String)"sensor");
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(sensor.getCharacteristic())) == null) break block2;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt != null) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl6 = false;
                ((Map)this.successCallbackMap).put(sensor.getCharacteristic(), onComplete);
                ((Map)this.errorCallbackMap).put(sensor.getCharacteristic(), onError);
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(bluetoothGatt3, (BluetoothGattCharacteristic)characteristic, this, onComplete, sensor, onError){
                        final /* synthetic */ BluetoothGatt $bluetoothGatt;
                        final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                        final /* synthetic */ RoboticsSensorService this$0;
                        final /* synthetic */ Function1 $onComplete$inlined;
                        final /* synthetic */ Sensor $sensor$inlined;
                        final /* synthetic */ Function1 $onError$inlined;
                        {
                            this.$bluetoothGatt = bluetoothGatt;
                            this.$characteristic$inlined = bluetoothGattCharacteristic;
                            this.this$0 = roboticsSensorService;
                            this.$onComplete$inlined = function1;
                            this.$sensor$inlined = sensor;
                            this.$onError$inlined = function12;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$bluetoothGatt.readCharacteristic(this.$characteristic$inlined);
                        }
                    }));
                }
            }
        }
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
                if (status != 0) break block0;
                Function1<byte[], Unit> function1 = this.successCallbackMap.get(characteristic.getUuid());
                if (function1 == null) break block1;
                Function1<byte[], Unit> function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1<byte[], Unit> callback2 = function12;
                boolean bl3 = false;
                byte[] byArray = characteristic.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"characteristic.value");
                callback2.invoke((Object)byArray);
                this.errorCallbackMap.remove(characteristic.getUuid());
                this.successCallbackMap.remove(characteristic.getUuid());
                break block1;
            }
            Function1<BLEException, Unit> function1 = this.errorCallbackMap.get(characteristic.getUuid());
            if (function1 == null) break block1;
            Function1<BLEException, Unit> function13 = function1;
            boolean bl = false;
            boolean bl4 = false;
            Function1<BLEException, Unit> callback3 = function13;
            boolean bl5 = false;
            callback3.invoke((Object)new BLEConnectionException(status));
            this.successCallbackMap.remove(characteristic.getUuid());
            this.errorCallbackMap.remove(characteristic.getUuid());
        }
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    public RoboticsSensorService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        RoboticsSensorService roboticsSensorService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        roboticsSensorService.successCallbackMap = hashMap;
        roboticsSensorService = this;
        bl = false;
        hashMap = new HashMap();
        roboticsSensorService.errorCallbackMap = hashMap;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Sensor;", "", "characteristic", "Ljava/util/UUID;", "(Ljava/lang/String;ILjava/util/UUID;)V", "getCharacteristic", "()Ljava/util/UUID;", "S1", "S2", "S3", "S4", "bluetooth-android_release"})
    public static final class Sensor
    extends Enum<Sensor> {
        public static final /* enum */ Sensor S1;
        public static final /* enum */ Sensor S2;
        public static final /* enum */ Sensor S3;
        public static final /* enum */ Sensor S4;
        private static final /* synthetic */ Sensor[] $VALUES;
        @NotNull
        private final UUID characteristic;

        static {
            Sensor[] sensorArray = new Sensor[4];
            Sensor[] sensorArray2 = sensorArray;
            UUID uUID = UUID.fromString("135032e6-3e86-404f-b0a9-953fd46dcb17");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"135032e\u2026-404f-b0a9-953fd46dcb17\")");
            sensorArray[0] = S1 = new Sensor(uUID);
            UUID uUID2 = UUID.fromString("36e944ef-34fe-4de2-9310-394d482e20e6");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"36e944e\u2026-4de2-9310-394d482e20e6\")");
            sensorArray[1] = S2 = new Sensor(uUID2);
            UUID uUID3 = UUID.fromString("b3a71566-9af2-4c9d-bc4a-6f754ab6fcf0");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"b3a7156\u2026-4c9d-bc4a-6f754ab6fcf0\")");
            sensorArray[2] = S3 = new Sensor(uUID3);
            UUID uUID4 = UUID.fromString("9ace575c-0b70-4ed5-96f1-979a8eadbc6b");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"9ace575\u2026-4ed5-96f1-979a8eadbc6b\")");
            sensorArray[3] = S4 = new Sensor(uUID4);
            $VALUES = sensorArray;
        }

        @NotNull
        public final UUID getCharacteristic() {
            return this.characteristic;
        }

        private Sensor(UUID characteristic) {
            this.characteristic = characteristic;
        }

        public static Sensor[] values() {
            return (Sensor[])$VALUES.clone();
        }

        public static Sensor valueOf(String string) {
            return Enum.valueOf(Sensor.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsSensorService$Companion;", "", "()V", "SERVICE_ID", "", "ULTRASOUND_MESSAGE_SIZE", "", "getBumberInfo", "Lorg/revolutionrobotics/bluetooth/android/service/BumperInfo;", "bytes", "", "getUltrasoundInfo", "Lorg/revolutionrobotics/bluetooth/android/service/UltrasoundInfo;", "bluetooth-android_release"})
    public static final class Companion {
        @Nullable
        public final BumperInfo getBumberInfo(@NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            byte[] byArray = bytes;
            boolean bl = false;
            return byArray.length == 0 ? null : new BumperInfo(bytes[1] == (byte)2);
        }

        @Nullable
        public final UltrasoundInfo getUltrasoundInfo(@NotNull byte[] bytes) {
            UltrasoundInfo ultrasoundInfo;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            if (bytes.length >= 5) {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                ultrasoundInfo = new UltrasoundInfo(byteBuffer.getInt());
            } else {
                ultrasoundInfo = null;
            }
            return ultrasoundInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

