/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.MotorInfo;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsEventSerializer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JE\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010 \u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006R`\u0010\u0003\u001aT\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j)\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRB\u0010\u0010\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "errorCallbackMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "", "Lkotlin/collections/HashMap;", "serviceId", "getServiceId", "()Ljava/util/UUID;", "successCallbackMap", "", "disconnect", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicRead", "status", "", "onCharacteristicWrite", "read", "motor", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Motor;", "onComplete", "onError", "Companion", "Motor", "bluetooth-android_release"})
public final class RoboticsMotorService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private final HashMap<UUID, Function1<byte[], Unit>> successCallbackMap;
    private final HashMap<UUID, Function1<BLEException, Unit>> errorCallbackMap;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    public static final int MOTOR_MESSAGE_SIZE = 9;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public void disconnect() {
        this.successCallbackMap.clear();
        this.errorCallbackMap.clear();
        super.disconnect();
    }

    public final void read(@NotNull Motor motor, @NotNull Function1<? super byte[], Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)motor), (String)"motor");
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(motor.getCharacteristic())) == null) break block2;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt != null) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl6 = false;
                ((Map)this.successCallbackMap).put(motor.getCharacteristic(), onComplete);
                ((Map)this.errorCallbackMap).put(motor.getCharacteristic(), onError);
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(bluetoothGatt3, (BluetoothGattCharacteristic)characteristic, this, onComplete, motor, onError){
                        final /* synthetic */ BluetoothGatt $bluetoothGatt;
                        final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                        final /* synthetic */ RoboticsMotorService this$0;
                        final /* synthetic */ Function1 $onComplete$inlined;
                        final /* synthetic */ Motor $motor$inlined;
                        final /* synthetic */ Function1 $onError$inlined;
                        {
                            this.$bluetoothGatt = bluetoothGatt;
                            this.$characteristic$inlined = bluetoothGattCharacteristic;
                            this.this$0 = roboticsMotorService;
                            this.$onComplete$inlined = function1;
                            this.$motor$inlined = motor;
                            this.$onError$inlined = function12;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$bluetoothGatt.readCharacteristic(this.$characteristic$inlined);
                        }
                    }));
                }
            }
        }
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
                if (status != 0) break block0;
                Function1<byte[], Unit> function1 = this.successCallbackMap.get(characteristic.getUuid());
                if (function1 == null) break block1;
                Function1<byte[], Unit> function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1<byte[], Unit> callback2 = function12;
                boolean bl3 = false;
                byte[] byArray = characteristic.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"characteristic.value");
                callback2.invoke((Object)byArray);
                this.errorCallbackMap.remove(characteristic.getUuid());
                this.successCallbackMap.remove(characteristic.getUuid());
                break block1;
            }
            Function1<BLEException, Unit> function1 = this.errorCallbackMap.get(characteristic.getUuid());
            if (function1 == null) break block1;
            Function1<BLEException, Unit> function13 = function1;
            boolean bl = false;
            boolean bl4 = false;
            Function1<BLEException, Unit> callback3 = function13;
            boolean bl5 = false;
            callback3.invoke((Object)new BLEConnectionException(status));
            this.successCallbackMap.remove(characteristic.getUuid());
            this.errorCallbackMap.remove(characteristic.getUuid());
        }
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    public RoboticsMotorService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        RoboticsMotorService roboticsMotorService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        roboticsMotorService.successCallbackMap = hashMap;
        roboticsMotorService = this;
        bl = false;
        hashMap = new HashMap();
        roboticsMotorService.errorCallbackMap = hashMap;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Motor;", "", "characteristic", "Ljava/util/UUID;", "(Ljava/lang/String;ILjava/util/UUID;)V", "getCharacteristic", "()Ljava/util/UUID;", "M1", "M2", "M3", "M4", "M5", "M6", "bluetooth-android_release"})
    public static final class Motor
    extends Enum<Motor> {
        public static final /* enum */ Motor M1;
        public static final /* enum */ Motor M2;
        public static final /* enum */ Motor M3;
        public static final /* enum */ Motor M4;
        public static final /* enum */ Motor M5;
        public static final /* enum */ Motor M6;
        private static final /* synthetic */ Motor[] $VALUES;
        @NotNull
        private final UUID characteristic;

        static {
            Motor[] motorArray = new Motor[6];
            Motor[] motorArray2 = motorArray;
            UUID uUID = UUID.fromString("4bdfb409-93cc-433a-83bd-7f4f8e7eaf54");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"4bdfb40\u2026-433a-83bd-7f4f8e7eaf54\")");
            motorArray[0] = M1 = new Motor(uUID);
            UUID uUID2 = UUID.fromString("454885b9-c9d1-4988-9893-a0437d5e6e9f");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"454885b\u2026-4988-9893-a0437d5e6e9f\")");
            motorArray[1] = M2 = new Motor(uUID2);
            UUID uUID3 = UUID.fromString("00fcd93b-0c3c-4940-aac1-b4c21fac3420");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"00fcd93\u2026-4940-aac1-b4c21fac3420\")");
            motorArray[2] = M3 = new Motor(uUID3);
            UUID uUID4 = UUID.fromString("49aaeaa4-bb74-4f84-aa8f-acf46e5cf922");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"49aaeaa\u2026-4f84-aa8f-acf46e5cf922\")");
            motorArray[3] = M4 = new Motor(uUID4);
            UUID uUID5 = UUID.fromString("ceea8e45-5ff9-4325-be13-48cf40c0e0c3");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID5, (String)"UUID.fromString(\"ceea8e4\u2026-4325-be13-48cf40c0e0c3\")");
            motorArray[4] = M5 = new Motor(uUID5);
            UUID uUID6 = UUID.fromString("8e4c474f-188e-4d2a-910a-cf66f674f569");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID6, (String)"UUID.fromString(\"8e4c474\u2026-4d2a-910a-cf66f674f569\")");
            motorArray[5] = M6 = new Motor(uUID6);
            $VALUES = motorArray;
        }

        @NotNull
        public final UUID getCharacteristic() {
            return this.characteristic;
        }

        private Motor(UUID characteristic) {
            this.characteristic = characteristic;
        }

        public static Motor[] values() {
            return (Motor[])$VALUES.clone();
        }

        public static Motor valueOf(String string) {
            return Enum.valueOf(Motor.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Companion;", "", "()V", "MOTOR_MESSAGE_SIZE", "", "SERVICE_ID", "", "getMotorInfoFromBytes", "Lorg/revolutionrobotics/bluetooth/android/service/MotorInfo;", "bytes", "", "bluetooth-android_release"})
    public static final class Companion {
        @ExperimentalUnsignedTypes
        @Nullable
        public final MotorInfo getMotorInfoFromBytes(@NotNull byte[] bytes) {
            MotorInfo motorInfo;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            if (bytes.length >= 9) {
                int n;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                int n2 = buffer.get();
                int n3 = buffer.getInt();
                float f = byteBuffer.getFloat();
                boolean bl = false;
                n2 = n = UByte.constructor-impl((byte)n2);
                bl = false;
                int n4 = n = n2 & 0xFF;
                int n5 = n3;
                float f2 = f;
                motorInfo = new MotorInfo(f2, n5, n4);
            } else {
                motorInfo = null;
            }
            return motorInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

