/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.exception.BLELongMessageIsAlreadyRunning;
import org.revolutionrobotics.bluetooth.android.exception.BLELongMessageValidationException;
import org.revolutionrobotics.bluetooth.android.exception.BLEMessageInterruptedException;
import org.revolutionrobotics.bluetooth.android.exception.BLESendingTimeoutException;
import org.revolutionrobotics.bluetooth.android.file.FileChunkHandler;
import org.revolutionrobotics.bluetooth.android.file.MD5Checker;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsConfigurationService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsEventSerializer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u000fH\u0002JI\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0#2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020)H\u0002J\u001a\u0010@\u001a\u00020\u000f2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00106\u001a\u000207H\u0016J\"\u0010C\u001a\u00020\u000f2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020\u0019H\u0016J\"\u0010E\u001a\u00020\u000f2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020\u0019H\u0016J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010F\u001a\u00020\u000fH\u0002J\b\u0010G\u001a\u00020\u000fH\u0002J?\u0010H\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0#2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nJ\b\u0010I\u001a\u00020\u000fH\u0002J\b\u0010J\u001a\u00020\u000fH\u0002J\u0010\u0010K\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020>H\u0002J\b\u0010M\u001a\u00020\u000fH\u0002J\u0012\u0010N\u001a\u00020\u000f2\b\u0010O\u001a\u0004\u0018\u000103H\u0002J\u0006\u0010P\u001a\u00020\u000fJ?\u0010Q\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0#2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nJ?\u0010R\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0#2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nJ?\u0010S\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0#2!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nJ\u0018\u0010T\u001a\u00020)2\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020\u0019H\u0002J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u000203H\u0002J\f\u0010W\u001a\u00020X*\u000203H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR7\u0010\t\u001a\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001b\"\u0004\b0\u0010\u001d\u00a8\u0006Z"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsConfigurationService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "currentFile", "Landroid/net/Uri;", "getCurrentFile", "()Landroid/net/Uri;", "setCurrentFile", "(Landroid/net/Uri;)V", "error", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "", "getError", "()Lkotlin/jvm/functions/Function1;", "setError", "(Lkotlin/jvm/functions/Function1;)V", "fileChunkHandler", "Lorg/revolutionrobotics/bluetooth/android/file/FileChunkHandler;", "md5Checker", "Lorg/revolutionrobotics/bluetooth/android/file/MD5Checker;", "mtu", "", "getMtu", "()I", "setMtu", "(I)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "success", "Lkotlin/Function0;", "getSuccess", "()Lkotlin/jvm/functions/Function0;", "setSuccess", "(Lkotlin/jvm/functions/Function0;)V", "uploadStarted", "", "getUploadStarted", "()Z", "setUploadStarted", "(Z)V", "validationCounter", "getValidationCounter", "setValidationCounter", "checkMd5", "serverMd5", "", "disconnect", "handleReadyStatus", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "handleValidationStatus", "initLongMessage", "file", "onSuccess", "onError", "functionType", "", "isUploadInProgress", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "onCharacteristicRead", "status", "onCharacteristicWrite", "readStatus", "resetVariables", "sendConfiguration", "sendFinalizeMessage", "sendNextChunk", "sendSelectLongMessage", "typeId", "startChunkSending", "startUploading", "fileMD5", "stop", "testKit", "updateFirmware", "updateFramework", "validateCharacteristicEvent", "writeMessage", "byteArray", "toStringCustom", "", "Companion", "bluetooth-android_release"})
public final class RoboticsConfigurationService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private final MD5Checker md5Checker;
    private final FileChunkHandler fileChunkHandler;
    @Nullable
    private Function0<Unit> success;
    @Nullable
    private Function1<? super BLEException, Unit> error;
    @Nullable
    private Uri currentFile;
    private int validationCounter;
    private boolean uploadStarted;
    private int mtu;
    @NotNull
    public static final String SERVICE_ID = "97148a03-5b9d-11e9-8647-d663bd873d93";
    public static final byte FUNCTION_TYPE_FIRMWARE = 1;
    public static final byte FUNCTION_TYPE_FRAMEWORK = 2;
    public static final byte FUNCTION_TYPE_CONFIGURATION = 3;
    public static final byte FUNCTION_TYPE_TESTKIT = 4;
    public static final byte MESSAGE_TYPE_SELECT = 0;
    public static final byte MESSAGE_TYPE_INIT = 1;
    public static final byte MESSAGE_TYPE_UPLOAD = 2;
    public static final byte MESSAGE_TYPE_FINALIZE = 3;
    public static final byte STATUS_UNUSED = 0;
    public static final byte STATUS_UPLOAD = 1;
    public static final byte STATUS_VALIDATION = 2;
    public static final byte STATUS_READY = 3;
    public static final byte STATUS_VALIDATION_ERROR = 4;
    public static final int MAX_VALIDATION_COUNT = 30;
    public static final int MD5_LENGTH = 16;
    public static final int DEFAULT_MTU = 512;
    public static final int MTU_DECREASE = 4;
    @NotNull
    public static final String TAG = "LongMessage";
    @NotNull
    private static final UUID CHARACTERISTIC;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Nullable
    public final Function0<Unit> getSuccess() {
        return this.success;
    }

    public final void setSuccess(@Nullable Function0<Unit> function0) {
        this.success = function0;
    }

    @Nullable
    public final Function1<BLEException, Unit> getError() {
        return this.error;
    }

    public final void setError(@Nullable Function1<? super BLEException, Unit> function1) {
        this.error = function1;
    }

    @Nullable
    public final Uri getCurrentFile() {
        return this.currentFile;
    }

    public final void setCurrentFile(@Nullable Uri uri) {
        this.currentFile = uri;
    }

    public final int getValidationCounter() {
        return this.validationCounter;
    }

    public final void setValidationCounter(int n) {
        this.validationCounter = n;
    }

    public final boolean getUploadStarted() {
        return this.uploadStarted;
    }

    public final void setUploadStarted(boolean bl) {
        this.uploadStarted = bl;
    }

    public final int getMtu() {
        return this.mtu;
    }

    public final void setMtu(int n) {
        this.mtu = n;
    }

    public final void updateFirmware(@NotNull Uri file, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.initLongMessage(file, onSuccess, onError, (byte)1);
    }

    public final void updateFramework(@NotNull Uri file, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.initLongMessage(file, onSuccess, onError, (byte)2);
    }

    public final void testKit(@NotNull Uri file, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.initLongMessage(file, onSuccess, onError, (byte)4);
    }

    public final void sendConfiguration(@NotNull Uri file, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.initLongMessage(file, onSuccess, onError, (byte)3);
    }

    public final void stop() {
        if (this.currentFile != null) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ RoboticsConfigurationService this$0;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$launch = this.p$;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)TimeUnit.SECONDS.toMillis(1L), (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            RoboticsConfigurationService.access$sendFinalizeMessage(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = roboticsConfigurationService;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.resetVariables();
        }
    }

    private final void initLongMessage(Uri file, Function0<Unit> onSuccess, Function1<? super BLEException, Unit> onError, byte functionType) {
        if (this.isUploadInProgress()) {
            onError.invoke((Object)new BLELongMessageIsAlreadyRunning());
            return;
        }
        this.currentFile = file;
        this.success = onSuccess;
        this.error = onError;
        this.sendSelectLongMessage(functionType);
    }

    private final void sendSelectLongMessage(byte typeId) {
        byte[] byArray = new byte[2];
        RoboticsConfigurationService roboticsConfigurationService = this;
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[0] = 0;
        $this$apply[1] = typeId;
        byte[] byArray2 = byArray;
        roboticsConfigurationService.writeMessage(byArray2);
    }

    private final void checkMd5(byte[] serverMd5) {
        block2: {
            byte[] currentMD5;
            Uri uri = this.currentFile;
            if (uri == null) break block2;
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri uri3 = uri2;
            boolean bl3 = false;
            byte[] byArray = currentMD5 = new MD5Checker().calculateMD5Hash(uri3);
            byte[] byArray2 = serverMd5;
            boolean bl4 = false;
            if (Arrays.equals(byArray, byArray2)) {
                this.uploadStarted = true;
                this.sendFinalizeMessage();
            } else {
                this.startUploading(currentMD5);
            }
        }
    }

    private final void readStatus() {
        block2: {
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC)) == null) break block2;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt != null) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl6 = false;
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(bluetoothGatt3, (BluetoothGattCharacteristic)characteristic, this){
                        final /* synthetic */ BluetoothGatt $bluetoothGatt;
                        final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                        final /* synthetic */ RoboticsConfigurationService this$0;
                        {
                            this.$bluetoothGatt = bluetoothGatt;
                            this.$characteristic$inlined = bluetoothGattCharacteristic;
                            this.this$0 = roboticsConfigurationService;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$bluetoothGatt.readCharacteristic(this.$characteristic$inlined);
                        }
                    }));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startUploading(byte[] fileMD5) {
        block2: {
            this.uploadStarted = true;
            Uri uri = this.currentFile;
            if (uri == null) break block2;
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri currentFile = uri2;
            boolean bl3 = false;
            byte[] byArray = fileMD5;
            if (fileMD5 == null) {
                byArray = this.md5Checker.calculateMD5Hash(currentFile);
            }
            byte[] md5 = byArray;
            Log.e((String)TAG, (String)("MD5: " + Base64.encodeToString((byte[])md5, (int)0)));
            byte[] byArray2 = new byte[17];
            boolean bl4 = false;
            boolean bl5 = false;
            byte[] $this$apply = byArray2;
            boolean bl6 = false;
            $this$apply[0] = 1;
            int n = 0;
            int n2 = 16;
            while (n < n2) {
                void index;
                $this$apply[index + true] = md5[index];
                ++index;
            }
            this.writeMessage($this$apply);
        }
    }

    private final void startChunkSending() {
        Uri uri = this.currentFile;
        if (uri != null) {
            Uri uri2 = uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri2;
            boolean bl3 = false;
            this.fileChunkHandler.init(it, this.mtu - 4, (byte)2);
        }
        this.sendNextChunk();
    }

    private final void sendNextChunk() {
        byte[] nextChunk = this.fileChunkHandler.getNextChunk();
        if (nextChunk != null) {
            this.writeMessage(nextChunk);
        } else {
            this.sendFinalizeMessage();
        }
    }

    private final void sendFinalizeMessage() {
        byte[] byArray = new byte[1];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[0] = 3;
        this.writeMessage($this$apply);
    }

    private final void writeMessage(byte[] byteArray) {
        block1: {
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC)) == null) break block1;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            characteristic.setWriteType(2);
            characteristic.setValue(byteArray);
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            boolean wasMessageSent = bluetoothGatt != null ? bluetoothGatt.writeCharacteristic((BluetoothGattCharacteristic)characteristic) : false;
            Log.d((String)TAG, (String)("Write message sent " + wasMessageSent + "  " + this.toStringCustom(byteArray)));
            if (!wasMessageSent) {
                this.onError(new BLEMessageInterruptedException());
            }
        }
    }

    private final boolean isUploadInProgress() {
        return this.currentFile != null;
    }

    private final boolean validateCharacteristicEvent(BluetoothGattCharacteristic characteristic, int status) {
        if (Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)CHARACTERISTIC) ^ true || this.currentFile == null) {
            return false;
        }
        if (status != 0) {
            this.onError(new BLEConnectionException(status));
            return false;
        }
        return true;
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
        if (!this.validateCharacteristicEvent(characteristic, status)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Read happened: ");
        byte[] byArray = characteristic.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"characteristic.value");
        Log.d((String)TAG, (String)stringBuilder.append(this.toStringCustom(byArray)).toString());
        switch (characteristic.getValue()[0]) {
            case 0: {
                Log.d((String)TAG, (String)"Unused --> start uploading");
                this.startUploading(null);
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)"Upload --> checkMd5");
                this.startUploading(null);
                break;
            }
            case 2: {
                this.handleValidationStatus();
                break;
            }
            case 3: {
                this.handleReadyStatus(characteristic);
                break;
            }
            case 4: {
                this.onError(new BLELongMessageValidationException());
            }
        }
    }

    private final void onError(BLEException exception) {
        Log.d((String)TAG, (String)"Error --> send error event");
        Function1<? super BLEException, Unit> function1 = this.error;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)exception);
        }
        this.resetVariables();
    }

    private final void handleValidationStatus() {
        Log.d((String)TAG, (String)("Validation attempt:" + this.validationCounter));
        if (this.validationCounter < 30) {
            this.readStatus();
            int n = this.validationCounter;
            this.validationCounter = n + 1;
        } else {
            this.onError(new BLESendingTimeoutException());
        }
    }

    private final void handleReadyStatus(BluetoothGattCharacteristic characteristic) {
        if (!this.uploadStarted) {
            Log.d((String)TAG, (String)"Ready --> checkMd5");
            byte[] byArray = characteristic.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"characteristic.value");
            byte[] byArray2 = byArray;
            int n = 1;
            int n2 = 17;
            RoboticsConfigurationService roboticsConfigurationService = this;
            boolean bl = false;
            byte[] byArray3 = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2);
            roboticsConfigurationService.checkMd5(byArray3);
        } else {
            Log.d((String)TAG, (String)"Ready --> send success event");
            Function0<Unit> function0 = this.success;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            this.resetVariables();
        }
    }

    private final void resetVariables() {
        this.uploadStarted = false;
        this.success = null;
        this.error = null;
        this.currentFile = null;
        this.validationCounter = 0;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.resetVariables();
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
        if (!this.validateCharacteristicEvent(characteristic, status)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Write happened! status: ").append(status).append(" First byte: ").append(characteristic.getValue()[0]).append(' ').append("Total message: ");
        byte[] byArray = characteristic.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"characteristic.value");
        Log.d((String)TAG, (String)stringBuilder.append(this.toStringCustom(byArray)).toString());
        switch (characteristic.getValue()[0]) {
            case 0: {
                Log.d((String)TAG, (String)"Select --> read status");
                this.readStatus();
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)"Init --> startChunkSending");
                this.startChunkSending();
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)"Upload --> sendNextChunk");
                this.sendNextChunk();
                break;
            }
            case 3: {
                Log.d((String)TAG, (String)"Finalize --> startStatusReadingLoop");
                this.readStatus();
            }
        }
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    private final String toStringCustom(@NotNull byte[] $this$toStringCustom) {
        return ArraysKt.joinToString$default((byte[])$this$toStringCustom, null, null, null, (int)0, null, (Function1)toStringCustom.1.INSTANCE, (int)31, null);
    }

    public RoboticsConfigurationService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        this.md5Checker = new MD5Checker();
        this.fileChunkHandler = new FileChunkHandler();
        this.mtu = 512;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("d59bb321-7218-4fb9-abac-2f6814f31a4d");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"d59bb32\u2026-4fb9-abac-2f6814f31a4d\")");
        CHARACTERISTIC = uUID;
    }

    public static final /* synthetic */ void access$sendFinalizeMessage(RoboticsConfigurationService $this) {
        $this.sendFinalizeMessage();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsConfigurationService$Companion;", "", "()V", "CHARACTERISTIC", "Ljava/util/UUID;", "getCHARACTERISTIC", "()Ljava/util/UUID;", "DEFAULT_MTU", "", "FUNCTION_TYPE_CONFIGURATION", "", "FUNCTION_TYPE_FIRMWARE", "FUNCTION_TYPE_FRAMEWORK", "FUNCTION_TYPE_TESTKIT", "MAX_VALIDATION_COUNT", "MD5_LENGTH", "MESSAGE_TYPE_FINALIZE", "MESSAGE_TYPE_INIT", "MESSAGE_TYPE_SELECT", "MESSAGE_TYPE_UPLOAD", "MTU_DECREASE", "SERVICE_ID", "", "STATUS_READY", "STATUS_UNUSED", "STATUS_UPLOAD", "STATUS_VALIDATION", "STATUS_VALIDATION_ERROR", "TAG", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getCHARACTERISTIC() {
            return CHARACTERISTIC;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

