/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.resource.ServerResource;

public abstract class Filter
extends Restlet {
    public static final int CONTINUE = 0;
    public static final int SKIP = 1;
    public static final int STOP = 2;
    private volatile Restlet next;

    public Filter() {
        this(null);
    }

    public Filter(Context context) {
        this(context, null);
    }

    public Filter(Context context, Restlet next) {
        super(context);
        this.next = next;
    }

    protected void afterHandle(Request request, Response response) {
    }

    protected int beforeHandle(Request request, Response response) {
        return 0;
    }

    protected int doHandle(Request request, Response response) {
        boolean result = false;
        if (this.getNext() != null) {
            this.getNext().handle(request, response);
            Response.setCurrent(response);
            if (this.getContext() != null) {
                Context.setCurrent(this.getContext());
            }
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            this.getLogger().warning("The filter " + this.getName() + " was executed without a next Restlet attached to it.");
        }
        return 0;
    }

    public Restlet getNext() {
        return this.next;
    }

    @Override
    public final void handle(Request request, Response response) {
        super.handle(request, response);
        switch (this.beforeHandle(request, response)) {
            case 0: {
                if (this.doHandle(request, response) != 0) break;
                this.afterHandle(request, response);
                break;
            }
            case 1: {
                this.afterHandle(request, response);
                break;
            }
        }
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public void setNext(Class<? extends ServerResource> targetClass) {
        this.setNext(this.createFinder(targetClass));
    }

    public void setNext(Restlet next) {
        if (next != null && next.getContext() == null) {
            next.setContext(this.getContext());
        }
        this.next = next;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            if (this.getNext() != null) {
                this.getNext().start();
            }
            super.start();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            super.stop();
            if (this.getNext() != null) {
                this.getNext().stop();
            }
        }
    }
}

