/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.engine.util.FormUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class FormReader {
    private volatile CharacterSet characterSet;
    private volatile boolean decode;
    private volatile char separator;
    private volatile InputStream stream;

    public FormReader(Representation representation) throws IOException {
        this(representation, true);
    }

    public FormReader(Representation representation, boolean decode) throws IOException {
        this.decode = decode;
        this.stream = representation.getStream();
        this.separator = (char)38;
        this.characterSet = representation.getCharacterSet() != null ? representation.getCharacterSet() : CharacterSet.UTF_8;
    }

    public FormReader(String parametersString, char separator) {
        this(parametersString, null, separator, false);
    }

    public FormReader(String parametersString, CharacterSet characterSet, char separator) {
        this(parametersString, characterSet, separator, true);
    }

    public FormReader(String parametersString, CharacterSet characterSet, char separator, boolean decode) {
        this.decode = decode;
        this.stream = new ByteArrayInputStream(parametersString.getBytes());
        this.characterSet = characterSet;
        this.separator = separator;
    }

    public void addParameters(Series<Parameter> parameters) {
        boolean readNext = true;
        Parameter param = null;
        if (this.stream != null) {
            try {
                while (readNext) {
                    param = this.readNextParameter();
                    if (param != null) {
                        parameters.add(param);
                        continue;
                    }
                    readNext = false;
                }
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse a form parameter. Skipping the remaining parameters.", ioe);
            }
            try {
                this.stream.close();
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to close the form input stream", ioe);
            }
        }
    }

    public Form read() throws IOException {
        Form result = new Form();
        if (this.stream != null) {
            Parameter param = this.readNextParameter();
            while (param != null) {
                result.add(param);
                param = this.readNextParameter();
            }
            this.stream.close();
        }
        return result;
    }

    public Parameter readFirstParameter(String name) throws IOException {
        Parameter result = null;
        if (this.stream != null) {
            Parameter param = this.readNextParameter();
            while (param != null && result == null) {
                if (param.getName().equals(name)) {
                    result = param;
                }
                param = this.readNextParameter();
            }
            this.stream.close();
        }
        return result;
    }

    public Parameter readNextParameter() throws IOException {
        Parameter result = null;
        if (this.stream != null) {
            try {
                boolean readingName = true;
                StringBuilder nameBuffer = new StringBuilder();
                StringBuilder valueBuffer = new StringBuilder();
                int nextChar = 0;
                while (result == null && nextChar != -1) {
                    nextChar = this.stream.read();
                    if (readingName) {
                        if (nextChar == 61) {
                            if (!nameBuffer.isEmpty()) {
                                readingName = false;
                                continue;
                            }
                            throw new IOException("Empty parameter name detected. Please check your form data");
                        }
                        if (this.endOfCurrentParameterReached(nextChar)) {
                            if (!nameBuffer.isEmpty()) {
                                result = FormUtils.create(nameBuffer, null, this.decode, this.characterSet);
                                continue;
                            }
                            if (nextChar == -1) continue;
                            Context.getCurrentLogger().fine("Empty parameter name detected. Please check your form data");
                            continue;
                        }
                        nameBuffer.append((char)nextChar);
                        continue;
                    }
                    if (this.endOfCurrentParameterReached(nextChar)) {
                        result = FormUtils.create(nameBuffer, valueBuffer, this.decode, this.characterSet);
                        continue;
                    }
                    valueBuffer.append((char)nextChar);
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new IOException("Unsupported encoding. Please contact the administrator");
            }
        }
        return result;
    }

    private boolean endOfCurrentParameterReached(int nextChar) {
        return nextChar == this.separator || nextChar == -1;
    }

    public Object readParameter(String name) throws IOException {
        Object result = null;
        if (this.stream != null) {
            Parameter param = this.readNextParameter();
            while (param != null) {
                if (param.getName().equals(name)) {
                    if (result != null) {
                        ArrayList<Object> values = null;
                        if (result instanceof List) {
                            values = (ArrayList<Object>)result;
                        } else {
                            values = new ArrayList<Object>();
                            values.add(result);
                            result = values;
                        }
                        if (param.getValue() == null) {
                            values.add(Series.EMPTY_VALUE);
                        } else {
                            values.add(param.getValue());
                        }
                    } else {
                        result = param.getValue() == null ? Series.EMPTY_VALUE : param.getValue();
                    }
                }
                param = this.readNextParameter();
            }
            this.stream.close();
        }
        return result;
    }

    public void readParameters(Map<String, Object> parameters) throws IOException {
        if (this.stream != null) {
            Parameter param = this.readNextParameter();
            Object currentValue = null;
            while (param != null) {
                if (parameters.containsKey(param.getName())) {
                    currentValue = parameters.get(param.getName());
                    if (currentValue != null) {
                        ArrayList<Object> values = null;
                        if (currentValue instanceof List) {
                            values = (ArrayList<Object>)currentValue;
                        } else {
                            values = new ArrayList<Object>();
                            values.add(currentValue);
                            parameters.put(param.getName(), values);
                        }
                        if (param.getValue() == null) {
                            values.add(Series.EMPTY_VALUE);
                        } else {
                            values.add(param.getValue());
                        }
                    } else if (param.getValue() == null) {
                        parameters.put(param.getName(), Series.EMPTY_VALUE);
                    } else {
                        parameters.put(param.getName(), param.getValue());
                    }
                }
                param = this.readNextParameter();
            }
            this.stream.close();
        }
    }
}

