/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.util.StringUtils;

public class IdentClient {
    private static final int CONNECT_TIMEOUT = 100;
    private static final int SO_TIMEOUT = 500;
    private volatile String hostType;
    private volatile String userIdentifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentClient(String clientAddress, int clientPort, int serverPort) {
        Socket socket = null;
        if (clientAddress != null && clientPort != -1 && serverPort != -1) {
            BufferedReader in = null;
            try {
                StringTokenizer st;
                String request = clientPort + " , " + serverPort + "\r\n";
                socket = new Socket();
                socket.setSoTimeout(500);
                socket.connect(new InetSocketAddress(clientAddress, 113), 100);
                socket.getOutputStream().write(StringUtils.getAsciiBytes(request));
                in = new BufferedReader(new InputStreamReader(socket.getInputStream()), IoUtils.BUFFER_SIZE);
                String response = in.readLine();
                if (response != null && (st = new StringTokenizer(response, ":")).countTokens() >= 3) {
                    st.nextToken();
                    String command = st.nextToken().trim();
                    if (command.equalsIgnoreCase("USERID") && st.countTokens() >= 2) {
                        this.hostType = st.nextToken().trim();
                        this.userIdentifier = st.nextToken("").substring(1);
                    }
                }
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.FINE, "Unable to complete the IDENT request", ioe);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.FINE, "Unable to close the socket", ioe);
                }
            }
        }
    }

    public String getHostType() {
        return this.hostType;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }
}

