/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.util.List;
import org.restlet.data.Warning;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.engine.util.DateUtils;

public class WarningWriter
extends HeaderWriter<Warning> {
    public static String write(List<Warning> warnings) {
        return ((HeaderWriter)new WarningWriter()).append(warnings).toString();
    }

    public WarningWriter append(Warning warning) {
        String agent = warning.getAgent();
        String text = warning.getText();
        if (warning.getStatus() == null) {
            throw new IllegalArgumentException("Can't write warning. Invalid status code detected");
        }
        if (agent == null || agent.isEmpty()) {
            throw new IllegalArgumentException("Can't write warning. Invalid agent detected");
        }
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("Can't write warning. Invalid text detected");
        }
        this.append(Integer.toString(warning.getStatus().getCode()));
        this.append(" ");
        this.append(agent);
        this.append(" ");
        this.appendQuotedString(text);
        if (warning.getDate() != null) {
            this.appendQuotedString(DateUtils.format(warning.getDate()));
        }
        return this;
    }
}

