/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.File;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;

public final class LocalReference
extends Reference {
    public static final int CLAP_DEFAULT = 0;
    public static final int CLAP_CLASS = 1;
    public static final int CLAP_SYSTEM = 2;
    public static final int CLAP_THREAD = 3;
    public static final int RIAP_APPLICATION = 4;
    public static final int RIAP_COMPONENT = 5;
    public static final int RIAP_HOST = 6;

    public static LocalReference createClapReference(Package pkg) {
        return LocalReference.createClapReference(0, pkg);
    }

    public static LocalReference createClapReference(int authorityType, Package pkg) {
        String pkgPath = pkg.getName().replaceAll("\\.", "/");
        return new LocalReference("clap://" + LocalReference.getAuthorityName(authorityType) + "/" + pkgPath);
    }

    public static LocalReference createClapReference(String path) {
        return LocalReference.createClapReference(0, path);
    }

    public static LocalReference createClapReference(int authorityType, String path) {
        return new LocalReference("clap://" + LocalReference.getAuthorityName(authorityType) + path);
    }

    public static LocalReference createFileReference(File file) {
        return LocalReference.createFileReference(file.getAbsolutePath());
    }

    public static LocalReference createFileReference(String filePath) {
        return LocalReference.createFileReference("", filePath);
    }

    public static LocalReference createFileReference(String hostName, String filePath) {
        return new LocalReference("file://" + hostName + "/" + LocalReference.normalizePath(filePath));
    }

    public static LocalReference createJarReference(Reference jarFile, String entryPath) {
        return new LocalReference("jar:" + jarFile.getTargetRef().toString() + "!/" + entryPath);
    }

    public static LocalReference createRiapReference(int authorityType, String path) {
        return new LocalReference("riap://" + LocalReference.getAuthorityName(authorityType) + path);
    }

    public static LocalReference createZipReference(Reference zipFile, String entryPath) {
        return new LocalReference("zip:" + zipFile.getTargetRef().toString() + "!/" + entryPath);
    }

    public static String getAuthorityName(int authority) {
        return switch (authority) {
            case 0 -> "";
            case 1 -> "class";
            case 2 -> "system";
            case 3 -> "thread";
            case 4 -> "application";
            case 5 -> "component";
            case 6 -> "host";
            default -> null;
        };
    }

    public static String localizePath(String path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char nextChar = path.charAt(i);
            if (nextChar == '/') {
                result.append(File.separatorChar);
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public static String normalizePath(String path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char nextChar = path.charAt(i);
            if (nextChar == File.separatorChar) {
                result.append('/');
                continue;
            }
            if (!LocalReference.isUnreserved(nextChar)) {
                result.append(Reference.encode("" + nextChar));
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public LocalReference(Reference localRef) {
        super(localRef.getTargetRef().toString());
    }

    public LocalReference(String localUri) {
        super(localUri);
    }

    public int getClapAuthorityType() {
        String authority;
        int result = 0;
        if (Protocol.CLAP.equals(this.getSchemeProtocol()) && (authority = this.getAuthority()) != null) {
            result = authority.equalsIgnoreCase(LocalReference.getAuthorityName(1)) ? 1 : (authority.equalsIgnoreCase(LocalReference.getAuthorityName(2)) ? 2 : (authority.equalsIgnoreCase(LocalReference.getAuthorityName(3)) ? 3 : 0));
        }
        return result;
    }

    public File getFile() {
        File result = null;
        if (Protocol.FILE.equals(this.getSchemeProtocol())) {
            String hostName = this.getAuthority();
            if (hostName == null || hostName.isEmpty() || hostName.equalsIgnoreCase("localhost")) {
                String filePath = Reference.decode(this.getPath());
                result = new File(filePath);
            } else {
                throw new RuntimeException("Can't resolve files on remote host machines");
            }
        }
        return result;
    }

    public String getJarEntryPath() {
        int separatorIndex;
        String ssp;
        String result = null;
        if (Protocol.JAR.equals(this.getSchemeProtocol()) && (ssp = this.getSchemeSpecificPart()) != null && (separatorIndex = ssp.indexOf("!/")) != -1) {
            result = ssp.substring(separatorIndex + 2);
        }
        return result;
    }

    public Reference getJarFileRef() {
        int separatorIndex;
        String ssp;
        Reference result = null;
        if (Protocol.JAR.equals(this.getSchemeProtocol()) && (ssp = this.getSchemeSpecificPart()) != null && (separatorIndex = ssp.indexOf("!/")) != -1) {
            result = new Reference(ssp.substring(0, separatorIndex));
        }
        return result;
    }

    public int getRiapAuthorityType() {
        String authority;
        int result = 0;
        if (Protocol.RIAP.equals(this.getSchemeProtocol()) && (authority = this.getAuthority()) != null) {
            if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(4))) {
                result = 4;
            } else if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(5))) {
                result = 5;
            } else if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(6))) {
                result = 6;
            }
        }
        return result;
    }
}

