/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Header;
import org.restlet.data.Parameter;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.util.Series;

public class HttpBasicHelper
extends AuthenticatorHelper {
    public HttpBasicHelper() {
        super(ChallengeScheme.HTTP_BASIC, true, true);
    }

    @Override
    public void formatRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Header> httpHeaders) throws IOException {
        String realm = challenge.getRealm();
        String charset = challenge.getParameters().getFirstValue("charset");
        if (realm != null) {
            cw.appendQuotedChallengeParameter("realm", realm);
        } else {
            this.getLogger().warning("The realm directive is required for all authentication schemes that issue a challenge.");
        }
        if (charset != null) {
            if ("UTF-8".equalsIgnoreCase(charset)) {
                cw.appendQuotedChallengeParameter("charset", "UTF-8");
            } else {
                this.getLogger().warning("The \"charset\" parameter must be \"UTF-8\" per RFC 7617.");
            }
        }
    }

    @Override
    public void formatResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        try {
            if (challenge == null) {
                throw new RuntimeException("No challenge provided, unable to encode credentials");
            }
            String charset = challenge.getParameters().getFirstValue("charset");
            if (charset != null) {
                if ("UTF-8".equalsIgnoreCase(charset)) {
                    charset = "UTF-8";
                } else {
                    this.getLogger().warning("The \"charset\" parameter must be \"UTF-8\" per RFC 7617. Using \"ISO-8859-1\" instead.");
                    charset = "ISO-8859-1";
                }
            } else {
                charset = "ISO-8859-1";
            }
            CharArrayWriter credentials = new CharArrayWriter();
            credentials.write(challenge.getIdentifier());
            credentials.write(":");
            credentials.write(challenge.getSecret());
            cw.append(Base64.getEncoder().encodeToString(IoUtils.toByteArray(credentials.toCharArray(), charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception, unable to encode credentials", e);
        }
    }

    @Override
    public void parseRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else {
                            challenge.getParameters().add(param);
                        }
                        if (hr.skipValueSeparator()) {
                            param = hr.readParameter();
                            continue;
                        }
                        param = null;
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }

    @Override
    public void parseResponse(ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        if (challenge.getRawValue() == null) {
            this.getLogger().info("Cannot decode credentials: " + challenge.getRawValue());
            return;
        }
        try {
            String charset = challenge.getParameters().getFirstValue("charset");
            if (charset != null) {
                if ("UTF-8".equalsIgnoreCase(charset)) {
                    charset = "UTF-8";
                } else {
                    this.getLogger().warning("The \"charset\" parameter must be \"UTF-8\" per RFC 7617. Using \"ISO-8859-1\" instead.");
                    charset = "ISO-8859-1";
                }
            } else {
                charset = "ISO-8859-1";
            }
            byte[] credentialsEncoded = Base64.getDecoder().decode(challenge.getRawValue());
            String credentials = new String(credentialsEncoded, charset);
            int separator = credentials.indexOf(58);
            if (separator == -1) {
                this.getLogger().info("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
            } else {
                challenge.setIdentifier(credentials.substring(0, separator));
                challenge.setSecret(credentials.substring(separator + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().log(Level.INFO, "Unsupported HTTP Basic encoding error", e);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.INFO, "Unable to decode the HTTP Basic credential", e);
        }
    }
}

