/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Range;
import org.restlet.representation.Representation;

public class RangeReader {
    private static final String BYTES_RANGE_PREFIX = "bytes ";

    public static void update(String value, Representation representation) {
        if (value != null && value.startsWith(BYTES_RANGE_PREFIX)) {
            String strLength;
            value = value.substring(BYTES_RANGE_PREFIX.length());
            int index = value.indexOf("-");
            int index1 = value.indexOf("/");
            if (index != -1) {
                long startIndex = index == 0 ? -1L : Long.parseLong(value.substring(0, index));
                long endIndex = Long.parseLong(value.substring(index + 1, index1));
                representation.setRange(new Range(startIndex, endIndex - startIndex + 1L));
            }
            if (!"*".equals(strLength = value.substring(index1 + 1))) {
                representation.setSize(Long.parseLong(strLength));
            }
        }
    }

    public static List<Range> read(String rangeHeader) {
        ArrayList<Range> result = new ArrayList<Range>();
        String prefix = "bytes=";
        if (rangeHeader != null && rangeHeader.startsWith(prefix)) {
            rangeHeader = rangeHeader.substring(prefix.length());
            String[] array = rangeHeader.split(",");
            for (int i = 0; i < array.length; ++i) {
                String value = array[i].trim();
                long index = 0L;
                long length = 0L;
                if (value.startsWith("-")) {
                    index = -1L;
                    length = Long.parseLong(value.substring(1));
                } else if (value.endsWith("-")) {
                    index = Long.parseLong(value.substring(0, value.length() - 1));
                    length = -1L;
                } else {
                    String[] tab = value.split("-");
                    if (tab.length == 2) {
                        index = Long.parseLong(tab[0]);
                        length = Long.parseLong(tab[1]) - index + 1L;
                    }
                }
                result.add(new Range(index, length));
            }
        }
        return result;
    }

    private RangeReader() {
    }
}

